/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class CheckIndex {
    public static PrintStream out;
    static boolean assertsOn;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static boolean check(Directory dir, boolean doFix) throws IOException {
        return CheckIndex.check(dir, doFix, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean check(Directory dir, boolean doFix, List onlySegments) throws IOException {
        int i;
        NumberFormat nf = NumberFormat.getInstance();
        SegmentInfos sis = new SegmentInfos();
        try {
            sis.read(dir);
        }
        catch (Throwable t) {
            out.println("ERROR: could not read any segments file in directory");
            t.printStackTrace(out);
            return false;
        }
        int numSegments = sis.size();
        String segmentsFileName = sis.getCurrentSegmentFileName();
        IndexInput input = null;
        try {
            input = dir.openInput(segmentsFileName);
        }
        catch (Throwable t) {
            out.println("ERROR: could not open segments file in directory");
            t.printStackTrace(out);
            return false;
        }
        int format = 0;
        try {
            format = input.readInt();
        }
        catch (Throwable t) {
            out.println("ERROR: could not read segment file version in directory");
            t.printStackTrace(out);
            boolean bl = false;
            return bl;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        String sFormat = "";
        boolean skip = false;
        if (format == -1) {
            sFormat = "FORMAT [Lucene Pre-2.1]";
        }
        if (format == -2) {
            sFormat = "FORMAT_LOCKLESS [Lucene 2.1]";
        } else if (format == -3) {
            sFormat = "FORMAT_SINGLE_NORM_FILE [Lucene 2.2]";
        } else if (format == -4) {
            sFormat = "FORMAT_SHARED_DOC_STORE [Lucene 2.3]";
        } else if (format == -5) {
            sFormat = "FORMAT_CHECKSUM [Lucene 2.4]";
        } else if (format == -6) {
            sFormat = "FORMAT_DEL_COUNT [Lucene 2.4]";
        } else if (format == -7) {
            sFormat = "FORMAT_HAS_PROX [Lucene 2.4]";
        } else if (format < -7) {
            sFormat = "int=" + format + " [newer version of Lucene than this tool]";
            skip = true;
        } else {
            sFormat = format + " [Lucene 1.3 or prior]";
        }
        out.println("Segments file=" + segmentsFileName + " numSegments=" + numSegments + " version=" + sFormat);
        if (onlySegments != null) {
            out.print("\nChecking only these segments:");
            Iterator it = onlySegments.iterator();
            while (it.hasNext()) {
                out.print(" " + it.next());
            }
            out.println(":");
        }
        if (skip) {
            out.println("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            return false;
        }
        SegmentInfos newSIS = (SegmentInfos)sis.clone();
        newSIS.clear();
        boolean changed = false;
        int totLoseDocCount = 0;
        int numBadSegments = 0;
        for (i = 0; i < numSegments; ++i) {
            SegmentInfo info = sis.info(i);
            if (onlySegments != null && !onlySegments.contains(info.name)) continue;
            out.println("  " + (1 + i) + " of " + numSegments + ": name=" + info.name + " docCount=" + info.docCount);
            int toLoseDocCount = info.docCount;
            IndexReader reader = null;
            try {
                int numDocs;
                String delFileName;
                out.println("    compound=" + info.getUseCompoundFile());
                out.println("    hasProx=" + info.getHasProx());
                out.println("    numFiles=" + info.files().size());
                out.println("    size (MB)=" + nf.format((double)info.sizeInBytes() / 1048576.0));
                int docStoreOffset = info.getDocStoreOffset();
                if (docStoreOffset != -1) {
                    out.println("    docStoreOffset=" + docStoreOffset);
                    out.println("    docStoreSegment=" + info.getDocStoreSegment());
                    out.println("    docStoreIsCompoundFile=" + info.getDocStoreIsCompoundFile());
                }
                if ((delFileName = info.getDelFileName()) == null) {
                    out.println("    no deletions");
                } else {
                    out.println("    has deletions [delFileName=" + delFileName + "]");
                }
                out.print("    test: open reader.........");
                reader = SegmentReader.get(info);
                toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                if (((SegmentReader)reader).hasDeletions()) {
                    if (info.docCount - numDocs != info.getDelCount()) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                    }
                    out.println("OK [" + (info.docCount - numDocs) + " deleted docs]");
                } else {
                    if (info.getDelCount() != 0) {
                        throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                    }
                    out.println("OK");
                }
                out.print("    test: fields, norms.......");
                Collection fieldNames = ((SegmentReader)reader).getFieldNames(IndexReader.FieldOption.ALL);
                Iterator it = fieldNames.iterator();
                while (it.hasNext()) {
                    String fieldName = (String)it.next();
                    byte[] b = ((SegmentReader)reader).norms(fieldName);
                    if (b.length == info.docCount) continue;
                    throw new RuntimeException("norms for field \"" + fieldName + "\" is length " + b.length + " != maxDoc " + info.docCount);
                }
                out.println("OK [" + fieldNames.size() + " fields]");
                out.print("    test: terms, freq, prox...");
                TermEnum termEnum = ((SegmentReader)reader).terms();
                TermPositions termPositions = ((SegmentReader)reader).termPositions();
                MySegmentTermDocs myTermDocs = new MySegmentTermDocs((SegmentReader)reader);
                long termCount = 0L;
                long totFreq = 0L;
                long totPos = 0L;
                while (termEnum.next()) {
                    int delCount;
                    ++termCount;
                    Term term = termEnum.term();
                    int docFreq = termEnum.docFreq();
                    termPositions.seek(term);
                    int lastDoc = -1;
                    int freq0 = 0;
                    totFreq += (long)docFreq;
                    while (termPositions.next()) {
                        ++freq0;
                        int doc = termPositions.doc();
                        int freq = termPositions.freq();
                        if (doc <= lastDoc) {
                            throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                        }
                        lastDoc = doc;
                        if (freq <= 0) {
                            throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                        }
                        int lastPos = -1;
                        totPos += (long)freq;
                        for (int j = 0; j < freq; ++j) {
                            int pos = termPositions.nextPosition();
                            if (pos < -1) {
                                throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                            }
                            if (pos >= lastPos) continue;
                            throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                        }
                    }
                    if (((SegmentReader)reader).hasDeletions()) {
                        myTermDocs.seek(term);
                        while (myTermDocs.next()) {
                        }
                        delCount = myTermDocs.delCount;
                    } else {
                        delCount = 0;
                    }
                    if (freq0 + delCount == docFreq) continue;
                    throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != num docs seen " + freq0 + " + num docs deleted " + delCount);
                }
                out.println("OK [" + termCount + " terms; " + totFreq + " terms/docs pairs; " + totPos + " tokens]");
                out.print("    test: stored fields.......");
                int docCount = 0;
                long totFields = 0L;
                for (int j = 0; j < info.docCount; ++j) {
                    if (((SegmentReader)reader).isDeleted(j)) continue;
                    ++docCount;
                    Document doc = reader.document(j);
                    totFields += (long)doc.getFields().size();
                }
                if (docCount != ((SegmentReader)reader).numDocs()) {
                    throw new RuntimeException("docCount=" + docCount + " but saw " + docCount + " undeleted docs");
                }
                out.println("OK [" + totFields + " total field count; avg " + nf.format((float)totFields / (float)docCount) + " fields per doc]");
                out.print("    test: term vectors........");
                int totVectors = 0;
                for (int j = 0; j < info.docCount; ++j) {
                    TermFreqVector[] tfv;
                    if (((SegmentReader)reader).isDeleted(j) || (tfv = ((SegmentReader)reader).getTermFreqVectors(j)) == null) continue;
                    totVectors += tfv.length;
                }
                out.println("OK [" + totVectors + " total vector count; avg " + nf.format((float)totVectors / (float)docCount) + " term/freq vector fields per doc]");
                out.println("");
            }
            catch (Throwable t) {
                out.println("FAILED");
                String comment = doFix ? "will remove reference to this segment (-fix is specified)" : "would remove reference to this segment (-fix was not specified)";
                out.println("    WARNING: " + comment + "; full exception:");
                t.printStackTrace(out);
                out.println("");
                totLoseDocCount += toLoseDocCount;
                ++numBadSegments;
                changed = true;
                continue;
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            newSIS.add(info.clone());
        }
        if (!changed) {
            out.println("No problems were detected with this index.\n");
            return true;
        }
        out.println("WARNING: " + numBadSegments + " broken segments detected");
        if (doFix) {
            out.println("WARNING: " + totLoseDocCount + " documents will be lost");
        } else {
            out.println("WARNING: " + totLoseDocCount + " documents would be lost if -fix were specified");
        }
        out.println();
        if (doFix) {
            out.println("NOTE: will write new segments file in 5 seconds; this will remove " + totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!");
            for (i = 0; i < 5; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    --i;
                    continue;
                }
                out.println("  " + (5 - i) + "...");
            }
            out.print("Writing...");
            try {
                newSIS.commit(dir);
            }
            catch (Throwable t) {
                out.println("FAILED; exiting");
                t.printStackTrace(out);
                return false;
            }
            out.println("OK");
            out.println("Wrote new segments file \"" + newSIS.getCurrentSegmentFileName() + "\"");
        } else {
            out.println("NOTE: would write new segments file [-fix was not specified]");
        }
        out.println("");
        return false;
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    public static void main(String[] args) throws Throwable {
        boolean doFix = false;
        ArrayList<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-fix")) {
                doFix = true;
                ++i;
                continue;
            }
            if (args[i].equals("-segment")) {
                if (i == args.length - 1) {
                    out.println("ERROR: missing name for -segment option");
                    System.exit(1);
                }
                onlySegments.add(args[i + 1]);
                i += 2;
                continue;
            }
            if (indexPath != null) {
                out.println("ERROR: unexpected extra argument '" + args[i] + "'");
                System.exit(1);
            }
            indexPath = args[i];
            ++i;
        }
        if (indexPath == null) {
            out.println("\nERROR: index path not specified");
            out.println("\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-fix] [-segment X] [-segment Y]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n\n**WARNING**: -fix should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -fix, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -fix were\nspecified.  With -fix, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has has any\ncorruption, else 0.\n");
            System.exit(1);
        }
        if (onlySegments.size() == 0) {
            onlySegments = null;
        } else if (doFix) {
            out.println("ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        if (!$assertionsDisabled && !CheckIndex.testAsserts()) {
            throw new AssertionError();
        }
        if (!assertsOn) {
            out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene', so assertions are enabled");
        }
        out.println("\nOpening index @ " + indexPath + "\n");
        FSDirectory dir = null;
        try {
            dir = FSDirectory.getDirectory(indexPath);
        }
        catch (Throwable t) {
            out.println("ERROR: could not open directory \"" + indexPath + "\"; exiting");
            t.printStackTrace(out);
            System.exit(1);
        }
        boolean isClean = CheckIndex.check(dir, doFix, onlySegments);
        int exitCode = isClean ? 0 : 1;
        System.exit(exitCode);
    }

    static {
        $assertionsDisabled = !CheckIndex.class.desiredAssertionStatus();
        out = System.out;
    }

    private static class MySegmentTermDocs
    extends SegmentTermDocs {
        int delCount;

        MySegmentTermDocs(SegmentReader p) {
            super(p);
        }

        public void seek(Term term) throws IOException {
            super.seek(term);
            this.delCount = 0;
        }

        protected void skippingDoc() throws IOException {
            ++this.delCount;
        }
    }
}

