/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;

public class ByteFieldSource
extends FieldCacheSource {
    FieldCache.ByteParser parser;

    public ByteFieldSource(String field) {
        this(field, null);
    }

    public ByteFieldSource(String field, FieldCache.ByteParser parser) {
        super(field);
        this.parser = parser;
    }

    public String description() {
        return "byte(" + this.field + ')';
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        final byte[] arr = this.parser == null ? this.cache.getBytes(reader, this.field) : this.cache.getBytes(reader, this.field, this.parser);
        return new DocValues(){

            public byte byteVal(int doc) {
                return arr[doc];
            }

            public short shortVal(int doc) {
                return arr[doc];
            }

            public float floatVal(int doc) {
                return arr[doc];
            }

            public int intVal(int doc) {
                return arr[doc];
            }

            public long longVal(int doc) {
                return arr[doc];
            }

            public double doubleVal(int doc) {
                return arr[doc];
            }

            public String strVal(int doc) {
                return Byte.toString(arr[doc]);
            }

            public String toString(int doc) {
                return ByteFieldSource.this.description() + '=' + this.byteVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != ByteFieldSource.class) {
            return false;
        }
        ByteFieldSource other = (ByteFieldSource)o;
        return super.equals(other) && this.parser == null ? other.parser == null : this.parser.getClass() == other.parser.getClass();
    }

    public int hashCode() {
        int h = this.parser == null ? Byte.class.hashCode() : this.parser.getClass().hashCode();
        return h += super.hashCode();
    }
}

