/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.solr.common.SolrException;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.util.OpenBitSet;

abstract class DocSetBase
implements DocSet {
    DocSetBase() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DocSet)) {
            return false;
        }
        DocSet other = (DocSet)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this instanceof DocList && other instanceof DocList) {
            DocIterator i1 = this.iterator();
            DocIterator i2 = this.iterator();
            while (i1.hasNext() && i2.hasNext()) {
                if (i1.nextDoc() == i2.nextDoc()) continue;
                return false;
            }
            return true;
        }
        return this.getBits().equals(other.getBits());
    }

    public void add(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    public void addUnique(int doc) {
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Operation");
    }

    public OpenBitSet getBits() {
        OpenBitSet bits = new OpenBitSet();
        DocIterator iter = this.iterator();
        while (iter.hasNext()) {
            bits.set(iter.nextDoc());
        }
        return bits;
    }

    public DocSet intersection(DocSet other) {
        if (other instanceof HashDocSet) {
            return other.intersection(this);
        }
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.and(other.getBits());
        return new BitDocSet(newbits);
    }

    public DocSet union(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.or(other.getBits());
        return new BitDocSet(newbits);
    }

    public int intersectionSize(DocSet other) {
        if (other instanceof HashDocSet) {
            return other.intersectionSize(this);
        }
        return this.intersection(other).size();
    }

    public int unionSize(DocSet other) {
        return this.size() + other.size() - this.intersectionSize(other);
    }

    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.getBits().clone();
        newbits.andNot(other.getBits());
        return new BitDocSet(newbits);
    }

    public int andNotSize(DocSet other) {
        return this.size() - this.intersectionSize(other);
    }
}

