/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.chronos.core.impl;

import org.seasar.chronos.core.Scheduler;
import org.seasar.chronos.core.TaskScheduleEntry;
import org.seasar.chronos.core.annotation.task.Task;
import org.seasar.chronos.core.autodetector.TaskClassAutoDetector;
import org.seasar.chronos.core.schedule.TaskScheduleEntryManager;
import org.seasar.chronos.core.task.TaskExecutorService;
import org.seasar.chronos.core.task.TaskValidator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.util.SmartDeployUtil;
import org.seasar.framework.container.util.Traversal;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScheduler
implements Scheduler {
    protected static final Logger log = Logger.getLogger(AbstractScheduler.class);
    protected S2Container s2container;
    protected TaskClassAutoDetector taskClassAutoDetector;
    private TaskValidator taskValidator;
    private boolean detectResult = false;

    protected ComponentDef findTaskComponentDefByTaskName(final String taskName) {
        TaskScheduleEntryManager tcsm = TaskScheduleEntryManager.getInstance();
        Object componentDef = tcsm.forEach(new TaskScheduleEntryManager.TaskScheduleEntryHanlder(){

            public Object processTaskScheduleEntry(TaskScheduleEntry taskScheduleEntry) {
                TaskExecutorService tes = taskScheduleEntry.getTaskExecutorService();
                String _taskName = tes.getTaskPropertyReader().getTaskName(null);
                if (taskName.equals(_taskName)) {
                    return taskScheduleEntry.getComponentDef();
                }
                return null;
            }
        });
        if (componentDef != null) {
            return (ComponentDef)componentDef;
        }
        return null;
    }

    protected boolean registerChildTaskComponent(S2Container s2Container) {
        return this.registerChildTaskComponent(s2Container, null);
    }

    protected boolean registerChildTaskComponentByTarget(S2Container s2Container, Class<?> targetTaskComponentClass) {
        return this.registerChildTaskComponent(s2Container, targetTaskComponentClass);
    }

    private boolean registerChildTaskComponent(S2Container s2Container, final Class<?> targetTaskComponentClass) {
        Object result = Traversal.forEachComponent((S2Container)s2Container, (Traversal.ComponentDefHandler)new Traversal.ComponentDefHandler(){

            public Object processComponent(ComponentDef componentDef) {
                Class clazz = componentDef.getComponentClass();
                if (clazz != null && AbstractScheduler.this.taskValidator.isValid(clazz)) {
                    if (targetTaskComponentClass == null) {
                        AbstractScheduler.this.scheduleTask(componentDef);
                    } else if (targetTaskComponentClass.equals(componentDef.getComponentClass())) {
                        return AbstractScheduler.this.scheduleTask(componentDef, true);
                    }
                }
                return null;
            }
        });
        return result != null;
    }

    protected abstract void registerTaskFromS2Container();

    protected boolean registerTaskFromS2ContainerOnSmartDeploy(S2Container s2Container) {
        return this.registerTaskFromS2ContainerOnSmartDeploy(s2Container, null);
    }

    protected boolean registerTaskFromS2ContainerOnSmartDeployByTarget(S2Container s2Container, Class<?> targetTaskComponentClass) {
        return this.registerTaskFromS2ContainerOnSmartDeploy(s2Container, targetTaskComponentClass);
    }

    protected boolean registerJavascriptTaskComponent() {
        return false;
    }

    private boolean registerTaskFromS2ContainerOnSmartDeploy(final S2Container s2Container, final Class<?> targetTaskComponentClass) {
        this.detectResult = false;
        if (SmartDeployUtil.isSmartdeployMode((S2Container)s2Container)) {
            this.taskClassAutoDetector.detect(new ClassTraversal.ClassHandler(){

                public void processClass(String packageName, String shortClassName) {
                    String name = ClassUtil.concatName((String)packageName, (String)shortClassName);
                    Class clazz = ReflectionUtil.forNameNoException((String)name);
                    if (targetTaskComponentClass == null) {
                        if (AbstractScheduler.this.scheduleTask(s2Container, clazz) != null) {
                            AbstractScheduler.this.detectResult = true;
                        }
                    } else if (targetTaskComponentClass.equals(clazz) && AbstractScheduler.this.scheduleTask(s2Container, clazz, true) != null) {
                        AbstractScheduler.this.detectResult = true;
                    }
                }
            });
        }
        return this.detectResult;
    }

    protected TaskScheduleEntry scheduleTask(ComponentDef componentDef) {
        return this.scheduleTask(componentDef, false);
    }

    protected TaskScheduleEntry scheduleTask(ComponentDef taskComponentDef, boolean force) {
        Class clazz = taskComponentDef.getComponentClass();
        Task task = clazz.getAnnotation(Task.class);
        if (!task.autoSchedule() && !force) {
            return null;
        }
        TaskScheduleEntry taskScheduleEntry = (TaskScheduleEntry)this.s2container.getComponent(TaskScheduleEntry.class);
        taskScheduleEntry.setComponentDef(taskComponentDef);
        TaskExecutorService tes = (TaskExecutorService)this.s2container.getComponent(TaskExecutorService.class);
        taskScheduleEntry.setTaskExecutorService(tes);
        tes.setComponentDef(taskComponentDef);
        tes.setGetterSignal(this);
        tes.setScheduler(this);
        return taskScheduleEntry;
    }

    protected TaskScheduleEntry scheduleTask(S2Container s2Container, Class<?> taskClass, boolean force) {
        ComponentDef componentDef = s2Container.getComponentDef(taskClass);
        return this.scheduleTask(componentDef, force);
    }

    protected TaskScheduleEntry scheduleTask(S2Container s2Container, Class<?> taskClass) {
        ComponentDef componentDef = s2Container.getComponentDef(taskClass);
        return this.scheduleTask(componentDef);
    }

    public void setS2Container(S2Container s2container) {
        this.s2container = s2container;
    }

    public void setTaskClassAutoDetector(TaskClassAutoDetector taskClassAutoDetector) {
        this.taskClassAutoDetector = taskClassAutoDetector;
    }

    public void setTaskValidator(TaskValidator taskValidator) {
        this.taskValidator = taskValidator;
    }
}

