/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class FunctionQuery
extends Query {
    ValueSource func;

    public FunctionQuery(ValueSource func) {
        this.func = func;
    }

    public ValueSource getValueSource() {
        return this.func;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    protected Weight createWeight(Searcher searcher) {
        return new FunctionWeight(searcher);
    }

    public String toString(String field) {
        float boost = this.getBoost();
        return ((double)boost != 1.0 ? "(" : "") + this.func.toString() + ((double)boost == 1.0 ? "" : ")^" + boost);
    }

    public boolean equals(Object o) {
        if (FunctionQuery.class != o.getClass()) {
            return false;
        }
        FunctionQuery other = (FunctionQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.func.equals(other.func);
    }

    public int hashCode() {
        return this.func.hashCode() * 31 + Float.floatToIntBits(this.getBoost());
    }

    protected class AllScorer
    extends Scorer {
        final IndexReader reader;
        final FunctionWeight weight;
        final int maxDoc;
        final float qWeight;
        int doc;
        final DocValues vals;
        final boolean hasDeletions;

        public AllScorer(Similarity similarity, IndexReader reader, FunctionWeight w) throws IOException {
            super(similarity);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.reader = reader;
            this.maxDoc = reader.maxDoc();
            this.hasDeletions = reader.hasDeletions();
            this.vals = FunctionQuery.this.func.getValues(reader);
        }

        public boolean next() throws IOException {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                return false;
            } while (this.hasDeletions && this.reader.isDeleted(this.doc));
            return true;
        }

        public int doc() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.qWeight * this.vals.floatVal(this.doc);
        }

        public boolean skipTo(int target) throws IOException {
            this.doc = target - 1;
            return this.next();
        }

        public Explanation explain(int doc) throws IOException {
            float sc = this.qWeight * this.vals.floatVal(doc);
            ComplexExplanation result = new ComplexExplanation(true, sc, "FunctionQuery(" + FunctionQuery.this.func + "), product of:");
            result.addDetail(this.vals.explain(doc));
            result.addDetail(new Explanation(FunctionQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    protected class FunctionWeight
    implements Weight {
        Searcher searcher;
        float queryNorm;
        float queryWeight;

        public FunctionWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return FunctionQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = FunctionQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new AllScorer(FunctionQuery.this.getSimilarity(this.searcher), reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return this.scorer(reader).explain(doc);
        }
    }
}

