/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.params.SolrParams;

class FieldFacet {
    String field;
    int offset;
    int limit;
    int minCount;
    boolean sort;
    boolean missing;
    String prefix;
    long missingCount;

    FieldFacet() {
    }

    void fillParams(SolrParams params, String field) {
        this.field = field;
        this.offset = params.getFieldInt(field, "facet.offset", 0);
        this.limit = params.getFieldInt(field, "facet.limit", 100);
        Integer mincount = params.getFieldInt(field, "facet.mincount");
        if (mincount == null) {
            Boolean zeros = params.getFieldBool(field, "facet.zeros");
            mincount = zeros != null && zeros == false ? 1 : 0;
        }
        this.minCount = mincount;
        this.missing = params.getFieldBool(field, "facet.missing", false);
        this.sort = params.getFieldBool(field, "facet.sort", this.limit > 0);
        this.prefix = params.getFieldParam(field, "facet.prefix");
    }
}

