/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Map;
import java.util.Properties;
import org.apache.solr.core.CoreContainer;

public class CoreDescriptor
implements Cloneable {
    protected String name;
    protected String instanceDir;
    protected String configName;
    protected String schemaName;
    private final CoreContainer coreContainer;
    private Properties coreProperties;

    public CoreDescriptor(CoreContainer coreContainer, String name, String instanceDir) {
        this.coreContainer = coreContainer;
        this.name = name;
        if (name == null) {
            throw new RuntimeException("Core needs a name");
        }
        if (instanceDir == null) {
            throw new NullPointerException("Missing required 'instanceDir'");
        }
        if (!instanceDir.endsWith("/")) {
            instanceDir = instanceDir + "/";
        }
        this.instanceDir = instanceDir;
        this.configName = this.getDefaultConfigName();
        this.schemaName = this.getDefaultSchemaName();
    }

    public CoreDescriptor(CoreDescriptor descr) {
        this.instanceDir = descr.instanceDir;
        this.configName = descr.configName;
        this.schemaName = descr.schemaName;
        this.name = descr.name;
        this.coreContainer = descr.coreContainer;
    }

    private Properties initImplicitProperties() {
        Properties implicitProperties = new Properties(this.coreContainer.getContainerProperties());
        implicitProperties.setProperty("solr.core.name", this.name);
        implicitProperties.setProperty("solr.core.instanceDir", this.instanceDir);
        implicitProperties.setProperty("solr.core.configName", this.configName);
        implicitProperties.setProperty("solr.core.schemaName", this.schemaName);
        return implicitProperties;
    }

    public String getDefaultConfigName() {
        return "solrconfig.xml";
    }

    public String getDefaultSchemaName() {
        return "schema.xml";
    }

    public String getDefaultDataDir() {
        return this.instanceDir + "data/";
    }

    public String getInstanceDir() {
        return this.instanceDir;
    }

    public void setConfigName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.configName = name;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setSchemaName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name can not be null or empty");
        }
        this.schemaName = name;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getName() {
        return this.name;
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    Properties getCoreProperties() {
        return this.coreProperties;
    }

    void setCoreProperties(Properties coreProperties) {
        if (this.coreProperties == null) {
            Properties p = this.initImplicitProperties();
            this.coreProperties = new Properties(p);
            this.coreProperties.putAll((Map<?, ?>)coreProperties);
        }
    }
}

