/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchStemmer;

public final class FrenchStemFilter
extends TokenFilter {
    private FrenchStemmer stemmer = new FrenchStemmer();
    private Set exclusions = null;

    public FrenchStemFilter(TokenStream in) {
        super(in);
    }

    public FrenchStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next(Token reusableToken) throws IOException {
        String s;
        assert (reusableToken != null);
        Token nextToken = this.input.next(reusableToken);
        if (nextToken == null) {
            return null;
        }
        String term = nextToken.term();
        if (!(this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
            nextToken.setTermBuffer(s);
        }
        return nextToken;
    }

    public void setStemmer(FrenchStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(Hashtable exclusiontable) {
        this.exclusions = new HashSet(exclusiontable.keySet());
    }
}

