/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.util;

import java.nio.charset.Charset;

public class UrlDecoder {
    public static String decode(String s, Charset charset) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuilder buf = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    buf.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 2];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            ++pos;
                            if ((i += 3) >= numChars || (c = s.charAt(i)) == '%') continue;
                            bytes[pos] = (byte)c;
                            ++pos;
                            if (++i >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        buf.append(new String(bytes, 0, pos, charset));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            buf.append(c);
            ++i;
        }
        return needToChange ? buf.toString() : s;
    }
}

