/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.image;

import org.mobylet.core.config.MobyletInjectionConfig;
import org.mobylet.core.image.ScaleType;
import org.mobylet.core.util.StringUtils;

public class ImageConfig
extends MobyletInjectionConfig {
    public static final String PKEY_IMGPATH = "img";
    public static final String PKEY_AUTOSCALE = "autoScale";
    public static final String PKEY_SCALETYPE = "scaleType";
    public static final String PVAL_AUTOSCALE = "on";
    public static final String PKEY_WIDTH = "w";
    public static final String CONFIG_KEY_LOCAL_BASE_DIR = "image.local.base.dir";
    public static final String CONFIG_KEY_CACHE_BASE_DIR = "image.cache.base.dir";
    public static final String CONFIG_KEY_SCALE_SERVLET_PATH = "image.scale.servlet.path";
    public static final String CONFIG_KEY_DEFAULT_SCALETYPE = "image.default.scaletype";
    public static final String CONFIG_KEY_DEFAULT_SCALE_IMAGE_WIDTH = "image.default.scale.image.width";
    protected ScaleType defScaleType;

    public String getLocalBaseDirPath() {
        return this.getConfig().getProperty(CONFIG_KEY_LOCAL_BASE_DIR);
    }

    public String getCacheBaseDirPath() {
        return this.getConfig().getProperty(CONFIG_KEY_CACHE_BASE_DIR);
    }

    public boolean useScaleServlet() {
        return StringUtils.isNotEmpty(this.getScaleServletPath());
    }

    public String getScaleServletPath() {
        return this.getConfig().getProperty(CONFIG_KEY_SCALE_SERVLET_PATH);
    }

    public ScaleType getDefaultScaleType() {
        if (this.defScaleType == null) {
            String scaleTypeStr = this.getConfig().getProperty(CONFIG_KEY_DEFAULT_SCALETYPE);
            if (StringUtils.isNotEmpty(scaleTypeStr)) {
                this.defScaleType = ScaleType.valueOf(scaleTypeStr);
                if (this.defScaleType == null) {
                    this.defScaleType = ScaleType.FITWIDTH;
                }
            } else {
                this.defScaleType = ScaleType.FITWIDTH;
            }
        }
        return this.defScaleType;
    }

    public String getDefaultScaleImageWidth() {
        return this.getConfig().getProperty(CONFIG_KEY_DEFAULT_SCALE_IMAGE_WIDTH);
    }

    @Override
    public String getConfigName() {
        return "mobylet.image.properties";
    }
}

