/*
 * Decompiled with CFR 0.152.
 */
package org.mobylet.core.emoji;

import java.util.HashMap;
import java.util.Map;
import org.mobylet.core.Carrier;
import org.mobylet.core.util.StringUtils;

public class Emoji {
    protected Carrier carrier;
    protected String name;
    protected char[] c = new char[]{'\u0000'};
    protected char[] substitutionChars;
    protected Map<Carrier, Emoji> map;

    public Emoji(Carrier carrier, char c) {
        this(carrier, null);
        this.c[0] = c;
    }

    public Emoji(Carrier carrier, String substitutionChars) {
        this.carrier = carrier;
        if (StringUtils.isNotEmpty(substitutionChars)) {
            this.substitutionChars = substitutionChars.toCharArray();
        }
        this.map = new HashMap<Carrier, Emoji>();
        this.relate(this.carrier, this);
    }

    public void relate(Carrier carrier, Emoji emoji) {
        this.map.put(carrier, emoji);
    }

    public Emoji getRelated(Carrier carrier) {
        return this.map.get((Object)carrier);
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public char[] getCodes() {
        if (this.c[0] != '\u0000') {
            return this.c;
        }
        return this.substitutionChars;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Emoji) {
            return this.carrier == ((Emoji)obj).carrier && this.c == ((Emoji)obj).c;
        }
        return super.equals(obj);
    }
}

