/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Locale;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public class ThaiWordFilter
extends TokenFilter {
    private BreakIterator breaker = BreakIterator.getWordInstance(new Locale("th"));
    private Token thaiToken = null;

    public ThaiWordFilter(TokenStream input) {
        super(input);
    }

    public Token next(Token reusableToken) throws IOException {
        Token nextToken;
        assert (reusableToken != null);
        if (this.thaiToken != null) {
            int start = this.breaker.current();
            int end = this.breaker.next();
            if (end != -1) {
                reusableToken.reinit(this.thaiToken, this.thaiToken.termBuffer(), start, end - start);
                reusableToken.setStartOffset(this.thaiToken.startOffset() + start);
                reusableToken.setEndOffset(this.thaiToken.endOffset() + end);
                return reusableToken;
            }
            this.thaiToken = null;
        }
        if ((nextToken = this.input.next(reusableToken)) == null || nextToken.termLength() == 0) {
            return null;
        }
        String text = nextToken.term();
        if (Character.UnicodeBlock.of(text.charAt(0)) != Character.UnicodeBlock.THAI) {
            nextToken.setTermBuffer(text.toLowerCase());
            return nextToken;
        }
        this.thaiToken = (Token)nextToken.clone();
        this.breaker.setText(text);
        int end = this.breaker.next();
        if (end != -1) {
            nextToken.setTermBuffer(text, 0, end);
            nextToken.setEndOffset(nextToken.startOffset() + end);
            return nextToken;
        }
        return null;
    }
}

