/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataImporter;
import org.apache.solr.handler.dataimport.Evaluator;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.util.DateMathParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorBag {
    public static final String DATE_FORMAT_EVALUATOR = "formatDate";
    public static final String URL_ENCODE_EVALUATOR = "encodeUrl";
    public static final String SQL_ESCAPE_EVALUATOR = "escapeSql";
    static final Pattern FORMAT_METHOD = Pattern.compile("^(\\w*?)\\((.*?)\\)$");
    static Pattern IN_SINGLE_QUOTES = Pattern.compile("^'(.*?)'$");
    static DateMathParser dateMathParser = new DateMathParser(TimeZone.getDefault(), Locale.getDefault());

    public static Evaluator getSqlEscapingEvaluator() {
        return new Evaluator(){

            public String evaluate(VariableResolver resolver, String expression) {
                Object o = resolver.resolve(expression);
                if (o == null) {
                    return null;
                }
                return o.toString().replaceAll("'", "''").replaceAll("\"", "\"\"");
            }
        };
    }

    public static Evaluator getUrlEvaluator() {
        return new Evaluator(){

            public String evaluate(VariableResolver resolver, String expression) {
                Object value = null;
                try {
                    value = resolver.resolve(expression);
                    if (value == null) {
                        return null;
                    }
                    return URLEncoder.encode(value.toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new DataImportHandlerException(500, "Unable to encode expression: " + expression + " with value: " + value, e);
                }
            }
        };
    }

    public static Evaluator getDateFormatEvaluator() {
        return new Evaluator(){
            Map<String, CacheEntry> cache = new HashMap<String, CacheEntry>();
            Pattern FORMAT_METHOD = Pattern.compile("^(.*?),(.*?)$");

            public String evaluate(VariableResolver resolver, String expression) {
                CacheEntry e = this.getCachedData(expression);
                String expr = e.key;
                SimpleDateFormat fmt = e.format;
                Matcher m = IN_SINGLE_QUOTES.matcher(expr);
                if (m.find()) {
                    String datemathExpr = m.group(1);
                    try {
                        Date date = dateMathParser.parseMath(datemathExpr);
                        return fmt.format(date);
                    }
                    catch (ParseException exp) {
                        throw new DataImportHandlerException(500, "Invalid expression for date", exp);
                    }
                }
                Object o = resolver.resolve(expr);
                if (o == null) {
                    return "";
                }
                Date date = null;
                if (o instanceof Date) {
                    date = (Date)o;
                } else {
                    String s = o.toString();
                    try {
                        date = DataImporter.DATE_TIME_FORMAT.parse(s);
                    }
                    catch (ParseException exp) {
                        throw new DataImportHandlerException(500, "Invalid expression for date", exp);
                    }
                }
                return fmt.format(date);
            }

            private CacheEntry getCachedData(String str) {
                CacheEntry result = this.cache.get(str);
                if (result != null) {
                    return result;
                }
                Matcher m = this.FORMAT_METHOD.matcher(str);
                if (m.find()) {
                    String expr = m.group(1).trim();
                    if (IN_SINGLE_QUOTES.matcher(expr).find()) {
                        expr = expr.replaceAll("NOW", "");
                    }
                    String pattern = m.group(2).trim();
                    this.cache.put(str, new CacheEntry(expr, new SimpleDateFormat(pattern)));
                    return this.cache.get(str);
                }
                throw new DataImportHandlerException(500, "Invalid format String : ${dataimporter.functions." + str + "}");
            }
        };
    }

    static Map<String, Object> getFunctionsNamespace(final VariableResolver resolver, final Map<String, Evaluator> evaluators) {
        return new HashMap<String, Object>(){

            @Override
            public String get(Object key) {
                if (key == null) {
                    return null;
                }
                Matcher m = FORMAT_METHOD.matcher((String)key);
                if (!m.find()) {
                    return null;
                }
                String fname = m.group(1);
                Evaluator evaluator = (Evaluator)evaluators.get(fname);
                if (evaluator == null) {
                    return null;
                }
                return evaluator.evaluate(resolver, m.group(2));
            }
        };
    }

    static class CacheEntry {
        public String key;
        public SimpleDateFormat format;

        public CacheEntry(String key, SimpleDateFormat format) {
            this.key = key;
            this.format = format;
        }
    }
}

