
# Makefile fragment for e-pTeX and web2c.  -- h_kitagawa2001@yahoo.co.jp
# This file is derived by ptex.mk, by Mr. Tsuchimura.

Makefile: $(srcdir)/eptexdir/eptex.mk


eptex = @JPTEX@ eptex

# Extract eptex version
eptexdir/eptex.version: 
	test -d eptexdir || mkdir eptexdir
	grep "+@d epTeX_version==" $(srcdir)/eptexdir/eptex-base-tl08-*.diff \
          | sed "s/+@d epTeX_version=='-//;s/'//" > eptexdir/eptex.version

# The C sources.
eptex_c = eptexini.c eptex0.c eptex1.c eptex2.c
eptex_o = eptexini.o eptex0.o eptex1.o eptex2.o eptex-pool.o \
          eptexextra.o eptexdir/kanji.o
eplib_o = eptexdir/printversion.o eptexdir/usage.o eptexdir/openclose.o
eplib   = eptexdir/plib.a

# Making eptex.
eptex: $(eptex_o) $(eplib) $(ptexenc)
	$(kpathsea_link) $(eptex_o) $(eplib) $(ptexenc) $(socketlibs) $(LOADLIBES)


# C file dependencies
$(eptex_c) eptexcoerce.h eptexd.h: eptex.p $(web2c_texmf)
	$(web2c) eptex
eptexextra.c: eptexdir/eptexextra.h lib/texmfmp.c
	sed s/TEX-OR-MF-OR-MP/eptex/ $(srcdir)/lib/texmfmp.c >$@
eptexdir/eptexextra.h: eptexdir/ptexextra.in eptexdir/eptex.version ptexdir/ptex.version
	sed s/PTEX-VERSION/`cat ptexdir/ptex.version`-`cat eptexdir/eptex.version`/ \
          $(srcdir)/eptexdir/ptexextra.in >$@

# Tangling
eptex.p eptex.pool: tangle eptex.web
	$(TANGLE) eptex.web

# Generation of the web and ch file.
#   Rules:
eptex.web: tie etex.p 
	$(TIE) -m eptex.web etex.web etex.ch $(srcdir)/eptexdir/eptex-base.ch \
          $(srcdir)/eptexdir/ptex-include.ch \
          $(srcdir)/eptexdir/fam256.ch
# fp.ch and fam256.ch are not related with e-TeX extexsion.
eptex-pool.c: eptex.pool $(makecpool) tmf-pool.h
	$(makecpool) eptex.pool $(srcdir)/tmf-pool.h >$@ || rm -f $@


$(eplib): $(eplib_o)
	rm -f $@
	$(AR) $(ARFLAGS) $@ $(eplib_o)
	$(RANLIB) $@

# Additional dependencies for relinking.
$(ptexenc):
	cd $(ptexenc_dir) && $(MAKE) libptexenc.la

# Cleaning up.
clean:: eptex-clean
eptex-clean: 
	$(LIBTOOL) --mode=clean $(RM) $(ptex)
	rm -f $(eptex_o) $(eptex_c) eptexextra.c eptexcoerce.h eptexd.h
	rm -f eptexdir/eptexextra.h 
	rm -f eptexdir/kanji.o $(eplib_o) $(eplib)
	rm -f eptex.p eptex.pool eptex.web eptex.ch 
	rm -f eptex.fmt eptex.log
	rm -f hello.dvi hello.log xfoo.out openout.log one.two.log uno.log
	rm -f just.log batch.log write18.log mltextst.log texput.log
	rm -f missfont.log
	rm -rf tfm
# Dumps
all_epfmts = eptex.fmt eplatex.fmt $(epfmts)

dumps: @JPTEX@ epfmts
epfmts: $(all_epfmts)

epfmtdir = $(web2cdir)/eptex
$(epfmtdir)::
	$(SHELL) $(top_srcdir)/../mkinstalldirs $(epfmtdir)

eptex.fmt: eptex
	$(dumpenv) $(MAKE) progname=ptex files="eptex.src plain.tex cmr10.tfm" prereq-check
	$(dumpenv) ./eptex -etex --progname=ptex --jobname=eptex --ini \*\\input eptex.src \\dump </dev/null

eplatex.fmt: ptex
	$(dumpenv) $(MAKE) progname=platex files="platex.ltx" prereq-check
	$(dumpenv) ./eptex -etex --progname=platex --jobname=eplatex --ini \*\\input platex.ltx </dev/null

# Install
install-eptex: install-eptex-exec install-eptex-data
install-eptex-exec: install-eptex-programs install-eptex-links
install-eptex-data: @FMU@ install-eptex-dumps
install-eptex-dumps: install-eptex-fmts

install-programs: @JPTEX@ install-eptex-programs
install-eptex-programs: $(eptex) $(bindir)
	for p in $(eptex); do $(INSTALL_LIBTOOL_PROG) $$p $(bindir); done

install-links: @JPTEX@ install-eptex-links
install-eptex-links: install-eptex-programs

install-fmts: @JPTEX@ install-eptex-fmts
install-eptex-fmts: epfmts $(epfmtdir)
	epfmts="$(all_epfmts)"; \
	  for f in $$epfmts; do $(INSTALL_DATA) $$f $(epfmtdir)/$$f; done
	epfmts="$(epfmts)"; \
	  for f in $$epfmts; do base=`basename $$f .fmt`; \
	    (cd $(bindir) && (rm -f $$base; $(LN) eptex $$base)); done

install-data:: @JPTEX@ install-eptex-data
install-eptex-pool: eptex.pool $(texpooldir)
	$(INSTALL_DATA) eptex.pool $(texpooldir)/eptex.pool

# end of eptex.mk
