/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.entity.test;

import java.io.IOException;
import java.text.ParseException;
import java.util.TooManyListenersException;

import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jp.ac.naka.ec.EntityCollaborator;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityType;

/**
 * Cxg\邾EntityBeXgpB
 * 
 * @author Takashi Kasuya
 * 
 */
public class MessageDumperEntity extends AbstractEntity {

	JTextArea field;

	JFrame frame;

	public MessageDumperEntity() {
		// L[[h̐ݒ
		addKeyword("test");
		// JFrameȂ
		frame = new JFrame("MethodDumper");
		frame.setSize(200, 200);
		field = new JTextArea();
		frame.getContentPane().add(new JScrollPane(field));
		frame.setVisible(true);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setEntityType(EntityType.ACTUATOR);
	}

	@Override
	public void receiveMessage(EntityEvent e) {
		StringBuilder st = new StringBuilder();
		st.append(field.getText());
		// getMessage()ŎMbZ[W̎擾
		st.append(e.getMessage() + "\n");
		// \
		field.setText(st.toString());
	}

	public static void main(String[] args) {
		EntityCollaborator ec = EntityCollaborator.getInstance();
		try {
			ec.initiateSipCore();
			ec.initiateDHT("192.168.1.26");
			ec.addEntity(new MessageDumperEntity());
		} catch (Exception e) {
			e.printStackTrace();
		} 
		ec.addEntity(new MessageDumperEntity());
	}
}
