/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip.pidf;

import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.Tuple;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PIDFParserImpl
implements ErrorHandler {
    private static DocumentBuilder db;
    private static PIDFParserImpl instance;

    static {
        instance = new PIDFParserImpl();
    }

    private PIDFParserImpl() {
    }

    public static PIDFParserImpl getInatance() throws ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        db = dbf.newDocumentBuilder();
        db.setErrorHandler(instance);
        return instance;
    }

    public PIDFData parse(String pidf) throws SAXException, ParseException, IOException {
        return this.parse(pidf.getBytes());
    }

    public PIDFData parse(byte[] content) throws SAXException, ParseException, IOException {
        Node t;
        Document doc = db.parse(new ByteArrayInputStream(content), "UTF-8");
        Element root = doc.getDocumentElement();
        NamedNodeMap oAttrs = root.getAttributes();
        String entity = oAttrs.getNamedItem("entity").getNodeValue();
        if (entity == null || entity.equals("null")) {
            throw new NullPointerException("Entity attribute is null.");
        }
        SipURI uri = PIDFParserImpl.createSipURI(entity);
        PIDFData data = new PIDFData((URI)uri);
        NodeList list = root.getElementsByTagName("tuple");
        this.procTuple(list, data);
        Node node = root.getLastChild();
        while (node.getNodeType() == 1 && node.getNodeName().equals("note")) {
            data.addNote(this.getNote(node));
            node = node.getPreviousSibling();
        }
        NodeList nodes = root.getElementsByTagName("message");
        node = nodes.item(0);
        if (node != null) {
            t = node.getFirstChild();
            String msg = t.getNodeValue();
            data.setMessage(msg);
        }
        if ((node = (nodes = root.getElementsByTagName("location")).item(0)) != null) {
            t = node.getFirstChild();
            String name = t.getFirstChild().getNodeValue();
            t = t.getNextSibling();
            String lat = t.getFirstChild().getNodeValue();
            t = t.getNextSibling();
            String lon = t.getFirstChild().getNodeValue();
            Location location = new Location(name, lat, lon);
            data.setLocation(location);
            if (nodes.item(1) != null) {
                System.err.println("Invalid Location tag, Ignored.");
            }
        }
        return data;
    }

    public static SipURI createSipURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        try {
            StringMsgParser smp = new StringMsgParser();
            SipUri sipUri = smp.parseSIPUrl(uri);
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    private void procTuple(NodeList list, PIDFData data) throws SAXException, ParseException {
        int i = 0;
        while (i < list.getLength()) {
            Tuple tuple = new Tuple();
            Element element = (Element)list.item(i);
            NamedNodeMap oAttrs = element.getAttributes();
            String tupleId = oAttrs.getNamedItem("id").getNodeValue();
            if (tupleId == null) {
                throw new IllegalArgumentException("No tuple id.");
            }
            tuple.id = tupleId;
            NodeList tList = element.getChildNodes();
            int j = 0;
            while (j < tList.getLength()) {
                Node element1 = tList.item(j);
                if (element1.getNodeType() == 1) {
                    if (element1.getNodeName().equals("status")) {
                        NodeList eList = element1.getChildNodes();
                        int k = 0;
                        while (k < eList.getLength()) {
                            Node element2 = eList.item(k);
                            if (element2.getNodeType() == 1) {
                                String nodeName = element2.getNodeName();
                                if (nodeName.equals("basic")) {
                                    String basic = element2.getFirstChild().getNodeValue();
                                    tuple.status.basic = basic.equals("OPEN") ? Tuple.Basic.OPEN : Tuple.Basic.CLOSE;
                                } else if (nodeName.equals("alive")) {
                                    String alive = element2.getFirstChild().getNodeValue();
                                    if (alive.indexOf("YES") != -1) {
                                        tuple.setAlive(true);
                                    } else {
                                        tuple.setAlive(false);
                                    }
                                }
                            }
                            ++k;
                        }
                    } else if (element1.getNodeName().equals("contact")) {
                        SipUri uri = new SipUri();
                        String temp = element1.getFirstChild().getNodeValue();
                        StringTokenizer stToken = new StringTokenizer(temp, "@:");
                        String scheme = stToken.nextToken();
                        if (!scheme.equals("sip") && !scheme.equals("pres")) {
                            throw new IllegalArgumentException("Bad uri scheme :" + scheme);
                        }
                        String user = stToken.nextToken();
                        String host = stToken.nextToken();
                        int port = Integer.parseInt(stToken.nextToken());
                        uri.setUser(user);
                        uri.setHost(host);
                        uri.setPort(port);
                        tuple.contact = uri;
                    } else if (element1.getNodeName().equals("note")) {
                        tuple.addNote(element1.getFirstChild().getNodeValue());
                    } else if (element1.getNodeName().equals("timestamp")) {
                        tuple.timestamp = element1.getFirstChild().getNodeValue();
                    } else {
                        tuple.putExtension(element1.getNodeName(), element1.getFirstChild().getNodeValue());
                    }
                }
                ++j;
            }
            data.addTuple(tuple);
            ++i;
        }
    }

    private String getNote(Node node) {
        return node.getFirstChild().getNodeValue();
    }

    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException {
        String pidf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><presence xmlns=\"urn:ietf:params:xml:ns:pidf\" entity=\"sip:1kasuya@localhost:5060\"><tuple id=\"1kasuya0000\"><status><alive>YES</alive></status><keyword>button,hoge</keyword><name>1kasuya</name><type>SENSOR</type><contact>sip:1kasuya@localhost:5060</contact><timestamp>2007-04-108T13:46:08Z</timestamp></tuple><message>test</message></presence>";
        PIDFParserImpl parse = PIDFParserImpl.getInatance();
        try {
            PIDFData data = parse.parse(pidf);
            System.out.println(new EntityImpl(data));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

