/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TooManyListenersException;
import javax.sdp.SessionDescription;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.SubscriptionStateHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.sip.DefaultListener;
import jp.ac.naka.ec.sip.SipConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SipCore {
    private SipProvider provider;
    private MessageFactory messageFactory;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private static SipCore instance = new SipCore();
    public static int DEFAULT_EXPIRES = 6000;
    public static String event_package = "presence";
    private static Map<String, Dialog> dialogTable = new HashMap<String, Dialog>();
    private static final String pathname = "gov.nist";
    public static int PORT = 5060;
    public static String TRANSPORT = "udp";
    private static Log logger = LogFactory.getLog(SipCore.class);
    Random rand = new Random();

    public void initialize(String hostname, int sip_port) throws SipException, IOException, ParseException, InvalidArgumentException, TooManyListenersException {
        if (this.provider != null) {
            return;
        }
        PORT = this.getValidPort(sip_port);
        SipFactory sipFactory = SipFactory.getInstance();
        sipFactory.setPathName(pathname);
        Properties prop = SipConfiguration.getDefaultConfigurationProperties();
        SipStack sipStack = null;
        sipStack = sipFactory.createSipStack(prop);
        this.addressFactory = sipFactory.createAddressFactory();
        logger.info((Object)("Initiate SipCore at " + hostname + ":" + sip_port));
        ListeningPoint lp = sipStack.createListeningPoint(hostname, sip_port, TRANSPORT);
        this.provider = sipStack.createSipProvider(lp);
        DefaultListener sip_listener = new DefaultListener();
        this.provider.addSipListener((SipListener)sip_listener);
        this.messageFactory = sipFactory.createMessageFactory();
        this.headerFactory = sipFactory.createHeaderFactory();
    }

    private int getValidPort(int port) {
        return port;
    }

    public static SipCore getInstance() {
        return instance;
    }

    public void sendResponse(int num, Request req) throws ParseException, InvalidArgumentException, SipException {
        Response res = this.messageFactory.createResponse(num, req);
        FromHeader from = (FromHeader)res.getHeader("From");
        logger.info((Object)("Sending Response (" + num + ") to " + from.getAddress()));
        this.provider.sendResponse(res);
    }

    public void sendResponse(int num, RequestEvent evt, String sender_uri) throws ParseException, SipException, InvalidArgumentException {
        ServerTransaction st;
        Request req = evt.getRequest();
        Response res = this.messageFactory.createResponse(num, req);
        if (req.getMethod().equals("SUBSCRIBE")) {
            this.prepareResponse(res);
            ExpiresHeader expiresHeader = req.getExpires();
            int expires = expiresHeader.getExpires() - 1;
            res.setHeader((Header)this.headerFactory.createExpiresHeader(expires));
        }
        if ((st = evt.getServerTransaction()) == null) {
            st = this.provider.getNewServerTransaction(req);
        }
        logger.info((Object)("Sending Response (" + num + ") to " + sender_uri));
        st.sendResponse(res);
        if (req.getMethod().equals("REGISTER")) {
            return;
        }
        Dialog dialog = st.getDialog();
        if (req.getMethod().equals("SUBSCRIBE") || req.getMethod().equals("NOTIFY")) {
            dialogTable.put(sender_uri, dialog);
        } else if (req.getMethod().equals("BYE")) {
            FromHeader from = (FromHeader)req.getHeader("From");
            String target = from.getAddress().getURI().toString();
            dialogTable.remove(target);
        } else if (num == 100) {
            dialogTable.put(sender_uri, dialog);
            dialog.setApplicationData((Object)st);
        }
    }

    public void sendResponse(SessionDescription sdp, Request req, SipURI target, SipURI source) {
        Response res = null;
        try {
            res = this.messageFactory.createResponse(200, req);
            ContentTypeHeader type = this.headerFactory.createContentTypeHeader("application", "sdp");
            res.setContent((Object)sdp, type);
            Address contact_addr = this.addressFactory.createAddress((URI)source);
            contact_addr.setDisplayName(source.getUser());
            ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
            res.setHeader((Header)contact);
            String uri = target.toString();
            Dialog dialog = dialogTable.get(uri);
            ServerTransaction st = null;
            if (dialog == null) {
                st = this.provider.getNewServerTransaction(req);
                dialog = st.getDialog();
                dialogTable.put(target.toString(), dialog);
                dialog.setApplicationData((Object)st);
            } else {
                st = (ServerTransaction)dialog.getApplicationData();
            }
            st.sendResponse(res);
            logger.info((Object)("Sending Response 200(OK) to " + uri));
        }
        catch (Exception e1) {
            logger.warn((Object)"Error while creating Response", (Throwable)e1);
            return;
        }
    }

    private void prepareResponse(Response res) throws ParseException, InvalidArgumentException {
        ToHeader to = (ToHeader)res.getHeader("To");
        FromHeader from = (FromHeader)res.getHeader("From");
        Random rand = new Random();
        to.setTag(String.valueOf(rand.nextInt(999999)));
        ContactHeader contact = this.headerFactory.createContactHeader(from.getAddress());
        res.setHeader((Header)contact);
    }

    public void sendRequest(Entity target, Entity source, String method) throws SipException {
        Dialog dialog = dialogTable.get(target.getURI().toString());
        if (dialog == null || dialog.getState() == null || dialog.getState().getValue() > DialogState.EARLY.getValue()) {
            Request req = this.createRequest(target, source, method);
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            ct.sendRequest();
            dialog = ct.getDialog();
            if (dialog != null) {
                dialogTable.put(target.getURI().toString(), dialog);
            }
        } else {
            Request req = dialog.createRequest(method);
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
        }
        logger.info((Object)("Sending " + method + " to " + target.getURI()));
    }

    public void sendRequest(String message, Entity target, Entity source, String method) throws SipException, ParseException {
        String name = target.getURI().toString();
        if (method.equals("MESSAGE")) {
            Request req = this.createRequest(target, source, method);
            FromHeader from = (FromHeader)req.getHeader("From");
            Address addr = this.addressFactory.createAddress((URI)source.getURI());
            addr.setDisplayName(source.getName());
            from.setAddress(addr);
            req.setContent((Object)message, this.headerFactory.createContentTypeHeader("text", "plain"));
            this.provider.sendRequest(req);
            logger.info((Object)("Sending MESSAGE Request to " + target.getURI()));
        } else if (method.equals("NOTIFY")) {
            SubscriptionStateHeader state = this.headerFactory.createSubscriptionStateHeader("Active");
            EventHeader event = this.headerFactory.createEventHeader(event_package);
            Dialog dialog = dialogTable.get(name);
            Request req = dialog.createRequest(method);
            ContentTypeHeader contentType = this.headerFactory.createContentTypeHeader("application", "pidf+xml");
            req.setContent((Object)message, contentType);
            req.setHeader((Header)state);
            req.setHeader((Header)event);
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
        } else {
            logger.warn((Object)("Invalid Operation :" + method));
        }
    }

    public void sendInvite(SessionDescription sdp, Entity target, Entity source) throws SipException, ParseException {
        Dialog dialog = dialogTable.get(target.getURI().toString());
        Address contact_addr = this.addressFactory.createAddress((URI)source.getURI());
        ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
        if (dialog == null || dialog.getState() == null || dialog.getState().getValue() > DialogState.EARLY.getValue()) {
            String name = target.getURI().toString();
            Request req = this.createRequest(target, source, "INVITE");
            req.setHeader((Header)contact);
            if (sdp != null) {
                req.setContent((Object)sdp, this.headerFactory.createContentTypeHeader("application", "sdp"));
            } else {
                req.setContent((Object)"", this.headerFactory.createContentTypeHeader("application", "sdp"));
            }
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            ct.sendRequest();
            dialogTable.put(name, ct.getDialog());
        } else {
            Request req = dialog.createRequest("INVITE");
            req.setHeader((Header)contact);
            if (sdp != null) {
                req.setContent((Object)sdp, this.headerFactory.createContentTypeHeader("application", "sdp"));
            } else {
                req.setContent((Object)"", this.headerFactory.createContentTypeHeader("application", "sdp"));
            }
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
        }
        logger.info((Object)("Sending INVITE Request to " + target.getURI()));
    }

    public void sendSubscribe(Entity target, Entity source, int expire) throws SipException {
        Dialog dialog = dialogTable.get(target.getURI().toString());
        if (dialog == null || dialog.getState() == null || dialog.getState().getValue() > DialogState.EARLY.getValue()) {
            Request req = this.createRequest(target, source, "SUBSCRIBE");
            try {
                ExpiresHeader expires = this.headerFactory.createExpiresHeader(expire);
                req.setExpires(expires);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            ct.sendRequest();
            dialog = ct.getDialog();
            if (dialog != null) {
                dialogTable.put(target.getURI().toString(), dialog);
            }
        } else {
            Request req = dialog.createRequest("SUBSCRIBE");
            try {
                ExpiresHeader expires = this.headerFactory.createExpiresHeader(expire);
                req.setExpires(expires);
                EventHeader event = this.headerFactory.createEventHeader(event_package);
                req.setHeader((Header)event);
                Address contact_addr = this.addressFactory.createAddress((URI)source.getURI());
                contact_addr.setDisplayName(source.getName());
                ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
            catch (Exception e) {
                throw new SipException(e.getMessage());
            }
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
            if (expire == 0) {
                dialogTable.remove(target.getURI().toString());
            }
        }
        logger.info((Object)("Sending SUBSCRIBE Request to " + target.getURI()));
    }

    public void sendBye(Entity target) throws SipException {
        Dialog dialog = dialogTable.get(target.getURI().toString());
        if (dialog == null) {
            throw new NullPointerException("Dialog of " + target.toString() + " is null!");
        }
        try {
            Request req = dialog.createRequest("BYE");
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            dialog.sendRequest(ct);
            dialogTable.remove(target.getURI().toString());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        logger.info((Object)("Sending BYE to " + target.getURI()));
    }

    public void sendAck(Entity target) {
        Dialog dialog = dialogTable.get(target.getURI().toString());
        try {
            Request ack = dialog.createAck(dialog.getLocalSeqNumber());
            logger.info((Object)("Send ACK to " + dialog.getRemoteTarget()));
            dialog.sendAck(ack);
        }
        catch (Exception e1) {
            logger.warn((Object)"Error while sending ACK", (Throwable)e1);
        }
    }

    private Request createRequest(Entity target, Entity source, String method) throws SipException {
        Request req;
        Address toAddress = target.getContactURI() == null ? this.addressFactory.createAddress((URI)target.getURI()) : this.addressFactory.createAddress((URI)target.getContactURI());
        String branch = null;
        String tag = "" + this.rand.nextInt(100000000);
        try {
            ToHeader to = this.headerFactory.createToHeader(toAddress, null);
            Address fromAddress = this.addressFactory.createAddress((URI)source.getURI());
            fromAddress.setDisplayName(source.getName());
            FromHeader from = this.headerFactory.createFromHeader(fromAddress, tag);
            CSeqHeader cSeq = this.headerFactory.createCSeqHeader(1L, method);
            CallIdHeader callId = this.provider.getNewCallId();
            MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            String ipAddr = this.provider.getListeningPoint(TRANSPORT).getIPAddress();
            int port = this.provider.getListeningPoint(TRANSPORT).getPort();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(ipAddr, port, TRANSPORT, branch);
            viaHeaders.add(viaHeader);
            req = this.messageFactory.createRequest(to.getAddress().getURI(), method, callId, cSeq, from, to, viaHeaders, maxForwards);
            if (method.equals("SUBSCRIBE")) {
                EventHeader event = this.headerFactory.createEventHeader(event_package);
                req.setHeader((Header)event);
                Address contact_addr = this.addressFactory.createAddress((URI)source.getURI());
                contact_addr.setDisplayName(source.getName());
                ContactHeader contact = this.headerFactory.createContactHeader(contact_addr);
                req.setHeader((Header)contact);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SipException(e.getMessage());
        }
        return req;
    }
}

