/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import java.io.UnsupportedEncodingException;
import javax.sdp.SdpFactory;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Response;
import jp.ac.naka.ec.entity.AbstractEntity;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResponseDelegate {
    private EntityContainer container;
    private SipCore core = SipCore.getInstance();
    private static SdpFactory factory = SdpFactory.getInstance();
    private static Log logger = LogFactory.getLog(ResponseDelegate.class);

    public ResponseDelegate() {
        this.container = EntityContainerImpl.getInstance();
    }

    public boolean forward(ResponseEvent evt) {
        Response response = evt.getResponse();
        StatusCode code = this.getStatusCode(response.getStatusCode());
        boolean a = false;
        switch (code) {
            case CODE1xx: {
                break;
            }
            case CODE2xx: {
                this.doSuccessResponse(evt);
                a = true;
                break;
            }
            case CODE3xx: {
                break;
            }
            case CODE4xx: {
                this.doErrorResponse(evt);
                break;
            }
            case CODE5xx: {
                this.doErrorResponse(evt);
                a = true;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return a;
    }

    public void doSuccessResponse(ResponseEvent evt) {
        Response res = evt.getResponse();
        try {
            CSeqHeader cseq = (CSeqHeader)res.getHeader("CSeq");
            if (res.getStatusCode() == 200) {
                if (cseq.getMethod().equals("INVITE")) {
                    this.doInviteResponse(res);
                } else if (cseq.getMethod().equals("NOTIFY")) {
                    this.doNotifyResponse(res);
                } else if (cseq.getMethod().equals("SUBSCRIBE")) {
                    this.doSubscribeResponse(res);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void doInviteResponse(Response res) throws UnsupportedEncodingException, SdpParseException {
        FromHeader from = (FromHeader)res.getHeader("From");
        ToHeader to = (ToHeader)res.getHeader("To");
        SipURI target_uri = (SipURI)from.getAddress().getURI();
        SipURI source_uri = (SipURI)to.getAddress().getURI();
        EntityImpl source = new EntityImpl(source_uri);
        Entity target = this.container.getEntity(target_uri.toString());
        this.core.sendAck(source);
        SessionDescription sdp = null;
        byte[] raw = res.getRawContent();
        if (raw == null) {
            throw new NullPointerException("Answer SDP is null");
        }
        String sdp_str = new String(raw, "UTF-8");
        sdp = factory.createSessionDescription(sdp_str);
        ((AbstractEntity)target).handleEvent(new EntityEvent(sdp, source));
    }

    private void doNotifyResponse(Response res) {
    }

    private void doSubscribeResponse(Response res) {
    }

    void authentication(ResponseEvent evt) {
    }

    void doErrorResponse(ResponseEvent evt) {
        Response res = evt.getResponse();
        logger.warn((Object)("Error Response : " + res.getReasonPhrase()));
        if (res.getStatusCode() == 401) {
            return;
        }
        FromHeader from = (FromHeader)res.getHeader("From");
        ToHeader to = (ToHeader)res.getHeader("To");
        SipURI target_uri = (SipURI)from.getAddress().getURI();
        SipURI source_uri = (SipURI)to.getAddress().getURI();
        EntityImpl source = new EntityImpl(source_uri);
        Entity target = this.container.getEntity(target_uri.toString());
        EntityEvent e = new EntityEvent(target, source, EntityEvent.EventType.ERROR);
        e.setStatusCode(res.getStatusCode());
        e.setMessage(res.getReasonPhrase());
        if (target instanceof AbstractEntity) {
            ((AbstractEntity)target).handleEvent(e);
        } else {
            target.receiveErrorResponse(e);
        }
        if (res.getStatusCode() == 503) {
            try {
                this.core.sendBye(target);
            }
            catch (SipException e1) {
                e1.printStackTrace();
            }
        }
    }

    private StatusCode getStatusCode(int code) {
        String c = String.valueOf(code);
        if (c.indexOf("1") == 0) {
            return StatusCode.CODE1xx;
        }
        if (c.indexOf("2") == 0) {
            return StatusCode.CODE2xx;
        }
        if (c.indexOf("3") == 0) {
            return StatusCode.CODE3xx;
        }
        if (c.indexOf("4") == 0) {
            return StatusCode.CODE4xx;
        }
        if (c.indexOf("5") == 0) {
            return StatusCode.CODE5xx;
        }
        if (c.indexOf("6") == 0) {
            return StatusCode.CODE6xx;
        }
        throw new IllegalAccessError("Invalid Response code!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StatusCode {
        CODE1xx,
        CODE2xx,
        CODE3xx,
        CODE4xx,
        CODE5xx,
        CODE6xx;

    }
}

