/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sensor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.sensor.Device;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataImpl;
import jp.ac.naka.ec.sensor.SensorDataParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SensorDataParserImpl
implements SensorDataParser,
ErrorHandler {
    private static DocumentBuilder db;
    private static SensorDataParserImpl instance;

    static {
        instance = new SensorDataParserImpl();
    }

    private SensorDataParserImpl() {
    }

    public static SensorDataParser getInstance() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        db = dbf.newDocumentBuilder();
        db.setErrorHandler(instance);
        return instance;
    }

    public SensorData parse(String eiml) throws SAXException, IOException {
        return this.parse(eiml.getBytes());
    }

    public SensorData parse(byte[] content) throws SAXException, IOException {
        Document doc = db.parse(new ByteArrayInputStream(content), "UTF-8");
        Element root = doc.getDocumentElement();
        return this.parse(root);
    }

    public SensorData parse(Element root) {
        SensorDataImpl data = new SensorDataImpl();
        String name = root.getAttribute("name");
        String temp = root.getAttribute("ttl");
        long ttl = 60L;
        if (temp != null && !temp.equals("")) {
            ttl = Long.valueOf(temp);
        }
        NodeList list = root.getElementsByTagName("device");
        Device device = this.getDevice(list);
        list = root.getElementsByTagName("location");
        Location location = this.getLocation(list.item(0));
        list = root.getElementsByTagName("data");
        Node node = list.item(0);
        String data_name = null;
        String type = null;
        String measure = null;
        String value = null;
        if (node != null) {
            NamedNodeMap oAttrs = node.getAttributes();
            data_name = oAttrs.getNamedItem("name").getNodeValue();
            type = oAttrs.getNamedItem("type").getNodeValue();
            measure = oAttrs.getNamedItem("measure").getNodeValue();
            value = node.getFirstChild().getNodeValue();
        }
        data.setName(name);
        data.setTTL(ttl);
        data.setDevice(device);
        data.setLocation(location);
        data.setDataName(data_name);
        if (type != null) {
            data.setDataType(SensorData.DataType.valueOf(type));
        }
        data.setMeasure(measure);
        data.setData(value);
        return data;
    }

    private Location getLocation(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap oAttrs = node.getAttributes();
        String name = oAttrs.getNamedItem("name").getNodeValue();
        String lat = oAttrs.getNamedItem("latitude").getNodeValue();
        String lon = oAttrs.getNamedItem("longitude").getNodeValue();
        Location location = name != null ? new Location(name, lat, lon) : new Location(lat, lon);
        return location;
    }

    private Device getDevice(NodeList list) {
        return null;
    }

    public void error(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void fatalError(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
    }

    public static void main(String[] arg) {
    }
}

