/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;

public class RTPSocketAdapter
implements RTPConnector {
    DatagramSocket dataSock;
    DatagramSocket ctrlSock;
    InetAddress addr;
    int port;
    SockInputStream dataInStrm = null;
    SockInputStream ctrlInStrm = null;
    SockOutputStream dataOutStrm = null;
    SockOutputStream ctrlOutStrm = null;

    public RTPSocketAdapter(InetAddress addr, int port) throws IOException {
        this(addr, port, 1);
    }

    public RTPSocketAdapter(InetAddress addr, int port, int ttl) throws IOException {
        try {
            if (addr.isMulticastAddress()) {
                this.dataSock = new MulticastSocket(port);
                this.ctrlSock = new MulticastSocket(port + 1);
                ((MulticastSocket)this.dataSock).joinGroup(addr);
                ((MulticastSocket)this.dataSock).setTimeToLive(ttl);
                ((MulticastSocket)this.ctrlSock).joinGroup(addr);
                ((MulticastSocket)this.ctrlSock).setTimeToLive(ttl);
            } else {
                this.dataSock = new DatagramSocket(port, InetAddress.getLocalHost());
                this.ctrlSock = new DatagramSocket(port + 1, InetAddress.getLocalHost());
            }
        }
        catch (SocketException e) {
            throw new IOException(e.getMessage());
        }
        this.addr = addr;
        this.port = port;
    }

    public PushSourceStream getDataInputStream() throws IOException {
        if (this.dataInStrm == null) {
            this.dataInStrm = new SockInputStream(this.dataSock, this.addr, this.port);
            this.dataInStrm.start();
        }
        return this.dataInStrm;
    }

    public OutputDataStream getDataOutputStream() throws IOException {
        if (this.dataOutStrm == null) {
            this.dataOutStrm = new SockOutputStream(this.dataSock, this.addr, this.port);
        }
        return this.dataOutStrm;
    }

    public PushSourceStream getControlInputStream() throws IOException {
        if (this.ctrlInStrm == null) {
            this.ctrlInStrm = new SockInputStream(this.ctrlSock, this.addr, this.port + 1);
            this.ctrlInStrm.start();
        }
        return this.ctrlInStrm;
    }

    public OutputDataStream getControlOutputStream() throws IOException {
        if (this.ctrlOutStrm == null) {
            this.ctrlOutStrm = new SockOutputStream(this.ctrlSock, this.addr, this.port + 1);
        }
        return this.ctrlOutStrm;
    }

    public void close() {
        if (this.dataInStrm != null) {
            this.dataInStrm.kill();
        }
        if (this.ctrlInStrm != null) {
            this.ctrlInStrm.kill();
        }
        this.dataSock.close();
        this.ctrlSock.close();
    }

    public void setReceiveBufferSize(int size) throws IOException {
        this.dataSock.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() {
        try {
            return this.dataSock.getReceiveBufferSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setSendBufferSize(int size) throws IOException {
        this.dataSock.setSendBufferSize(size);
    }

    public int getSendBufferSize() {
        try {
            return this.dataSock.getSendBufferSize();
        }
        catch (Exception e) {
            return -1;
        }
    }

    public double getRTCPBandwidthFraction() {
        return -1.0;
    }

    public double getRTCPSenderBandwidthFraction() {
        return -1.0;
    }

    class SockInputStream
    extends Thread
    implements PushSourceStream {
        DatagramSocket sock;
        InetAddress addr;
        int port;
        boolean done = false;
        boolean dataRead = false;
        SourceTransferHandler sth = null;

        public SockInputStream(DatagramSocket sock, InetAddress addr, int port) {
            this.sock = sock;
            this.addr = addr;
            this.port = port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buffer, int offset, int length) {
            DatagramPacket p = new DatagramPacket(buffer, offset, length, this.addr, this.port);
            try {
                this.sock.receive(p);
            }
            catch (IOException e) {
                return -1;
            }
            SockInputStream sockInputStream = this;
            synchronized (sockInputStream) {
                this.dataRead = true;
                this.notify();
            }
            return p.getLength();
        }

        public synchronized void start() {
            super.start();
            if (this.sth != null) {
                this.dataRead = true;
                this.notify();
            }
        }

        public synchronized void kill() {
            this.done = true;
            this.notify();
        }

        public int getMinimumTransferSize() {
            return 2048;
        }

        public synchronized void setTransferHandler(SourceTransferHandler sth) {
            this.sth = sth;
            this.dataRead = true;
            this.notify();
        }

        public ContentDescriptor getContentDescriptor() {
            return null;
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean endOfStream() {
            return false;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (!this.done) {
                block9: {
                    SockInputStream sockInputStream = this;
                    synchronized (sockInputStream) {
                        while (true) {
                            while (true) {
                                if (this.dataRead || this.done) {
                                    this.dataRead = false;
                                    break block9;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                if (this.sth == null || this.done) continue;
                this.sth.transferData((PushSourceStream)this);
            }
        }
    }

    class SockOutputStream
    implements OutputDataStream {
        DatagramSocket sock;
        InetAddress addr;
        int port;

        public SockOutputStream(DatagramSocket sock, InetAddress addr, int port) {
            this.sock = sock;
            this.addr = addr;
            this.port = port;
        }

        public int write(byte[] data, int offset, int len) {
            try {
                this.sock.send(new DatagramPacket(data, offset, len, this.addr, this.port));
            }
            catch (Exception e) {
                return -1;
            }
            return len;
        }
    }
}

