/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;

public class DeviceInfo {
    public static Format formatMatches(Format format, Format[] supported) {
        if (supported == null) {
            return null;
        }
        int i = 0;
        while (i < supported.length) {
            if (supported[i].matches(format)) {
                return supported[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean setFormat(DataSource dataSource, Format format) {
        boolean formatApplied = false;
        FormatControl[] formatControls = null;
        formatControls = ((CaptureDevice)dataSource).getFormatControls();
        int x = 0;
        while (x < formatControls.length) {
            Format[] supportedFormats;
            if (formatControls[x] != null && (supportedFormats = formatControls[x].getSupportedFormats()) != null && DeviceInfo.formatMatches(format, supportedFormats) != null) {
                formatControls[x].setFormat(format);
                formatApplied = true;
            }
            ++x;
        }
        return formatApplied;
    }

    public static boolean isVideo(Format format) {
        return format instanceof VideoFormat;
    }

    public static boolean isAudio(Format format) {
        return format instanceof AudioFormat;
    }

    public static String formatToString(Format format) {
        if (DeviceInfo.isVideo(format)) {
            return DeviceInfo.videoFormatToString((VideoFormat)format);
        }
        if (DeviceInfo.isAudio(format)) {
            return DeviceInfo.audioFormatToString((AudioFormat)format);
        }
        return "--- unknown media device format ---";
    }

    public static String videoFormatToString(VideoFormat videoFormat) {
        StringBuffer result = new StringBuffer();
        Dimension d = videoFormat.getSize();
        result.append("size=" + (int)d.getWidth() + "x" + (int)d.getHeight() + ", ");
        result.append("encoding=" + videoFormat.getEncoding() + ", ");
        result.append("maxdatalength=" + videoFormat.getMaxDataLength());
        return result.toString();
    }

    public static String audioFormatToString(AudioFormat audioFormat) {
        StringBuffer result = new StringBuffer();
        result.append(audioFormat.toString().toLowerCase());
        return result.toString();
    }
}

