/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.sdp.SessionDescription;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityInformation;
import jp.ac.naka.ec.entity.EntityType;
import jp.ac.naka.ec.sensor.SensorData;
import jp.ac.naka.ec.sensor.SensorDataImpl;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.Tuple;

public class EntityImpl
implements Entity {
    private SipURI uri;
    private String name;
    private String description;
    private ArrayList<String> keywords = new ArrayList();
    private EntityType entityType = EntityType.SENSOR;
    private boolean local = true;
    private EntityContainer container;
    private Location location;
    private List<SensorData> sensors = new ArrayList<SensorData>();
    private static SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-DD");
    private static SimpleDateFormat format2 = new SimpleDateFormat("kk:mm:ss");
    private static TimeZone timezone = TimeZone.getTimeZone("Europe/London");
    private static Calendar cal = Calendar.getInstance(timezone);
    private static final String pattern1 = "yyyy-MM-DD";
    private static final String pattern2 = "kk:mm:ss";
    private static final String zone = "Europe/London";
    private SipURI contact;

    public EntityImpl() {
    }

    public EntityImpl(SipURI uri) {
        this.setURI(uri);
        this.setName(uri.getUser());
    }

    public EntityImpl(String uri) throws ParseException {
        this(EntityImpl.createSipURI(uri));
    }

    public EntityImpl(String user, String host) throws ParseException {
        this(EntityImpl.createSipURI(user, host));
    }

    public EntityImpl(EntityInformation info) throws ParseException {
        SensorData[] data;
        SipURI uri = EntityImpl.createSipURI(info.getUri());
        this.setName(uri.getUser());
        this.setURI(uri);
        this.setDescrpition(info.getDescription());
        this.setEntityType(EntityType.valueOf(info.getServiceType()));
        SensorData[] sensorDataArray = data = info.getSensors();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            SensorData sensor = sensorDataArray[n2];
            this.addSensorData(sensor);
            ++n2;
        }
        this.setLocal(false);
    }

    public EntityImpl(PIDFData data) {
        Tuple tuple = data.getTuples().get(0);
        this.setURI((SipURI)tuple.contact);
        this.setName((String)tuple.getExtension("name"));
        this.setEntityType(EntityType.valueOf((String)tuple.getExtension("type")));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescrpition(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SipURI getURI() {
        return this.uri;
    }

    public void setURI(SipURI uri) {
        this.uri = uri;
    }

    public EntityContainer getContainer() {
        return this.container;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public boolean sendBye(Entity target) {
        return false;
    }

    public boolean sendMessage(String msg) {
        return false;
    }

    public boolean sendMessage(String msg, Entity target) {
        return false;
    }

    public boolean sendOffer(SessionDescription sdp, Entity target) {
        return false;
    }

    public boolean sendOffer(Entity target) {
        return false;
    }

    public void setEntityType(EntityType type) {
        this.entityType = type;
    }

    public boolean isLocal() {
        return this.local;
    }

    public void receiveAck(EntityEvent e) {
    }

    public void receiveAnswer(EntityEvent e) {
    }

    public void receiveBye(EntityEvent e) {
    }

    public void receiveMessage(EntityEvent e) {
    }

    public SessionDescription receiveOffer(EntityEvent e) {
        return null;
    }

    public void register(EntityEvent e) {
    }

    public void setLocal(boolean b) {
        this.local = b;
    }

    public String toString() {
        return "uri:" + this.uri + ", type:" + (Object)((Object)this.entityType) + ", description:" + this.description;
    }

    public static SipURI createSipURI(String uri) throws ParseException {
        if (uri == null) {
            throw new NullPointerException("null URI");
        }
        try {
            StringMsgParser smp = new StringMsgParser();
            SipUri sipUri = smp.parseSIPUrl(uri);
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public static SipURI createSipURI(String user, String host) throws ParseException {
        if (host == null) {
            throw new NullPointerException("null host");
        }
        StringBuffer uriString = new StringBuffer("sip:");
        if (user != null) {
            uriString.append(user);
            uriString.append("@");
        }
        if (host.indexOf(58) != host.lastIndexOf(58) && host.trim().charAt(0) != '[') {
            host = String.valueOf('[') + host + ']';
        }
        uriString.append(host);
        StringMsgParser smp = new StringMsgParser();
        try {
            SipUri sipUri = smp.parseSIPUrl(uriString.toString());
            return sipUri;
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public void addKeyword(String str) {
        this.keywords.add(str);
    }

    public boolean removeKeyword(String msg) {
        return this.keywords.remove(msg);
    }

    public String[] getKeywords() {
        String[] keys = new String[this.keywords.size()];
        this.keywords.toArray(keys);
        return keys;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entity) {
            Entity entity = (Entity)obj;
            return this.getURI().toString().equals(entity.getURI().toString());
        }
        return false;
    }

    public void setEntityContainer(EntityContainer impl) {
        this.container = impl;
    }

    public boolean subscribe(Entity target) {
        return false;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void expired(EntityEvent e) {
    }

    public void receiveErrorResponse(EntityEvent ee) {
    }

    public boolean unsubscribe(Entity target) {
        return false;
    }

    public void receiveNotify(EntityEvent e) {
    }

    public void receiveSubscribe(EntityEvent e) {
    }

    public String createPIDF() {
        EntityImpl source = this;
        SipURI uri = source.getURI();
        PIDFData data = new PIDFData((URI)uri);
        if (source.getLocation() != null) {
            data.setLocation(source.getLocation());
        }
        Date date = cal.getTime();
        Tuple tuple = new Tuple();
        tuple.contact = source.getURI();
        tuple.id = source.getName();
        EntityType ee = source.getEntityType();
        tuple.putExtension("type", ee.toString());
        tuple.putExtension("name", source.getName());
        StringBuilder builder = new StringBuilder();
        String[] keywords = source.getKeywords();
        int i = 0;
        while (i < keywords.length) {
            String keyword = keywords[i];
            builder.append(keyword);
            if (++i >= keywords.length) continue;
            builder.append(",");
        }
        tuple.putExtension("keyword", builder.toString());
        tuple.addNote(source.getDescription());
        tuple.timestamp = String.valueOf(format1.format(date)) + "T" + format2.format(date) + "Z";
        data.addTuple(tuple);
        return data.toString();
    }

    public boolean removeSensorData(SensorData sensor) {
        return this.sensors.remove(sensor);
    }

    public void addSensorData(SensorData data) {
        this.sensors.add(data);
    }

    public SensorData[] getSensors() {
        SensorData[] ret = new SensorData[this.sensors.size()];
        this.sensors.toArray(ret);
        return ret;
    }

    public void setContactURI(SipURI uri) {
        this.contact = uri;
    }

    public SipURI getContactURI() {
        return this.contact;
    }

    public static void main(String[] args) throws ParseException {
        EntityImpl e = new EntityImpl("sip:1kasuya@localhost:5060");
        SensorDataImpl s = new SensorDataImpl();
        e.addSensorData(s);
        System.out.println(e.getSensors().length);
        e.removeSensorData(s);
        System.out.println(e.getSensors().length);
    }
}

