/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.dht;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jp.ac.naka.ec.dht.LookupEvent;
import jp.ac.naka.ec.dht.LookupListener;

public class FindPeer
implements Runnable {
    static final String REQUEST_MESSAGE = "find_peer";
    static final String RESPONSE_MESSAGE = "ack";
    public static final int BROADCAST_PORT = 9674;
    static final int EXPIRES = 5000;
    private List<LookupListener> listeners = new ArrayList<LookupListener>();
    boolean success = false;
    private static FindPeer fp = new FindPeer();

    private FindPeer() {
    }

    public static FindPeer getInstance() {
        return fp;
    }

    public void findOtherPeer() throws IOException {
        this.success = false;
        MulticastSocket socket = new MulticastSocket();
        InetAddress broadcastAddress = this.getBroadcastAddress();
        byte[] buf = REQUEST_MESSAGE.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, broadcastAddress, 9674);
        socket.send(packet);
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(5000L);
                    if (!FindPeer.this.success) {
                        FindPeer.this.success = true;
                        LookupEvent evt = new LookupEvent(this);
                        evt.setStatus(2);
                        FindPeer.this.dispatchEvent(evt);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        socket.close();
    }

    public void run() {
        byte[] buf = REQUEST_MESSAGE.getBytes();
        DatagramSocket sock = null;
        try {
            try {
                sock = new DatagramSocket(9674);
            }
            catch (SocketException e1) {
                e1.printStackTrace();
                this.success = true;
                LookupEvent evt = new LookupEvent(this);
                evt.setStatus(1);
                evt.setPeerAddress(InetAddress.getLocalHost());
                this.dispatchEvent(evt);
                if (sock != null) {
                    sock.close();
                }
                return;
            }
            try {
                while (true) {
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    sock.receive(packet);
                    String data = new String(packet.getData(), 0, packet.getLength());
                    InetAddress addr = packet.getAddress();
                    System.out.println("Response from :" + addr.getHostAddress() + ", " + data);
                    if (data.equals(REQUEST_MESSAGE)) {
                        byte[] res_buf = RESPONSE_MESSAGE.getBytes();
                        Random rand = new Random();
                        try {
                            Thread.sleep(rand.nextInt(10) * 100);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        DatagramPacket response = new DatagramPacket(res_buf, res_buf.length, addr, 9674);
                        sock.send(response);
                        continue;
                    }
                    if (data.equals(RESPONSE_MESSAGE)) {
                        if (this.success) continue;
                        this.success = true;
                        LookupEvent evt = new LookupEvent(this);
                        evt.setStatus(1);
                        evt.setPeerAddress(addr);
                        this.dispatchEvent(evt);
                        continue;
                    }
                    System.err.println("Invalid Request Message :" + data);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    public InetAddress getBroadcastAddress() throws UnknownHostException {
        InetAddress local = InetAddress.getLocalHost();
        String temp = local.getHostAddress();
        int index = temp.lastIndexOf(".");
        InetAddress ret = InetAddress.getByName(String.valueOf(temp.substring(0, index)) + ".255");
        return ret;
    }

    public boolean addLookupListener(LookupListener listener) {
        boolean ret = this.listeners.add(listener);
        return ret;
    }

    public boolean removeLookupListener(LookupListener listener) {
        return this.listeners.remove(listener);
    }

    boolean dispatchEvent(LookupEvent evt) {
        boolean ret = false;
        for (LookupListener listener : this.listeners) {
            switch (evt.getStatus()) {
                case 1: {
                    listener.findPeer(evt);
                    break;
                }
                case 2: {
                    listener.peerNotFound(evt);
                }
            }
            ret = true;
        }
        return ret;
    }
}

