/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec;

import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import jp.ac.naka.ec.dht.Chord;
import jp.ac.naka.ec.dht.FindPeer;
import jp.ac.naka.ec.dht.LookupEvent;
import jp.ac.naka.ec.dht.LookupListener;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityConfigParser;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.sip.SipCore;

public class EntityCollaborator {
    private EntityContainer container;
    private static Chord chord;
    private static EntityCollaborator instance;
    public static int PORT;
    public static String base;
    public static FindPeer fp;
    private List<Entity> tempEntities = new ArrayList<Entity>();
    public static String config;

    static {
        instance = new EntityCollaborator();
        PORT = 5060;
        base = ".";
        config = "./config/entities.xml";
    }

    private EntityCollaborator() {
    }

    public Entity[] getEntities() {
        return this.container.getEntities();
    }

    public static EntityCollaborator getInstance() {
        EntityCollaborator.instance.container = EntityContainerImpl.getInstance();
        return instance;
    }

    public static EntityCollaborator getInstance(String ni) throws IOException, ParseException {
        EntityCollaborator.instance.container = EntityContainerImpl.getInstance(ni);
        return instance;
    }

    public boolean addEntity(Entity entity) {
        this.container.addEntity(entity);
        if (chord != null) {
            try {
                boolean ret = chord.insertEntity(entity);
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        this.tempEntities.add(entity);
        return true;
    }

    public boolean removeEntity(Entity entity) {
        String[] keywords = entity.getKeywords();
        this.container.removeEntity(entity);
        if (chord == null) {
            return true;
        }
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            chord.removeEntity(keyword, entity);
            ++n2;
        }
        return true;
    }

    public Entity[] searchEntities(String keyword) {
        if (chord != null) {
            return this.container.searchEntities(keyword);
        }
        throw new NullPointerException("DHT is not initialized");
    }

    public void initiateDHT() throws Exception {
        chord = Chord.getInstance();
        chord.init();
        for (Entity entity : this.tempEntities) {
            chord.insertEntity(entity);
        }
        this.tempEntities.clear();
        this.tempEntities = null;
    }

    public void initiateDHT(int port) throws Exception {
        Chord.PORT = port;
        this.initiateDHT();
    }

    public void initiateDHT(String bootstrapURI) throws Exception {
        chord = Chord.getInstance();
        chord.init(bootstrapURI, Chord.PORT);
        for (Entity entity : this.tempEntities) {
            chord.insertEntity(entity);
        }
        this.tempEntities.clear();
        this.tempEntities = null;
    }

    public void initiateDHT(String bootstrapURI, int port) throws Exception {
        chord = Chord.getInstance();
        chord.init(bootstrapURI, port);
        for (Entity entity : this.tempEntities) {
            chord.insertEntity(entity);
        }
        this.tempEntities.clear();
        this.tempEntities = null;
    }

    public Entity getEntity(String uri) {
        Entity ret = this.container.getEntity(uri);
        return ret;
    }

    public void initiateSipCore() throws IOException, SipException, ParseException, InvalidArgumentException, TooManyListenersException {
        SipCore core = SipCore.getInstance();
        String hostname = EntityContainerImpl.getHostName();
        String address = InetAddress.getByName(hostname).getHostAddress();
        core.initialize(address, SipCore.PORT);
    }

    public void initiateSipCore(int port) throws IOException, SipException, ParseException, InvalidArgumentException, TooManyListenersException {
        SipCore core = SipCore.getInstance();
        String hostname = EntityContainerImpl.getHostName();
        String address = InetAddress.getByName(hostname).getHostAddress();
        core.initialize(address, port);
    }

    public void findPeer() throws IOException {
        fp = FindPeer.getInstance();
        fp.addLookupListener(new LookupListener(){

            public void findPeer(LookupEvent evt) {
                System.out.println("Peer Found :" + evt.getPeerAddress().getHostAddress());
                InetAddress addr = evt.getPeerAddress();
                try {
                    EntityCollaborator.this.initiateDHT(addr.getHostAddress());
                    for (Entity entity : EntityCollaborator.this.tempEntities) {
                        chord.insertEntity(entity);
                    }
                    EntityCollaborator.this.tempEntities.clear();
                    EntityCollaborator.this.tempEntities = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void peerNotFound(LookupEvent evt) {
                try {
                    System.out.println("Peer Not Found.");
                    EntityCollaborator.this.initiateDHT();
                    for (Entity entity : EntityCollaborator.this.tempEntities) {
                        chord.insertEntity(entity);
                    }
                    EntityCollaborator.this.tempEntities.clear();
                    EntityCollaborator.this.tempEntities = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        fp.findOtherPeer();
        ExecutorService service = Executors.newSingleThreadExecutor();
        service.execute(fp);
    }

    public void initEntities() {
        Entity[] entities;
        EntityConfigParser parser = new EntityConfigParser();
        Entity[] entityArray = entities = parser.parse(config);
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            System.out.println("add " + entity.getName());
            this.addEntity(entity);
            ++n2;
        }
    }
}

