/*
 * Decompiled with CFR 0.152.
 */
package ow.util;

public final class JVMLifeKeeper {
    private final long lastingTime;
    private Thread lifeKeeper = null;
    private Thread terminator = null;

    public JVMLifeKeeper() {
        this(0L);
    }

    public JVMLifeKeeper(long lastingTime) {
        this.lastingTime = lastingTime;
    }

    public synchronized void keep(boolean keep) {
        if (keep) {
            if (this.lifeKeeper == null) {
                Runnable r = new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(Long.MAX_VALUE);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                Thread t = this.lifeKeeper = new Thread(r);
                t.setName("JVMLifeKeeper");
                t.start();
            } else if (this.terminator != null) {
                this.terminator.interrupt();
                this.terminator = null;
            }
        } else if (this.lifeKeeper != null) {
            if (this.lastingTime == 0L) {
                this.terminateLifeKeeper();
            } else if (this.terminator == null) {
                LastingTimer r = new LastingTimer();
                Thread t = this.terminator = new Thread(r);
                t.setName("JVMLifeKeeper terminator");
                t.start();
            }
        }
    }

    private synchronized void terminateLifeKeeper() {
        this.lifeKeeper.interrupt();
        this.lifeKeeper = null;
    }

    public static void main(String[] args) throws InterruptedException {
        JVMLifeKeeper sw = new JVMLifeKeeper(2000L);
        sw.keep(true);
        Thread.sleep(1000L);
        sw.keep(false);
        Thread.sleep(1000L);
        sw.keep(true);
        Thread.sleep(1000L);
        sw.keep(false);
    }

    private final class LastingTimer
    implements Runnable {
        private LastingTimer() {
        }

        public void run() {
            try {
                Thread.sleep(JVMLifeKeeper.this.lastingTime);
                if (!Thread.interrupted()) {
                    JVMLifeKeeper.this.terminateLifeKeeper();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

