/*
 * Decompiled with CFR 0.152.
 */
package ow.tool.memcached.commands;

import java.io.PrintStream;
import java.util.Set;
import ow.dht.ValueInfo;
import ow.dht.memcached.Item;
import ow.dht.memcached.Memcached;
import ow.id.ID;
import ow.tool.util.shellframework.Command;
import ow.tool.util.shellframework.ShellContext;
import ow.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatsCommand
implements Command<Memcached> {
    private static final String[] NAMES = new String[]{"stats"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getHelp() {
        return "stats";
    }

    @Override
    public boolean execute(ShellContext<Memcached> context) {
        Memcached dht = context.getOpaqueData();
        PrintStream out = context.getOutputStream();
        String[] args = context.getArguments();
        StringBuilder sb = new StringBuilder();
        if (args.length > 1) {
            sb.append("ERROR").append("\r\n");
        } else if (args.length <= 0) {
            sb.append("STAT time ").append(Timer.currentTimeMillis());
            sb.append("STAT version ").append("1.2.6").append("\r\n");
            sb.append("STAT curr_items ").append(dht.getGlobalKeys().size());
            sb.append("END").append("\r\n");
        } else {
            String arg = args[0].toLowerCase();
            if (arg.equals("items")) {
                sb.append("END").append("\r\n");
            } else if (arg.equals("sizes")) {
                int itemSize = 0;
                int count = 0;
                Set<ID> keySet = dht.getGlobalKeys();
                if (!keySet.isEmpty()) {
                    for (ID key : keySet) {
                        Set values = dht.getGlobalValues(key);
                        for (ValueInfo v : values) {
                            Item item = (Item)v.getValue();
                            itemSize += 3;
                            itemSize += (item.getData().length + 3) / 4;
                            itemSize += 3;
                            ++count;
                        }
                    }
                    itemSize = (itemSize + 1) / count;
                    sb.append(itemSize * 4).append(" ").append(count).append("\r\n");
                }
                sb.append("END").append("\r\n");
            } else if (arg.equals("slabs")) {
                sb.append("END").append("\r\n");
            } else {
                sb.append("ERROR").append("\r\n");
            }
        }
        out.print(sb);
        out.flush();
        return false;
    }
}

