/*
 * Decompiled with CFR 0.152.
 */
package ow.messaging.timeoutcalc;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import ow.messaging.MessagingAddress;
import ow.messaging.MessagingConfiguration;
import ow.messaging.timeoutcalc.TimeoutCalculator;
import ow.util.Timer;

public final class RTTBasedTimeoutCalculator
implements TimeoutCalculator {
    private static final Logger logger = Logger.getLogger("messaging");
    private final MessagingConfiguration config;
    private Map<MessagingAddress, TargetRecord> targetTable = null;
    private SortedSet<TargetRecord> targetListInLRUOrder = null;

    public RTTBasedTimeoutCalculator(MessagingConfiguration config) {
        this.config = config;
        if (this.config.getDoTimeoutCalculation()) {
            this.targetTable = new HashMap<MessagingAddress, TargetRecord>();
            this.targetListInLRUOrder = new TreeSet<TargetRecord>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateTimeout(MessagingAddress target) {
        if (!this.config.getDoTimeoutCalculation()) {
            return this.config.getStaticTimeout();
        }
        TargetRecord record = null;
        Map<MessagingAddress, TargetRecord> map = this.targetTable;
        synchronized (map) {
            record = this.targetTable.get(target);
        }
        int timeout = record != null ? record.calculateTimeout() : this.config.getStaticTimeout();
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRTT(MessagingAddress target, int rtt) {
        if (!this.config.getDoTimeoutCalculation()) {
            return;
        }
        TargetRecord record = null;
        Object object = this.targetTable;
        synchronized (object) {
            record = this.targetTable.get(target);
        }
        if (record != null) {
            object = record;
            synchronized (object) {
                long m = rtt - record.rtt;
                record.rtt = (int)((long)record.rtt + (m >> 3));
                if (m < 0L) {
                    m = -m;
                    m -= (long)record.mdev;
                    m >>= 3;
                } else {
                    m -= (long)record.mdev;
                }
                record.mdev = (int)((long)record.mdev + (m >> 2));
                if (record.mdev > record.mdev_max) {
                    record.mdev_max = record.mdev;
                    if (record.mdev_max > record.rttvar) {
                        record.rttvar = record.mdev_max;
                        record.rttvarKeepingPeriod = this.config.getRTTKeepingPeriod();
                    }
                }
                if (record.rttvarKeepingPeriod-- <= 0L) {
                    if (record.mdev_max < record.rttvar) {
                        record.rttvar -= record.rttvar - record.mdev_max + 3 >> 2;
                    }
                    record.mdev_max = this.config.getTimeoutMin() >> 2;
                    record.rttvarKeepingPeriod = this.config.getRTTKeepingPeriod();
                }
                record.touch();
            }
        }
        record = new TargetRecord(target, rtt);
        object = this.targetListInLRUOrder;
        synchronized (object) {
            this.targetListInLRUOrder.add(record);
            if (this.targetListInLRUOrder.size() > this.config.getRTTTableSize()) {
                TargetRecord oldestRecord = this.targetListInLRUOrder.last();
                this.targetListInLRUOrder.remove(oldestRecord);
                Map<MessagingAddress, TargetRecord> map = this.targetTable;
                synchronized (map) {
                    this.targetTable.remove(oldestRecord.getTarget());
                }
            }
        }
        object = this.targetTable;
        synchronized (object) {
            this.targetTable.put(target, record);
        }
        logger.log(Level.INFO, "To " + target + ": RTT: " + rtt + ", ave. RTT: " + record.rtt + ", mdev: " + record.mdev + ", mdev_max: " + record.mdev_max + ", rttvar: " + record.rttvar + ", timeout: " + record.calculateTimeout());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TargetRecord
    implements Comparable<TargetRecord> {
        private MessagingAddress target;
        int rtt;
        int mdev;
        int mdev_max;
        int rttvar;
        private long lastUpdated;
        private long rttvarKeepingPeriod;

        public TargetRecord(MessagingAddress target, int rtt) {
            this.target = target;
            this.rtt = rtt;
            this.mdev = rtt >> 1;
            this.mdev_max = this.rttvar = Math.max(this.mdev, RTTBasedTimeoutCalculator.this.config.getTimeoutMin() >> 2);
            this.lastUpdated = Timer.currentTimeMillis();
            this.rttvarKeepingPeriod = RTTBasedTimeoutCalculator.this.config.getRTTKeepingPeriod();
        }

        public int calculateTimeout() {
            return Math.min(this.rtt + (this.rttvar << 2), RTTBasedTimeoutCalculator.this.config.getTimeoutMax());
        }

        public MessagingAddress getTarget() {
            return this.target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touch() {
            this.lastUpdated = Timer.currentTimeMillis();
            SortedSet sortedSet = RTTBasedTimeoutCalculator.this.targetListInLRUOrder;
            synchronized (sortedSet) {
                RTTBasedTimeoutCalculator.this.targetListInLRUOrder.remove(this);
                RTTBasedTimeoutCalculator.this.targetListInLRUOrder.add(this);
            }
        }

        @Override
        public int compareTo(TargetRecord o) {
            return (int)(o.lastUpdated - this.lastUpdated);
        }
    }
}

