/*
 * Decompiled with CFR 0.152.
 */
package ow.ipmulticast;

import java.net.Inet4Address;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import ow.ipmulticast.IGMP;
import ow.ipmulticast.Querier;
import ow.util.Timer;

public class QuerierSet {
    Map<Inet4Address, Querier> querierMap = new HashMap<Inet4Address, Querier>();
    private int lowestIGMPVersion = IGMP.DEFAULT_IGMP_VERSION;

    public int getLowestIGMPVersion() {
        return this.lowestIGMPVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQuerier(Inet4Address address, int igmpVersion) {
        Querier querier = null;
        Map<Inet4Address, Querier> map = this.querierMap;
        synchronized (map) {
            querier = this.querierMap.get(address);
            if (querier != null) {
                querier.updateRespondedTime();
                querier.setIGMPVersion(igmpVersion);
            } else {
                querier = new Querier(address, igmpVersion);
                this.querierMap.put(address, querier);
            }
            if (igmpVersion < this.lowestIGMPVersion) {
                this.lowestIGMPVersion = igmpVersion;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean expire(long expiration) {
        long now = Timer.currentTimeMillis();
        int lowestVer = 3;
        boolean changed = false;
        HashSet<Inet4Address> removedKeySet = new HashSet<Inet4Address>();
        Map<Inet4Address, Querier> map = this.querierMap;
        synchronized (map) {
            for (Inet4Address addr : this.querierMap.keySet()) {
                Querier querier = this.querierMap.get(addr);
                if (now >= querier.getRespondedTime() + expiration) {
                    removedKeySet.add(addr);
                    continue;
                }
                int ver = querier.getIGMPVersion();
                if (ver >= lowestVer) continue;
                lowestVer = ver;
            }
            for (Inet4Address removedKey : removedKeySet) {
                this.querierMap.remove(removedKey);
                changed = true;
            }
        }
        this.lowestIGMPVersion = lowestVer;
        return changed;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("querier [");
        for (Querier q : this.querierMap.values()) {
            sb.append("\n");
            sb.append(indent);
            sb.append(q.toString("  "));
        }
        sb.append("\n");
        sb.append(indent);
        sb.append("]");
        return sb.toString();
    }
}

