/*
 * Decompiled with CFR 0.152.
 */
package ow.directory.expiration;

import java.io.Serializable;
import java.util.Set;
import ow.directory.SingleValueDirectory;
import ow.directory.expiration.AbstractExpiringDirectory;
import ow.directory.expiration.Expirable;
import ow.directory.expiration.ExpiringValue;
import ow.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpiringSingleValueDirectory<K, V>
extends AbstractExpiringDirectory<K, V>
implements SingleValueDirectory<K, V>,
Serializable {
    private SingleValueDirectory<K, ExpiringValue<V>> internalDirectory;

    public ExpiringSingleValueDirectory(SingleValueDirectory<K, ExpiringValue<V>> dir, long expirationTime) {
        super(dir, expirationTime);
        this.internalDirectory = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, long ttl) throws Exception {
        try {
            ((Expirable)value).setTTL(ttl);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ExpiringValue<V> entry = new ExpiringValue<V>(value, ttl);
        long expiringTime = entry.getExpiringTime();
        ExpiringSingleValueDirectory expiringSingleValueDirectory = this;
        synchronized (expiringSingleValueDirectory) {
            entry = this.internalDirectory.put(key, entry);
            super.initExpiringTask(expiringTime + 100L);
        }
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
            ttl = entry.getExpiringTime() - Timer.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 0L;
            }
            try {
                ((Expirable)ret).setTTL(ttl);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public V put(K key, V value) throws Exception {
        long ttl = 0L;
        try {
            ttl = ((Expirable)value).getTTL();
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        if (ttl <= 0L) {
            ttl = this.defaultTTL;
        }
        return this.put(key, value, ttl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getAndRemove(K key, boolean remove) throws Exception {
        ExpiringValue<V> entry;
        if (remove) {
            ExpiringSingleValueDirectory expiringSingleValueDirectory = this;
            synchronized (expiringSingleValueDirectory) {
                entry = this.internalDirectory.remove(key);
                if (this.internalDirectory.isEmpty()) {
                    super.stopExpiringTask();
                }
            }
        } else {
            entry = this.internalDirectory.get(key);
        }
        V ret = null;
        if (entry != null) {
            ret = entry.getValue();
            int ttl = (int)(entry.getExpiringTime() - Timer.currentTimeMillis());
            if (ttl < 0) {
                ttl = 0;
            }
            try {
                ((Expirable)ret).setTTL(ttl);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public V get(K key) throws Exception {
        return this.getAndRemove(key, false);
    }

    @Override
    public V remove(K key) throws Exception {
        return this.getAndRemove(key, true);
    }

    @Override
    public boolean isEmpty() {
        return this.internalDirectory.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.internalDirectory.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ExpiringSingleValueDirectory expiringSingleValueDirectory = this;
        synchronized (expiringSingleValueDirectory) {
            super.stopExpiringTask();
            this.internalDirectory.clear();
        }
    }

    @Override
    public void close() {
        super.close();
        this.internalDirectory.close();
    }
}

