/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.HostPort;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.From;
import java.text.ParseException;
import javax.sip.header.ToHeader;

public final class To
extends AddressParametersHeader
implements ToHeader {
    private static final long serialVersionUID = -4057413800584586316L;

    public To() {
        super("To");
    }

    public To(From from) {
        super("To");
        this.setAddress(from.address);
        this.setParameters(from.parameters);
    }

    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeBody() {
        if (this.address == null) {
            return null;
        }
        String retval = "";
        if (this.address.getAddressType() == 2) {
            retval = retval + "<";
        }
        retval = retval + this.address.encode();
        if (this.address.getAddressType() == 2) {
            retval = retval + ">";
        }
        if (!this.parameters.isEmpty()) {
            NameValueList nameValueList = this.parameters;
            synchronized (nameValueList) {
                retval = retval + ";" + this.parameters.encode();
            }
        }
        return retval;
    }

    public HostPort getHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getHostPort();
    }

    public String getDisplayName() {
        if (this.address == null) {
            return null;
        }
        return this.address.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTag() {
        if (this.parameters == null) {
            return null;
        }
        NameValueList nameValueList = this.parameters;
        synchronized (nameValueList) {
            return this.getParameter("tag");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTag() {
        if (this.parameters == null) {
            return false;
        }
        NameValueList nameValueList = this.parameters;
        synchronized (nameValueList) {
            return this.hasParameter("tag");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTag() {
        NameValueList nameValueList = this.parameters;
        synchronized (nameValueList) {
            if (this.parameters != null) {
                this.parameters.delete("tag");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTag(String t) throws ParseException {
        NameValueList nameValueList = this.parameters;
        synchronized (nameValueList) {
            if (t == null) {
                throw new NullPointerException("null tag ");
            }
            if (t.trim().equals("")) {
                throw new ParseException("bad tag", 0);
            }
            this.setParameter("tag", t);
        }
    }

    public String getUserAtHostPort() {
        if (this.address == null) {
            return null;
        }
        return this.address.getUserAtHostPort();
    }

    public boolean equals(Object other) {
        return other instanceof ToHeader && super.equals(other);
    }
}

