/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;

public class TLSMessageProcessor
extends MessageProcessor {
    protected int nConnections;
    private boolean isRunning;
    private Hashtable<String, TLSMessageChannel> tlsMessageChannels;
    private ServerSocket sock;
    protected int useCount = 0;
    protected SIPTransactionStack sipStack;
    private ArrayList<TLSMessageChannel> incomingTlsMessageChannels;

    protected TLSMessageProcessor(InetAddress ipAddress, SIPTransactionStack sipStack, int port) {
        super(ipAddress, port, "tls");
        this.sipStack = sipStack;
        this.tlsMessageChannels = new Hashtable();
        this.incomingTlsMessageChannels = new ArrayList();
    }

    public void start() throws IOException {
        Thread thread = new Thread(this);
        thread.setName("TLSMessageProcessorThread");
        thread.setPriority(10);
        thread.setDaemon(true);
        if (!this.sipStack.useTlsAccelerator) {
            this.sock = this.sipStack.getNetworkLayer().createSSLServerSocket(this.getPort(), 0, this.getIpAddress());
            ((SSLServerSocket)this.sock).setNeedClientAuth(false);
            ((SSLServerSocket)this.sock).setUseClientMode(false);
            ((SSLServerSocket)this.sock).setWantClientAuth(true);
            String[] enabledCiphers = ((SipStackImpl)this.sipStack).getEnabledCipherSuites();
            ((SSLServerSocket)this.sock).setEnabledCipherSuites(enabledCiphers);
        } else {
            this.sock = this.sipStack.getNetworkLayer().createServerSocket(this.getPort(), 0, this.getIpAddress());
        }
        this.isRunning = true;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            try {
                TLSMessageProcessor tLSMessageProcessor = this;
                synchronized (tLSMessageProcessor) {
                    while (this.sipStack.maxConnections != -1 && this.nConnections >= this.sipStack.maxConnections) {
                        try {
                            this.wait();
                            if (this.isRunning) continue;
                            return;
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                            break;
                        }
                    }
                    ++this.nConnections;
                }
                Socket newsock = this.sock.accept();
                if (this.sipStack.getStackLogger().isLoggingEnabled()) {
                    this.sipStack.getStackLogger().logDebug("Accepting new connection!");
                }
                this.incomingTlsMessageChannels.add(new TLSMessageChannel(newsock, this.sipStack, this));
            }
            catch (SocketException ex) {
                if (!this.isRunning) continue;
                this.sipStack.getStackLogger().logError("Fatal - SocketException occured while Accepting connection", ex);
                this.isRunning = false;
                break;
            }
            catch (SSLException ex) {
                this.isRunning = false;
                this.sipStack.getStackLogger().logError("Fatal - SSSLException occured while Accepting connection", ex);
                break;
            }
            catch (IOException ex) {
                this.sipStack.getStackLogger().logError("Problem Accepting Connection", ex);
            }
            catch (Exception ex) {
                this.sipStack.getStackLogger().logError("Unexpected Exception!", ex);
            }
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        try {
            this.sock.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Collection<TLSMessageChannel> en = this.tlsMessageChannels.values();
        for (TLSMessageChannel next : en) {
            next.close();
        }
        for (TLSMessageChannel next : this.incomingTlsMessageChannels) {
            next.close();
        }
        this.notify();
    }

    protected synchronized void remove(TLSMessageChannel tlsMessageChannel) {
        String key = tlsMessageChannel.getKey();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug(Thread.currentThread() + " removing " + key);
        }
        if (this.tlsMessageChannels.get(key) == tlsMessageChannel) {
            this.tlsMessageChannels.remove(key);
        }
        this.incomingTlsMessageChannels.remove(tlsMessageChannel);
    }

    public synchronized MessageChannel createMessageChannel(HostPort targetHostPort) throws IOException {
        String key = MessageChannel.getKey(targetHostPort, "TLS");
        if (this.tlsMessageChannels.get(key) != null) {
            return this.tlsMessageChannels.get(key);
        }
        TLSMessageChannel retval = new TLSMessageChannel(targetHostPort.getInetAddress(), targetHostPort.getPort(), this.sipStack, this);
        this.tlsMessageChannels.put(key, retval);
        retval.isCached = true;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("key " + key);
            this.sipStack.getStackLogger().logDebug("Creating " + retval);
        }
        return retval;
    }

    protected synchronized void cacheMessageChannel(TLSMessageChannel messageChannel) {
        String key = messageChannel.getKey();
        TLSMessageChannel currentChannel = this.tlsMessageChannels.get(key);
        if (currentChannel != null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Closing " + key);
            }
            currentChannel.close();
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Caching " + key);
        }
        this.tlsMessageChannels.put(key, messageChannel);
    }

    public synchronized MessageChannel createMessageChannel(InetAddress host, int port) throws IOException {
        try {
            String key = MessageChannel.getKey(host, port, "TLS");
            if (this.tlsMessageChannels.get(key) != null) {
                return this.tlsMessageChannels.get(key);
            }
            TLSMessageChannel retval = new TLSMessageChannel(host, port, this.sipStack, this);
            this.tlsMessageChannels.put(key, retval);
            retval.isCached = true;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("key " + key);
                this.sipStack.getStackLogger().logDebug("Creating " + retval);
            }
            return retval;
        }
        catch (UnknownHostException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public int getMaximumMessageSize() {
        return Integer.MAX_VALUE;
    }

    public boolean inUse() {
        return this.useCount != 0;
    }

    public int getDefaultTargetPort() {
        return 5061;
    }

    public boolean isSecure() {
        return true;
    }
}

