/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.ClientTransactionExt;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.text.ParseException;
import java.util.ListIterator;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogState;
import javax.sip.InvalidArgumentException;
import javax.sip.ObjectInUseException;
import javax.sip.SipException;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionState;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class SIPClientTransaction
extends SIPTransaction
implements ServerResponseInterface,
ClientTransaction,
ClientTransactionExt {
    private ConcurrentHashMap sipDialogs;
    private SIPRequest lastRequest;
    private int viaPort;
    private String viaHost;
    private transient ServerResponseInterface respondTo;
    private SIPDialog defaultDialog;
    private Hop nextHop;
    private boolean notifyOnRetransmit;
    private boolean timeoutIfStillInCallingState;
    private int callingStateTimeoutCount;

    protected SIPClientTransaction(SIPTransactionStack newSIPStack, MessageChannel newChannelToUse) {
        super(newSIPStack, newChannelToUse);
        this.setBranch(Utils.getInstance().generateBranchId());
        this.messageProcessor = newChannelToUse.messageProcessor;
        this.setEncapsulatedChannel(newChannelToUse);
        this.notifyOnRetransmit = false;
        this.timeoutIfStillInCallingState = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Creating clientTransaction " + this);
            this.sipStack.getStackLogger().logStackTrace();
        }
        this.sipDialogs = new ConcurrentHashMap();
    }

    public void setResponseInterface(ServerResponseInterface newRespondTo) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("Setting response interface for " + this + " to " + newRespondTo);
            if (newRespondTo == null) {
                this.sipStack.getStackLogger().logStackTrace();
                this.sipStack.getStackLogger().logDebug("WARNING -- setting to null!");
            }
        }
        this.respondTo = newRespondTo;
    }

    public MessageChannel getRequestChannel() {
        return this;
    }

    public boolean isMessagePartOfTransaction(SIPMessage messageToTest) {
        ViaList viaHeaders = messageToTest.getViaHeaders();
        String messageBranch = ((Via)viaHeaders.getFirst()).getBranch();
        boolean rfc3261Compliant = this.getBranch() != null && messageBranch != null && this.getBranch().toLowerCase().startsWith("z9hg4bk") && messageBranch.toLowerCase().startsWith("z9hg4bk");
        boolean transactionMatches = false;
        if (TransactionState.COMPLETED == this.getState()) {
            transactionMatches = rfc3261Compliant ? this.getBranch().equalsIgnoreCase(((Via)viaHeaders.getFirst()).getBranch()) && this.getMethod().equals(messageToTest.getCSeq().getMethod()) : this.getBranch().equals(messageToTest.getTransactionId());
        } else if (!this.isTerminated()) {
            if (rfc3261Compliant) {
                if (viaHeaders != null && this.getBranch().equalsIgnoreCase(((Via)viaHeaders.getFirst()).getBranch())) {
                    transactionMatches = this.getOriginalRequest().getCSeq().getMethod().equals(messageToTest.getCSeq().getMethod());
                }
            } else {
                transactionMatches = this.getBranch() != null ? this.getBranch().equalsIgnoreCase(messageToTest.getTransactionId()) : this.getOriginalRequest().getTransactionId().equalsIgnoreCase(messageToTest.getTransactionId());
            }
        }
        return transactionMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(SIPMessage messageToSend) throws IOException {
        try {
            SIPRequest transactionRequest = (SIPRequest)messageToSend;
            Via topVia = (Via)transactionRequest.getViaHeaders().getFirst();
            try {
                topVia.setBranch(this.getBranch());
            }
            catch (ParseException ex) {
                // empty catch block
            }
            if (this.sipStack.getStackLogger().isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("Sending Message " + messageToSend);
                this.sipStack.getStackLogger().logDebug("TransactionState " + this.getState());
            }
            if ((TransactionState.PROCEEDING == this.getState() || TransactionState.CALLING == this.getState()) && transactionRequest.getMethod().equals("ACK")) {
                if (this.isReliable()) {
                    this.setState(TransactionState.TERMINATED);
                } else {
                    this.setState(TransactionState.COMPLETED);
                }
                super.sendMessage(transactionRequest);
                return;
            }
            try {
                this.lastRequest = transactionRequest;
                if (this.getState() == null) {
                    this.setOriginalRequest(transactionRequest);
                    if (transactionRequest.getMethod().equals("INVITE")) {
                        this.setState(TransactionState.CALLING);
                    } else if (transactionRequest.getMethod().equals("ACK")) {
                        this.setState(TransactionState.TERMINATED);
                    } else {
                        this.setState(TransactionState.TRYING);
                    }
                    if (!this.isReliable()) {
                        this.enableRetransmissionTimer();
                    }
                    if (this.isInviteTransaction()) {
                        this.enableTimeoutTimer(64);
                    } else {
                        this.enableTimeoutTimer(64);
                    }
                }
                super.sendMessage(transactionRequest);
            }
            catch (IOException e) {
                this.setState(TransactionState.TERMINATED);
                throw e;
            }
        }
        finally {
            this.isMapped = true;
            this.startTransactionTimer();
        }
    }

    public synchronized void processResponse(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) {
        if (this.getState() == null) {
            return;
        }
        if ((TransactionState.COMPLETED == this.getState() || TransactionState.TERMINATED == this.getState()) && transactionResponse.getStatusCode() / 100 == 1) {
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("processing " + transactionResponse.getFirstLine() + "current state = " + this.getState());
            this.sipStack.getStackLogger().logDebug("dialog = " + dialog);
        }
        this.lastResponse = transactionResponse;
        try {
            if (this.isInviteTransaction()) {
                this.inviteClientTransaction(transactionResponse, sourceChannel, dialog);
            } else {
                this.nonInviteClientTransaction(transactionResponse, sourceChannel, dialog);
            }
        }
        catch (IOException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logException(ex);
            }
            this.setState(TransactionState.TERMINATED);
            this.raiseErrorEvent(2);
        }
    }

    private void nonInviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog sipDialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TRYING == this.getState()) {
            if (statusCode / 100 == 1) {
                this.setState(TransactionState.PROCEEDING);
                this.enableRetransmissionTimer(8);
                this.enableTimeoutTimer(64);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_K);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
            } else if (200 <= statusCode && statusCode <= 699) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, sipDialog);
                } else {
                    this.semRelease();
                }
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_K);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else {
            if (this.sipStack.isLoggingEnabled()) {
                this.getSIPStack().getStackLogger().logDebug(" Not sending response to TU! " + this.getState());
            }
            this.semRelease();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inviteClientTransaction(SIPResponse transactionResponse, MessageChannel sourceChannel, SIPDialog dialog) throws IOException {
        int statusCode = transactionResponse.getStatusCode();
        if (TransactionState.TERMINATED == this.getState()) {
            boolean ackAlreadySent = false;
            if (dialog != null && dialog.isAckSeen() && dialog.getLastAck() != null && dialog.getLastAck().getCSeq().getSeqNumber() == transactionResponse.getCSeq().getSeqNumber()) {
                ackAlreadySent = true;
            }
            if (ackAlreadySent && transactionResponse.getCSeq().getMethod().equals(dialog.getMethod())) {
                try {
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.getStackLogger().logDebug("resending ACK");
                    }
                    dialog.resendAck();
                }
                catch (SipException ex) {
                    // empty catch block
                }
            }
            this.semRelease();
            return;
        }
        if (TransactionState.CALLING == this.getState()) {
            if (statusCode / 100 == 2) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
            } else if (statusCode / 100 == 1) {
                this.disableRetransmissionTimer();
                this.disableTimeoutTimer();
                this.setState(TransactionState.PROCEEDING);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createErrorAck());
                }
                catch (Exception ex) {
                    this.sipStack.getStackLogger().logError("Unexpected Exception sending ACK -- sending error AcK ", ex);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
                if (this.getDialog() != null) {
                    ((SIPDialog)this.getDialog()).releaseAckSem();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_D);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
            }
        } else if (TransactionState.PROCEEDING == this.getState()) {
            if (statusCode / 100 == 1) {
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
            } else if (statusCode / 100 == 2) {
                this.setState(TransactionState.TERMINATED);
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
            } else if (300 <= statusCode && statusCode <= 699) {
                try {
                    this.sendMessage((SIPRequest)this.createErrorAck());
                }
                catch (Exception ex) {
                    InternalErrorHandler.handleException(ex);
                }
                if (this.getDialog() != null) {
                    ((SIPDialog)this.getDialog()).releaseAckSem();
                }
                if (!this.isReliable()) {
                    this.setState(TransactionState.COMPLETED);
                    this.enableTimeoutTimer(this.TIMER_D);
                } else {
                    this.setState(TransactionState.TERMINATED);
                }
                if (this.respondTo != null) {
                    this.respondTo.processResponse(transactionResponse, this, dialog);
                } else {
                    this.semRelease();
                }
            }
        } else if (TransactionState.COMPLETED == this.getState() && 300 <= statusCode && statusCode <= 699) {
            try {
                this.sendMessage((SIPRequest)this.createErrorAck());
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
            finally {
                this.semRelease();
            }
        }
    }

    public void sendRequest() throws SipException {
        SIPRequest sipRequest = this.getOriginalRequest();
        if (this.getState() != null) {
            throw new SipException("Request already sent");
        }
        if (this.sipStack.getStackLogger().isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("sendRequest() " + sipRequest);
        }
        try {
            sipRequest.checkHeaders();
        }
        catch (ParseException ex) {
            this.sipStack.getStackLogger().logError("missing required header");
            throw new SipException(ex.getMessage());
        }
        if (this.getMethod().equals("SUBSCRIBE") && sipRequest.getHeader("Expires") == null) {
            this.sipStack.getStackLogger().logWarning("Expires header missing in outgoing subscribe -- Notifier will assume implied value on event package");
        }
        try {
            if (this.getOriginalRequest().getMethod().equals("CANCEL") && this.sipStack.isCancelClientTransactionChecked()) {
                SIPClientTransaction ct = (SIPClientTransaction)this.sipStack.findCancelTransaction(this.getOriginalRequest(), false);
                if (ct == null) {
                    throw new SipException("Could not find original tx to cancel. RFC 3261 9.1");
                }
                if (ct.getState() == null) {
                    throw new SipException("State is null no provisional response yet -- cannot cancel RFC 3261 9.1");
                }
                if (!ct.getMethod().equals("INVITE")) {
                    throw new SipException("Cannot cancel non-invite requests RFC 3261 9.1");
                }
            } else if (this.getOriginalRequest().getMethod().equals("BYE") || this.getOriginalRequest().getMethod().equals("NOTIFY")) {
                SIPDialog dialog = this.sipStack.getDialog(this.getOriginalRequest().getDialogId(false));
                if (this.getSipProvider().isAutomaticDialogSupportEnabled() && dialog != null) {
                    throw new SipException("Dialog is present and AutomaticDialogSupport is enabled for  the provider -- Send the Request using the Dialog.sendRequest(transaction)");
                }
            }
            this.isMapped = true;
            this.sendMessage(sipRequest);
        }
        catch (IOException ex) {
            this.setState(TransactionState.TERMINATED);
            throw new SipException("IO Error sending request", ex);
        }
    }

    protected void fireRetransmissionTimer() {
        block9: {
            try {
                if (this.getState() == null || !this.isMapped) {
                    return;
                }
                boolean inv = this.isInviteTransaction();
                TransactionState s = this.getState();
                if ((!inv || TransactionState.CALLING != s) && (inv || TransactionState.TRYING != s && TransactionState.PROCEEDING != s) || this.lastRequest == null) break block9;
                if (this.sipStack.generateTimeStampHeader && this.lastRequest.getHeader("Timestamp") != null) {
                    long milisec = System.currentTimeMillis();
                    TimeStamp timeStamp = new TimeStamp();
                    try {
                        timeStamp.setTimeStamp(milisec);
                    }
                    catch (InvalidArgumentException ex) {
                        InternalErrorHandler.handleException(ex);
                    }
                    this.lastRequest.setHeader(timeStamp);
                }
                super.sendMessage(this.lastRequest);
                if (this.notifyOnRetransmit) {
                    TimeoutEvent txTimeout = new TimeoutEvent((Object)this.getSipProvider(), this, Timeout.RETRANSMIT);
                    this.getSipProvider().handleEvent(txTimeout, this);
                }
                if (this.timeoutIfStillInCallingState && this.getState() == TransactionState.CALLING) {
                    --this.callingStateTimeoutCount;
                    if (this.callingStateTimeoutCount == 0) {
                        TimeoutEvent timeoutEvent = new TimeoutEvent((Object)this.getSipProvider(), this, Timeout.RETRANSMIT);
                        this.getSipProvider().handleEvent(timeoutEvent, this);
                        this.timeoutIfStillInCallingState = false;
                    }
                }
            }
            catch (IOException e) {
                this.raiseIOExceptionEvent();
                this.raiseErrorEvent(2);
            }
        }
    }

    protected void fireTimeoutTimer() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("fireTimeoutTimer " + this);
        }
        SIPDialog dialog = (SIPDialog)this.getDialog();
        if (TransactionState.CALLING == this.getState() || TransactionState.TRYING == this.getState() || TransactionState.PROCEEDING == this.getState()) {
            if (dialog != null && (dialog.getState() == null || dialog.getState() == DialogState.EARLY)) {
                if (this.getSIPStack().isDialogCreated(this.getOriginalRequest().getMethod())) {
                    dialog.delete();
                }
            } else if (dialog != null && this.getOriginalRequest().getMethod().equalsIgnoreCase("BYE") && dialog.isTerminatedOnBye()) {
                dialog.delete();
            }
        }
        if (TransactionState.COMPLETED != this.getState()) {
            SIPClientTransaction inviteTx;
            this.raiseErrorEvent(1);
            if (this.getOriginalRequest().getMethod().equalsIgnoreCase("CANCEL") && (inviteTx = (SIPClientTransaction)this.getOriginalRequest().getInviteTransaction()) != null && (inviteTx.getState() == TransactionState.CALLING || inviteTx.getState() == TransactionState.PROCEEDING) && inviteTx.getDialog() != null) {
                inviteTx.setState(TransactionState.TERMINATED);
            }
        } else {
            this.setState(TransactionState.TERMINATED);
        }
    }

    public Request createCancel() throws SipException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("Bad state " + this.getState());
        }
        if (!originalRequest.getMethod().equals("INVITE")) {
            throw new SipException("Only INIVTE may be cancelled");
        }
        if (originalRequest.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot Cancel ACK!");
        }
        SIPRequest cancelRequest = originalRequest.createCancelRequest();
        cancelRequest.setInviteTransaction(this);
        return cancelRequest;
    }

    public Request createAck() throws SipException {
        Route route;
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (this.getMethod().equalsIgnoreCase("ACK")) {
            throw new SipException("Cannot ACK an ACK!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        SIPRequest ackRequest = originalRequest.createAckRequest((To)this.lastResponse.getTo());
        RecordRouteList recordRouteList = this.lastResponse.getRecordRouteHeaders();
        if (recordRouteList == null) {
            if (this.lastResponse.getContactHeaders() != null && this.lastResponse.getStatusCode() / 100 != 3) {
                Contact contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
                URI uri = (URI)contact.getAddress().getURI().clone();
                ackRequest.setRequestURI(uri);
            }
            return ackRequest;
        }
        ackRequest.removeHeader("Route");
        RouteList routeList = new RouteList();
        ListIterator li = recordRouteList.listIterator(recordRouteList.size());
        while (li.hasPrevious()) {
            RecordRoute rr = (RecordRoute)li.previous();
            route = new Route();
            route.setAddress((AddressImpl)((AddressImpl)rr.getAddress()).clone());
            route.setParameters((NameValueList)rr.getParameters().clone());
            routeList.add(route);
        }
        Contact contact = null;
        if (this.lastResponse.getContactHeaders() != null) {
            contact = (Contact)this.lastResponse.getContactHeaders().getFirst();
        }
        if (!((SipURI)((Route)routeList.getFirst()).getAddress().getURI()).hasLrParam()) {
            route = null;
            if (contact != null) {
                route = new Route();
                route.setAddress((AddressImpl)((AddressImpl)contact.getAddress()).clone());
            }
            Route firstRoute = (Route)routeList.getFirst();
            routeList.removeFirst();
            URI uri = firstRoute.getAddress().getURI();
            ackRequest.setRequestURI(uri);
            if (route != null) {
                routeList.add(route);
            }
            ackRequest.addHeader(routeList);
        } else if (contact != null) {
            URI uri = (URI)contact.getAddress().getURI().clone();
            ackRequest.setRequestURI(uri);
            ackRequest.addHeader(routeList);
        }
        return ackRequest;
    }

    private final Request createErrorAck() throws SipException, ParseException {
        SIPRequest originalRequest = this.getOriginalRequest();
        if (originalRequest == null) {
            throw new SipException("bad state " + this.getState());
        }
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Can only ACK an INVITE!");
        }
        if (this.lastResponse == null) {
            throw new SipException("bad Transaction state");
        }
        if (this.lastResponse.getStatusCode() < 200) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logDebug("lastResponse = " + this.lastResponse);
            }
            throw new SipException("Cannot ACK a provisional response!");
        }
        return originalRequest.createErrorAck((To)this.lastResponse.getTo());
    }

    protected void setViaPort(int port) {
        this.viaPort = port;
    }

    protected void setViaHost(String host) {
        this.viaHost = host;
    }

    public int getViaPort() {
        return this.viaPort;
    }

    public String getViaHost() {
        return this.viaHost;
    }

    public Via getOutgoingViaHeader() {
        return this.getMessageProcessor().getViaHeader();
    }

    public void clearState() {
    }

    public void setState(TransactionState newState) {
        if (newState == TransactionState.TERMINATED && this.isReliable() && !this.getSIPStack().cacheClientConnections) {
            this.collectionTime = 64;
        }
        if (super.getState() != TransactionState.COMPLETED && (newState == TransactionState.COMPLETED || newState == TransactionState.TERMINATED)) {
            this.sipStack.decrementActiveClientTransactionCount();
        }
        super.setState(newState);
    }

    protected synchronized void startTransactionTimer() {
        if (this.transactionTimerStarted) {
            return;
        }
        TransactionTimer myTimer = new TransactionTimer();
        this.transactionTimerStarted = true;
        this.sipStack.getTimer().schedule((TimerTask)myTimer, this.BASE_TIMER_INTERVAL, (long)this.BASE_TIMER_INTERVAL);
    }

    public void terminate() throws ObjectInUseException {
        this.setState(TransactionState.TERMINATED);
    }

    protected boolean checkFromTag(SIPResponse sipResponse) {
        String originalFromTag = ((SIPRequest)this.getRequest()).getFromTag();
        if (this.defaultDialog != null) {
            if (originalFromTag == null ^ sipResponse.getFrom().getTag() == null) {
                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                return false;
            }
            if (originalFromTag != null && !originalFromTag.equalsIgnoreCase(sipResponse.getFrom().getTag())) {
                this.sipStack.getStackLogger().logDebug("From tag mismatch -- dropping response");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processResponse(SIPResponse sipResponse, MessageChannel incomingChannel) {
        SIPDialog dialog = null;
        String method = sipResponse.getCSeq().getMethod();
        String dialogId = sipResponse.getDialogId(false);
        if (method.equals("CANCEL") && this.lastRequest != null) {
            SIPClientTransaction ict = (SIPClientTransaction)this.lastRequest.getInviteTransaction();
            if (ict != null) {
                dialog = ict.defaultDialog;
            }
        } else {
            dialog = this.getDialog(dialogId);
        }
        if (dialog == null) {
            int code = sipResponse.getStatusCode();
            if (code > 100 && code < 300 && (sipResponse.getToTag() != null || this.sipStack.isRfc2543Supported()) && this.sipStack.isDialogCreated(method)) {
                SIPClientTransaction sIPClientTransaction = this;
                synchronized (sIPClientTransaction) {
                    if (this.defaultDialog != null) {
                        if (sipResponse.getFromTag() == null) throw new RuntimeException("Response without from-tag");
                        SIPResponse dialogResponse = this.defaultDialog.getLastResponse();
                        String defaultDialogId = this.defaultDialog.getDialogId();
                        if (dialogResponse == null || method.equals("SUBSCRIBE") && dialogResponse.getCSeq().getMethod().equals("NOTIFY") && defaultDialogId.equals(dialogId)) {
                            this.defaultDialog.setLastResponse(this, sipResponse);
                            dialog = this.defaultDialog;
                        } else {
                            dialog = this.sipStack.getDialog(dialogId);
                            if (dialog == null && this.defaultDialog.isAssigned()) {
                                dialog = this.sipStack.createDialog(this, sipResponse);
                            }
                        }
                        this.setDialog(dialog, dialog.getDialogId());
                    } else if (this.sipStack.isAutomaticDialogSupportEnabled) {
                        dialog = this.sipStack.createDialog(this, sipResponse);
                        this.setDialog(dialog, dialog.getDialogId());
                    }
                }
            } else {
                dialog = this.defaultDialog;
            }
        } else {
            dialog.setLastResponse(this, sipResponse);
        }
        this.processResponse(sipResponse, incomingChannel, dialog);
    }

    public synchronized Dialog getDialog() {
        SIPDialog retval = null;
        if (this.lastResponse != null && this.lastResponse.getFromTag() != null && this.lastResponse.getToTag() != null && this.lastResponse.getStatusCode() != 100) {
            String dialogId = this.lastResponse.getDialogId(false);
            retval = this.getDialog(dialogId);
        }
        if (retval == null) {
            retval = this.defaultDialog;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug(" sipDialogs =  " + this.sipDialogs + " default dialog " + this.defaultDialog + " retval " + retval);
        }
        return retval;
    }

    public synchronized SIPDialog getDialog(String dialogId) {
        SIPDialog retval = (SIPDialog)this.sipDialogs.get(dialogId);
        return retval;
    }

    public synchronized void setDialog(SIPDialog sipDialog, String dialogId) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logDebug("setDialog: " + dialogId + "sipDialog = " + sipDialog);
        }
        if (sipDialog == null) {
            this.sipStack.getStackLogger().logError("NULL DIALOG!!");
            throw new NullPointerException("bad dialog null");
        }
        if (this.defaultDialog == null) {
            this.defaultDialog = sipDialog;
        }
        if (dialogId != null && sipDialog.getDialogId() != null) {
            this.sipDialogs.put(dialogId, sipDialog);
        }
    }

    public synchronized SIPDialog getDefaultDialog() {
        return this.defaultDialog;
    }

    public void setNextHop(Hop hop) {
        this.nextHop = hop;
    }

    public Hop getNextHop() {
        return this.nextHop;
    }

    public void setNotifyOnRetransmit(boolean notifyOnRetransmit) {
        this.notifyOnRetransmit = notifyOnRetransmit;
    }

    public boolean isNotifyOnRetransmit() {
        return this.notifyOnRetransmit;
    }

    public void alertIfStillInCallingStateBy(int count) {
        this.timeoutIfStillInCallingState = true;
        this.callingStateTimeoutCount = count;
    }

    public class TransactionTimer
    extends SIPStackTimerTask {
        protected void runTask() {
            SIPClientTransaction clientTransaction = SIPClientTransaction.this;
            SIPTransactionStack sipStack = clientTransaction.sipStack;
            if (clientTransaction.isTerminated()) {
                block10: {
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("removing  = " + clientTransaction + " isReliable " + clientTransaction.isReliable());
                    }
                    sipStack.removeTransaction(clientTransaction);
                    try {
                        this.cancel();
                    }
                    catch (IllegalStateException ex) {
                        if (sipStack.isAlive()) break block10;
                        return;
                    }
                }
                if (!sipStack.cacheClientConnections && clientTransaction.isReliable()) {
                    int newUseCount = clientTransaction.getMessageChannel() instanceof TCPMessageChannel ? --((TCPMessageChannel)clientTransaction.getMessageChannel()).useCount : --((TLSMessageChannel)clientTransaction.getMessageChannel()).useCount;
                    if (newUseCount <= 0) {
                        SIPTransaction.LingerTimer myTimer = new SIPTransaction.LingerTimer(SIPClientTransaction.this);
                        sipStack.getTimer().schedule((TimerTask)myTimer, 8000L);
                    }
                } else if (sipStack.isLoggingEnabled() && clientTransaction.isReliable()) {
                    int useCount = clientTransaction.getMessageChannel() instanceof TCPMessageChannel ? ((TCPMessageChannel)clientTransaction.getMessageChannel()).useCount : ((TLSMessageChannel)clientTransaction.getMessageChannel()).useCount;
                    if (sipStack.isLoggingEnabled()) {
                        sipStack.getStackLogger().logDebug("Client Use Count = " + useCount);
                    }
                }
            } else {
                clientTransaction.fireTimer();
            }
        }
    }
}

