/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.AlertInfo;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.ErrorInfo;
import gov.nist.javax.sip.header.ErrorInfoList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.InReplyTo;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.Priority;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequire;
import gov.nist.javax.sip.header.ProxyRequireList;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPETag;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.SIPHeaderNamesCache;
import gov.nist.javax.sip.header.SIPIfMatch;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Subject;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Unsupported;
import gov.nist.javax.sip.header.UserAgent;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.header.Warning;
import gov.nist.javax.sip.message.HeaderIterator;
import gov.nist.javax.sip.message.ListMap;
import gov.nist.javax.sip.message.MessageExt;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.MessageObject;
import gov.nist.javax.sip.message.MultipartMimeContent;
import gov.nist.javax.sip.message.MultipartMimeContentImpl;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.ParserFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentEncodingHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SIPMessage
extends MessageObject
implements Message,
MessageExt {
    private String contentEncodingCharset = MessageFactoryImpl.getDefaultContentEncodingCharset();
    protected LinkedList<String> unrecognizedHeaders = new LinkedList();
    protected ConcurrentLinkedQueue<SIPHeader> headers = new ConcurrentLinkedQueue();
    protected From fromHeader;
    protected To toHeader;
    protected CSeq cSeqHeader;
    protected CallID callIdHeader;
    protected ContentLength contentLengthHeader;
    protected MaxForwards maxForwardsHeader;
    protected int size;
    private String messageContent;
    private byte[] messageContentBytes;
    private Object messageContentObject;
    private Hashtable<String, SIPHeader> nameTable = new Hashtable();
    protected Object applicationData;
    private static final String CONTENT_TYPE_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Content-Type");
    private static final String ERROR_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Error-Info");
    private static final String CONTACT_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Contact");
    private static final String VIA_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Via");
    private static final String AUTHORIZATION_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Authorization");
    private static final String ROUTE_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Route");
    private static final String RECORDROUTE_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Record-Route");
    private static final String CONTENT_DISPOSITION_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Content-Disposition");
    private static final String CONTENT_ENCODING_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Content-Encoding");
    private static final String CONTENT_LANGUAGE_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Content-Language");
    private static final String EXPIRES_LOWERCASE = SIPHeaderNamesCache.toLowerCase("Expires");

    public static boolean isRequestHeader(SIPHeader sipHeader) {
        return sipHeader instanceof AlertInfo || sipHeader instanceof InReplyTo || sipHeader instanceof Authorization || sipHeader instanceof MaxForwards || sipHeader instanceof UserAgent || sipHeader instanceof Priority || sipHeader instanceof ProxyAuthorization || sipHeader instanceof ProxyRequire || sipHeader instanceof ProxyRequireList || sipHeader instanceof Route || sipHeader instanceof RouteList || sipHeader instanceof Subject || sipHeader instanceof SIPIfMatch;
    }

    public static boolean isResponseHeader(SIPHeader sipHeader) {
        return sipHeader instanceof ErrorInfo || sipHeader instanceof ProxyAuthenticate || sipHeader instanceof Server || sipHeader instanceof Unsupported || sipHeader instanceof RetryAfter || sipHeader instanceof Warning || sipHeader instanceof WWWAuthenticate || sipHeader instanceof SIPETag || sipHeader instanceof RSeq;
    }

    public LinkedList<String> getMessageAsEncodedStrings() {
        LinkedList<String> retval = new LinkedList<String>();
        for (SIPHeader sipHeader : this.headers) {
            if (sipHeader instanceof SIPHeaderList) {
                SIPHeaderList shl = (SIPHeaderList)sipHeader;
                retval.addAll(shl.getHeadersAsEncodedStrings());
                continue;
            }
            retval.add(sipHeader.encode());
        }
        return retval;
    }

    protected String encodeSIPHeaders() {
        StringBuffer encoding = new StringBuffer();
        for (SIPHeader siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            siphdr.encode(encoding);
        }
        return this.contentLengthHeader.encode(encoding).append("\r\n").toString();
    }

    public abstract String encodeMessage();

    public abstract String getDialogId(boolean var1);

    @Override
    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage matchObj = (SIPMessage)other;
        Iterator<SIPHeader> li = matchObj.getHeaders();
        while (li.hasNext()) {
            SIPHeader hisHeaders = li.next();
            List<SIPHeader> myHeaders = this.getHeaderList(hisHeaders.getHeaderName());
            if (myHeaders == null || myHeaders.size() == 0) {
                return false;
            }
            if (hisHeaders instanceof SIPHeaderList) {
                ListIterator outerIterator = ((SIPHeaderList)hisHeaders).listIterator();
                while (outerIterator.hasNext()) {
                    SIPHeader hisHeader = (SIPHeader)outerIterator.next();
                    if (hisHeader instanceof ContentLength) continue;
                    ListIterator<SIPHeader> innerIterator = myHeaders.listIterator();
                    boolean found = false;
                    while (innerIterator.hasNext()) {
                        SIPHeader myHeader = innerIterator.next();
                        if (!myHeader.match(hisHeader)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                continue;
            }
            SIPHeader hisHeader = hisHeaders;
            ListIterator<SIPHeader> innerIterator = myHeaders.listIterator();
            boolean found = false;
            while (innerIterator.hasNext()) {
                SIPHeader myHeader = innerIterator.next();
                if (!myHeader.match(hisHeader)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void merge(Object template) {
        if (!template.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + template.getClass());
        }
        SIPMessage templateMessage = (SIPMessage)template;
        Object[] templateHeaders = templateMessage.headers.toArray();
        for (int i = 0; i < templateHeaders.length; ++i) {
            SIPHeader hdr = (SIPHeader)templateHeaders[i];
            String hdrName = hdr.getHeaderName();
            List<SIPHeader> myHdrs = this.getHeaderList(hdrName);
            if (myHdrs == null) {
                this.attachHeader(hdr);
                continue;
            }
            ListIterator<SIPHeader> it = myHdrs.listIterator();
            while (it.hasNext()) {
                SIPHeader sipHdr = it.next();
                sipHdr.merge(hdr);
            }
        }
    }

    @Override
    public String encode() {
        StringBuffer encoding = new StringBuffer();
        for (SIPHeader siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            encoding.append(siphdr.encode());
        }
        for (String unrecognized : this.unrecognizedHeaders) {
            encoding.append(unrecognized).append("\r\n");
        }
        encoding.append(this.contentLengthHeader.encode()).append("\r\n");
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, this.contentEncodingCharset);
            }
            catch (UnsupportedEncodingException ex) {
                content = "";
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAsBytes(String transport) {
        if (this instanceof SIPRequest && ((SIPRequest)this).isNullRequest()) {
            return "\r\n\r\n".getBytes();
        }
        ViaHeader topVia = (ViaHeader)this.getHeader("Via");
        try {
            topVia.setTransport(transport);
        }
        catch (ParseException e) {
            InternalErrorHandler.handleException(e);
        }
        StringBuffer encoding = new StringBuffer();
        ConcurrentLinkedQueue<SIPHeader> concurrentLinkedQueue = this.headers;
        synchronized (concurrentLinkedQueue) {
            for (SIPHeader siphdr : this.headers) {
                if (siphdr instanceof ContentLength) continue;
                siphdr.encode(encoding);
            }
        }
        this.contentLengthHeader.encode(encoding);
        encoding.append("\r\n");
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            try {
                retval = encoding.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        return retval;
    }

    @Override
    public Object clone() {
        SIPMessage retval = (SIPMessage)super.clone();
        retval.nameTable = new Hashtable();
        retval.fromHeader = null;
        retval.toHeader = null;
        retval.cSeqHeader = null;
        retval.callIdHeader = null;
        retval.contentLengthHeader = null;
        retval.maxForwardsHeader = null;
        if (this.headers != null) {
            retval.headers = new ConcurrentLinkedQueue();
            for (SIPHeader hdr : this.headers) {
                retval.attachHeader((SIPHeader)hdr.clone());
            }
        }
        if (this.messageContentBytes != null) {
            retval.messageContentBytes = (byte[])this.messageContentBytes.clone();
        }
        if (this.messageContentObject != null) {
            retval.messageContentObject = SIPMessage.makeClone(this.messageContentObject);
        }
        retval.unrecognizedHeaders = this.unrecognizedHeaders;
        return retval;
    }

    @Override
    public String debugDump() {
        this.stringRepresentation = "";
        this.sprint("SIPMessage:");
        this.sprint("{");
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (f.get(this) == null || !SIPHeader.class.isAssignableFrom(fieldType) || fieldName.compareTo("headers") == 0) continue;
                this.sprint(fieldName + "=");
                this.sprint(((SIPHeader)f.get(this)).debugDump());
            }
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        this.sprint("List of headers : ");
        this.sprint(this.headers.toString());
        this.sprint("messageContent = ");
        this.sprint("{");
        this.sprint(this.messageContent);
        this.sprint("}");
        if (this.getContent() != null) {
            this.sprint(this.getContent().toString());
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public SIPMessage() {
        try {
            this.attachHeader(new ContentLength(0), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attachHeader(SIPHeader h) {
        if (h == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (h instanceof SIPHeaderList && (hl = (SIPHeaderList)h).isEmpty()) {
                return;
            }
            this.attachHeader(h, false, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            // empty catch block
        }
    }

    @Override
    public void setHeader(Header sipHeader) {
        SIPHeader header = (SIPHeader)sipHeader;
        if (header == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList hl;
            if (header instanceof SIPHeaderList && (hl = (SIPHeaderList)header).isEmpty()) {
                return;
            }
            this.removeHeader(header.getHeaderName());
            this.attachHeader(header, true, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    public void setHeaders(List<SIPHeader> headers) {
        ListIterator<SIPHeader> listIterator = headers.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sipHeader = listIterator.next();
            try {
                this.attachHeader(sipHeader, false);
            }
            catch (SIPDuplicateHeaderException ex) {}
        }
    }

    public void attachHeader(SIPHeader h, boolean replaceflag) throws SIPDuplicateHeaderException {
        this.attachHeader(h, replaceflag, false);
    }

    public void attachHeader(SIPHeader header, boolean replaceFlag, boolean top) throws SIPDuplicateHeaderException {
        SIPHeaderList<SIPHeader> h;
        if (header == null) {
            throw new NullPointerException("null header");
        }
        if (ListMap.hasList(header) && !SIPHeaderList.class.isAssignableFrom(header.getClass())) {
            SIPHeaderList<SIPHeader> hdrList = ListMap.getList(header);
            hdrList.add(header);
            h = hdrList;
        } else {
            h = header;
        }
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase(((SIPHeader)h).getName());
        if (replaceFlag) {
            this.nameTable.remove(headerNameLowerCase);
        } else if (this.nameTable.containsKey(headerNameLowerCase) && !(h instanceof SIPHeaderList)) {
            if (h instanceof ContentLength) {
                try {
                    ContentLength cl = (ContentLength)((Object)h);
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
                catch (InvalidArgumentException e) {
                    // empty catch block
                }
            }
            return;
        }
        SIPHeader originalHeader = (SIPHeader)this.getHeader(((SIPHeader)header).getName());
        if (originalHeader != null) {
            Iterator<SIPHeader> li = this.headers.iterator();
            while (li.hasNext()) {
                SIPHeader next = li.next();
                if (!next.equals(originalHeader)) continue;
                li.remove();
            }
        }
        if (!this.nameTable.containsKey(headerNameLowerCase)) {
            this.nameTable.put(headerNameLowerCase, h);
            this.headers.add(h);
        } else if (h instanceof SIPHeaderList) {
            SIPHeaderList hdrlist = (SIPHeaderList)this.nameTable.get(headerNameLowerCase);
            if (hdrlist != null) {
                hdrlist.concatenate(h, top);
            } else {
                this.nameTable.put(headerNameLowerCase, h);
            }
        } else {
            this.nameTable.put(headerNameLowerCase, h);
        }
        if (h instanceof From) {
            this.fromHeader = (From)((Object)h);
        } else if (h instanceof ContentLength) {
            this.contentLengthHeader = (ContentLength)((Object)h);
        } else if (h instanceof To) {
            this.toHeader = (To)((Object)h);
        } else if (h instanceof CSeq) {
            this.cSeqHeader = (CSeq)((Object)h);
        } else if (h instanceof CallID) {
            this.callIdHeader = (CallID)((Object)h);
        } else if (h instanceof MaxForwards) {
            this.maxForwardsHeader = (MaxForwards)((Object)h);
        }
    }

    public void removeHeader(String headerName, boolean top) {
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase(headerName);
        SIPHeader toRemove = this.nameTable.get(headerNameLowerCase);
        if (toRemove == null) {
            return;
        }
        if (toRemove instanceof SIPHeaderList) {
            SIPHeaderList hdrList = (SIPHeaderList)toRemove;
            if (top) {
                hdrList.removeFirst();
            } else {
                hdrList.removeLast();
            }
            if (hdrList.isEmpty()) {
                Iterator<SIPHeader> li = this.headers.iterator();
                while (li.hasNext()) {
                    SIPHeader sipHeader = li.next();
                    if (!sipHeader.getName().equalsIgnoreCase(headerNameLowerCase)) continue;
                    li.remove();
                }
                this.nameTable.remove(headerNameLowerCase);
            }
        } else {
            this.nameTable.remove(headerNameLowerCase);
            if (toRemove instanceof From) {
                this.fromHeader = null;
            } else if (toRemove instanceof To) {
                this.toHeader = null;
            } else if (toRemove instanceof CSeq) {
                this.cSeqHeader = null;
            } else if (toRemove instanceof CallID) {
                this.callIdHeader = null;
            } else if (toRemove instanceof MaxForwards) {
                this.maxForwardsHeader = null;
            } else if (toRemove instanceof ContentLength) {
                this.contentLengthHeader = null;
            }
            Iterator<SIPHeader> li = this.headers.iterator();
            while (li.hasNext()) {
                SIPHeader sipHeader = li.next();
                if (!sipHeader.getName().equalsIgnoreCase(headerName)) continue;
                li.remove();
            }
        }
    }

    @Override
    public void removeHeader(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null arg");
        }
        String headerNameLowerCase = SIPHeaderNamesCache.toLowerCase(headerName);
        SIPHeader removed = this.nameTable.remove(headerNameLowerCase);
        if (removed == null) {
            return;
        }
        if (removed instanceof From) {
            this.fromHeader = null;
        } else if (removed instanceof To) {
            this.toHeader = null;
        } else if (removed instanceof CSeq) {
            this.cSeqHeader = null;
        } else if (removed instanceof CallID) {
            this.callIdHeader = null;
        } else if (removed instanceof MaxForwards) {
            this.maxForwardsHeader = null;
        } else if (removed instanceof ContentLength) {
            this.contentLengthHeader = null;
        }
        Iterator<SIPHeader> li = this.headers.iterator();
        while (li.hasNext()) {
            SIPHeader sipHeader = li.next();
            if (!sipHeader.getName().equalsIgnoreCase(headerNameLowerCase)) continue;
            li.remove();
        }
    }

    public String getTransactionId() {
        Via topVia = null;
        if (!this.getViaHeaders().isEmpty()) {
            topVia = (Via)this.getViaHeaders().getFirst();
        }
        if (topVia != null && topVia.getBranch() != null && topVia.getBranch().toUpperCase().startsWith("Z9HG4BK")) {
            if (this.getCSeq().getMethod().equals("CANCEL")) {
                return (topVia.getBranch() + ":" + this.getCSeq().getMethod()).toLowerCase();
            }
            return topVia.getBranch().toLowerCase();
        }
        StringBuffer retval = new StringBuffer();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        if (from.hasTag()) {
            retval.append(from.getTag()).append("-");
        }
        String cid = this.callIdHeader.getCallId();
        retval.append(cid).append("-");
        retval.append(this.cSeqHeader.getSequenceNumber()).append("-").append(this.cSeqHeader.getMethod());
        if (topVia != null) {
            retval.append("-").append(topVia.getSentBy().encode());
            if (!topVia.getSentBy().hasPort()) {
                retval.append("-").append(5060);
            }
        }
        if (this.getCSeq().getMethod().equals("CANCEL")) {
            retval.append("CANCEL");
        }
        return retval.toString().toLowerCase().replace(":", "-").replace("@", "-") + Utils.getSignature();
    }

    @Override
    public int hashCode() {
        if (this.callIdHeader == null) {
            throw new RuntimeException("Invalid message! Cannot compute hashcode! call-id header is missing !");
        }
        return this.callIdHeader.getCallId().hashCode();
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public Iterator<SIPHeader> getHeaders() {
        return this.headers.iterator();
    }

    @Override
    public Header getHeader(String headerName) {
        return this.getHeaderLowerCase(SIPHeaderNamesCache.toLowerCase(headerName));
    }

    private Header getHeaderLowerCase(String lowerCaseHeaderName) {
        if (lowerCaseHeaderName == null) {
            throw new NullPointerException("bad name");
        }
        SIPHeader sipHeader = this.nameTable.get(lowerCaseHeaderName);
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).getFirst();
        }
        return sipHeader;
    }

    public ContentType getContentTypeHeader() {
        return (ContentType)this.getHeaderLowerCase(CONTENT_TYPE_LOWERCASE);
    }

    public FromHeader getFrom() {
        return this.fromHeader;
    }

    public ErrorInfoList getErrorInfoHeaders() {
        return (ErrorInfoList)this.getSIPHeaderListLowerCase(ERROR_LOWERCASE);
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getSIPHeaderListLowerCase(CONTACT_LOWERCASE);
    }

    public Contact getContactHeader() {
        ContactList clist = this.getContactHeaders();
        if (clist != null) {
            return (Contact)clist.getFirst();
        }
        return null;
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getSIPHeaderListLowerCase(VIA_LOWERCASE);
    }

    public void setVia(List viaList) {
        ViaList vList = new ViaList();
        ListIterator it = viaList.listIterator();
        while (it.hasNext()) {
            Via via = (Via)it.next();
            vList.add(via);
        }
        this.setHeader(vList);
    }

    public void setHeader(SIPHeaderList<Via> sipHeaderList) {
        this.setHeader((Header)sipHeaderList);
    }

    public Via getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (Via)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeq() {
        return this.cSeqHeader;
    }

    public Authorization getAuthorization() {
        return (Authorization)this.getHeaderLowerCase(AUTHORIZATION_LOWERCASE);
    }

    public MaxForwardsHeader getMaxForwards() {
        return this.maxForwardsHeader;
    }

    public void setMaxForwards(MaxForwardsHeader maxForwards) {
        this.setHeader(maxForwards);
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getSIPHeaderListLowerCase(ROUTE_LOWERCASE);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callId) {
        this.setHeader(callId);
    }

    public void setCallId(String callId) throws ParseException {
        if (this.callIdHeader == null) {
            this.setHeader(new CallID());
        }
        this.callIdHeader.setCallId(callId);
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getSIPHeaderListLowerCase(RECORDROUTE_LOWERCASE);
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader to) {
        this.setHeader(to);
    }

    public void setFrom(FromHeader from) {
        this.setHeader(from);
    }

    @Override
    public ContentLengthHeader getContentLength() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            String charset;
            ContentType contentTypeHeader = this.getContentTypeHeader();
            this.messageContent = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? new String(this.messageContentBytes, charset) : new String(this.messageContentBytes, this.contentEncodingCharset)) : new String(this.messageContentBytes, this.contentEncodingCharset);
        }
        return this.messageContent;
    }

    @Override
    public byte[] getRawContent() {
        try {
            if (this.messageContent == null && this.messageContentBytes == null && this.messageContentObject == null) {
                return null;
            }
            if (this.messageContentObject != null) {
                String charset;
                String messageContent = this.messageContentObject.toString();
                ContentType contentTypeHeader = this.getContentTypeHeader();
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? messageContent.getBytes(charset) : messageContent.getBytes(this.contentEncodingCharset)) : messageContent.getBytes(this.contentEncodingCharset);
                return messageContentBytes;
            }
            if (this.messageContent != null) {
                String charset;
                ContentType contentTypeHeader = this.getContentTypeHeader();
                byte[] messageContentBytes = contentTypeHeader != null ? ((charset = contentTypeHeader.getCharset()) != null ? this.messageContent.getBytes(charset) : this.messageContent.getBytes(this.contentEncodingCharset)) : this.messageContent.getBytes(this.contentEncodingCharset);
                return messageContentBytes;
            }
            return this.messageContentBytes;
        }
        catch (UnsupportedEncodingException ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    public void setMessageContent(String type, String subType, String messageContent) {
        if (messageContent == null) {
            throw new IllegalArgumentException("messgeContent is null");
        }
        ContentType ct = new ContentType(type, subType);
        this.setHeader(ct);
        this.messageContent = messageContent;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        this.computeContentLength(messageContent);
    }

    @Override
    public void setContent(Object content, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (content == null) {
            throw new NullPointerException("null content");
        }
        this.setHeader(contentTypeHeader);
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        if (content instanceof String) {
            this.messageContent = (String)content;
        } else if (content instanceof byte[]) {
            this.messageContentBytes = (byte[])content;
        } else {
            this.messageContentObject = content;
        }
        this.computeContentLength(content);
    }

    @Override
    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        return null;
    }

    public void setMessageContent(String type, String subType, byte[] messageContent) {
        ContentType ct = new ContentType(type, subType);
        this.setHeader(ct);
        this.setMessageContent(messageContent);
        this.computeContentLength(messageContent);
    }

    public void setMessageContent(String content, boolean computeContentLength, int givenLength) throws ParseException {
        this.computeContentLength(content);
        if (!computeContentLength && this.contentLengthHeader.getContentLength() < givenLength) {
            throw new ParseException("Invalid content length " + this.contentLengthHeader.getContentLength() + " / " + givenLength, 0);
        }
        this.messageContent = content;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content) {
        this.computeContentLength(content);
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] content, boolean computeContentLength, int givenLength) throws ParseException {
        this.computeContentLength(content);
        if (!computeContentLength && this.contentLengthHeader.getContentLength() < givenLength) {
            throw new ParseException("Invalid content length " + this.contentLengthHeader.getContentLength() + " / " + givenLength, 0);
        }
        this.messageContentBytes = content;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    private void computeContentLength(Object content) {
        int length = 0;
        if (content != null) {
            if (content instanceof String) {
                String charset = null;
                ContentType contentTypeHeader = this.getContentTypeHeader();
                if (contentTypeHeader != null) {
                    charset = contentTypeHeader.getCharset();
                }
                if (charset == null) {
                    charset = this.contentEncodingCharset;
                }
                try {
                    length = ((String)content).getBytes(charset).length;
                }
                catch (UnsupportedEncodingException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            } else {
                length = content instanceof byte[] ? ((byte[])content).length : content.toString().length();
            }
        }
        try {
            this.contentLengthHeader.setContentLength(length);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        try {
            this.contentLengthHeader.setContentLength(0);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Override
    public ListIterator<SIPHeader> getHeaders(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("null headerName");
        }
        SIPHeader sipHeader = this.nameTable.get(SIPHeaderNamesCache.toLowerCase(headerName));
        if (sipHeader == null) {
            return new LinkedList().listIterator();
        }
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).listIterator();
        }
        return new HeaderIterator(this, sipHeader);
    }

    public String getHeaderAsFormattedString(String name) {
        String lowerCaseName = name.toLowerCase();
        if (this.nameTable.containsKey(lowerCaseName)) {
            return this.nameTable.get(lowerCaseName).toString();
        }
        return ((Object)this.getHeader(name)).toString();
    }

    private SIPHeader getSIPHeaderListLowerCase(String lowerCaseHeaderName) {
        return this.nameTable.get(lowerCaseHeaderName);
    }

    private List<SIPHeader> getHeaderList(String headerName) {
        SIPHeader sipHeader = this.nameTable.get(SIPHeaderNamesCache.toLowerCase(headerName));
        if (sipHeader == null) {
            return null;
        }
        if (sipHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sipHeader).getHeaderList();
        }
        LinkedList<SIPHeader> ll = new LinkedList<SIPHeader>();
        ll.add(sipHeader);
        return ll;
    }

    public boolean hasHeader(String headerName) {
        return this.nameTable.containsKey(SIPHeaderNamesCache.toLowerCase(headerName));
    }

    public boolean hasFromTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromTag(String tag) {
        try {
            this.fromHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setToTag(String tag) {
        try {
            this.toHeader.setTag(tag);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    @Override
    public void addHeader(Header sipHeader) {
        SIPHeader sh = (SIPHeader)sipHeader;
        try {
            if (sipHeader instanceof ViaHeader || sipHeader instanceof RecordRouteHeader) {
                this.attachHeader(sh, false, true);
            } else {
                this.attachHeader(sh, false, false);
            }
        }
        catch (SIPDuplicateHeaderException ex) {
            try {
                if (sipHeader instanceof ContentLength) {
                    ContentLength cl = (ContentLength)sipHeader;
                    this.contentLengthHeader.setContentLength(cl.getContentLength());
                }
            }
            catch (InvalidArgumentException e) {
                // empty catch block
            }
        }
    }

    public void addUnparsed(String unparsed) {
        this.unrecognizedHeaders.add(unparsed);
    }

    public void addHeader(String sipHeader) {
        String hdrString = sipHeader.trim() + "\n";
        try {
            HeaderParser parser = ParserFactory.createParser(sipHeader);
            SIPHeader sh = parser.parse();
            this.attachHeader(sh, false);
        }
        catch (ParseException ex) {
            this.unrecognizedHeaders.add(hdrString);
        }
    }

    @Override
    public ListIterator<String> getUnrecognizedHeaders() {
        return this.unrecognizedHeaders.listIterator();
    }

    @Override
    public ListIterator<String> getHeaderNames() {
        Iterator<SIPHeader> li = this.headers.iterator();
        LinkedList<String> retval = new LinkedList<String>();
        while (li.hasNext()) {
            SIPHeader sipHeader = li.next();
            String name = sipHeader.getName();
            retval.add(name);
        }
        return retval.listIterator();
    }

    @Override
    public boolean equals(Object other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage otherMessage = (SIPMessage)other;
        Collection<SIPHeader> values = this.nameTable.values();
        Iterator<SIPHeader> it = values.iterator();
        if (this.nameTable.size() != otherMessage.nameTable.size()) {
            return false;
        }
        while (it.hasNext()) {
            SIPHeader mine = it.next();
            SIPHeader his = otherMessage.nameTable.get(SIPHeaderNamesCache.toLowerCase(mine.getName()));
            if (his == null) {
                return false;
            }
            if (his.equals(mine)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ContentDispositionHeader getContentDisposition() {
        return (ContentDispositionHeader)this.getHeaderLowerCase(CONTENT_DISPOSITION_LOWERCASE);
    }

    @Override
    public ContentEncodingHeader getContentEncoding() {
        return (ContentEncodingHeader)this.getHeaderLowerCase(CONTENT_ENCODING_LOWERCASE);
    }

    @Override
    public ContentLanguageHeader getContentLanguage() {
        return (ContentLanguageHeader)this.getHeaderLowerCase(CONTENT_LANGUAGE_LOWERCASE);
    }

    @Override
    public ExpiresHeader getExpires() {
        return (ExpiresHeader)this.getHeaderLowerCase(EXPIRES_LOWERCASE);
    }

    @Override
    public void setExpires(ExpiresHeader expiresHeader) {
        this.setHeader(expiresHeader);
    }

    @Override
    public void setContentDisposition(ContentDispositionHeader contentDispositionHeader) {
        this.setHeader(contentDispositionHeader);
    }

    @Override
    public void setContentEncoding(ContentEncodingHeader contentEncodingHeader) {
        this.setHeader(contentEncodingHeader);
    }

    @Override
    public void setContentLanguage(ContentLanguageHeader contentLanguageHeader) {
        this.setHeader(contentLanguageHeader);
    }

    @Override
    public void setContentLength(ContentLengthHeader contentLength) {
        try {
            this.contentLengthHeader.setContentLength(contentLength.getContentLength());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void addLast(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, false);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    @Override
    public void addFirst(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, true);
        }
        catch (SIPDuplicateHeaderException ex) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    @Override
    public void removeFirst(String headerName) throws NullPointerException {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, true);
    }

    @Override
    public void removeLast(String headerName) {
        if (headerName == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(headerName, false);
    }

    public void setCSeq(CSeqHeader cseqHeader) {
        this.setHeader(cseqHeader);
    }

    @Override
    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    @Override
    public Object getApplicationData() {
        return this.applicationData;
    }

    @Override
    public MultipartMimeContent getMultipartMimeContent() throws ParseException {
        if (this.contentLengthHeader.getContentLength() == 0) {
            return null;
        }
        MultipartMimeContentImpl retval = new MultipartMimeContentImpl(this.getContentTypeHeader());
        byte[] rawContent = this.getRawContent();
        String body = new String(rawContent);
        retval.createContentList(body);
        return retval;
    }

    @Override
    public abstract void setSIPVersion(String var1) throws ParseException;

    @Override
    public abstract String getSIPVersion();

    @Override
    public abstract String toString();
}

