using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Expression;

namespace MinorShift.Emuera.GameProc
{
	internal sealed partial class Process
	{
		private enum SystemStateCode
		{
			__CAN_SAVE__ = 0x10000,//Z[u[hʂĂяo\H
			__CAN_BEGIN__ = 0x20000,//BEGIN߂Ăяo\H
			Title_Begin = 0,//
			Openning = 1,//ŏ̓͑҂
			Train_Begin = 0x10,//BEGIN TRAINB
			Train_CallEventTrain = 0x11,//@EVENTTRAIŇĂяoBXLbv\
			Train_CallShowStatus = 0x12,//@SHOW_STATUŠĂяo
			Train_CallComAbleXX = 0x13,//@COM_ABLExx̌ĂяoBXLbv̏ꍇARETURN 1ƂB
			Train_CallShowUserCom = 0x14,//@SHOW_USERCOM̌Ăяo
			Train_WaitInput = 0x15,//͑҂ԁBIs\ȂEVENTCOMCOMxxAłȂ@USERCOMRESULTn
			Train_CallEventCom = 0x16 | __CAN_BEGIN__,//COMxx֗ꗎ郂[h

			Train_CallComXX = 0x17 | __CAN_BEGIN__,//Is\Ȃ@COMxxAłȂ@USERCOM
			Train_CallSourceCheck = 0x18 | __CAN_BEGIN__,//@SOURCE_CHECǨĂяo
			Train_CallEventComEnd = 0x19 | __CAN_BEGIN__,//@EVENTCOMENĎĂяoBXLbv\BTrain_CallEventTrain֋AB

			AfterTrain_Begin = 0x20 | __CAN_BEGIN__,//BEGIN AFTERTRAINB@EVENTENDĂяoNormalցB

			Ablup_Begin = 0x30,//BEGIN ABLUPB
			Ablup_CallShowJuel = 0x31,//@SHOW_JUEL
			Ablup_CallShowAblupSelect = 0x32,//@SHOW_ABLUP_SELECT
			Ablup_WaitInput = 0x33,//
			Ablup_CallAblupXX = 0x34 | __CAN_BEGIN__,//@ABLUPxxȂꍇ́A@USERABLUPRESULTnBAblup_CallShowJuel֖߂B

			Turnend_Begin = 0x40 | __CAN_BEGIN__,//BEGIN TURNENDB@EVENTTURNENDĂяoNormalցB

			Shop_Begin = 0x50 | __CAN_SAVE__,//BEGIN SHOP
			Shop_CallEventShop = 0x51 | __CAN_SAVE__,//@EVENTSHOP̌ĂяoBXLbv\
			Shop_CallShowShop = 0x52 | __CAN_SAVE__,//@SHOW_SHOP̌Ăяo
			Shop_WaitInput = 0x53 | __CAN_SAVE__,//͑҂ԁBACe݂ȂEVENTBUYBOUGHTAłȂ@USERSHOPRESULTn
			Shop_CallEventBuy = 0x54 | __CAN_BEGIN__ | __CAN_SAVE__,//@USERSHOP܂@EVENTBUY͂̌Ăяo

			SaveGame_Begin = 0x100,//SAVEGAME
			SaveGame_WaitInput = 0x101,//͑҂
			SaveGame_WaitInputOverwrite = 0x102,//㏑̋҂
			SaveGame_CallSaveInfo = 0x103,//@SAVEINFOĂяoB20B
			LoadGame_Begin = 0x110,//LOADGAME
			LoadGame_WaitInput = 0x111,//͑҂
			LoadGameOpenning_Begin = 0x120,//ŏ[1]IƂB
			LoadGameOpenning_WaitInput = 0x121,//͑҂


			//AutoSave_Begin = 0x200,
			AutoSave_CallSaveInfo = 0x201,
			AutoSave_CallUniqueAutosave = 0x202,

			LoadData_DataLoaded = 0x210,//f[^[h
			LoadData_CallEventLoad = 0x211 | __CAN_BEGIN__,//@EVENTLOAĎĂяoBXLbv\

			Openning_TitleLoadgame = 0x220,

			System_Reloaderb = 0x230,
			First_Begin = 0x240,

			Normal = 0xFFFF | __CAN_BEGIN__ | __CAN_SAVE__,//ɉłȂƂBScriptEndɒBG[


		}

		internal enum BeginType
		{
			NULL = 0,
			SHOP = 2,
			TRAIN = 3,
			AFTERTRAIN = 4,
			ABLUP = 5,
			TURNEND = 6,
			FIRST = 7,
			TITLE = 8,
		}

		private sealed class ProcessState
		{
			public ProcessState()
			{
			}
			readonly List<CalledFunction> functionList = new List<CalledFunction>();
			private LogicalLine currentLine;
			private LogicalLine nextLine;
			private bool sequential;

			public bool ScriptEnd
			{
				get { return functionList.Count == 0; }
			}

			SystemStateCode sysStateCode = SystemStateCode.Title_Begin;
			BeginType begintype = BeginType.NULL;
			//StringBuilder putsave = null;
			//public void SetPUTSAVE()
			//{
			//    if (putsave != null)
			//        throw new ExeEE("PUTSAVEdɍꂽ");
			//    putsave = new StringBuilder();
			//    putsave.Append(DateTime.Now.ToString());
			//    putsave.Append(" ");
			//}

			//public void AddPUTSAVE(string str)
			//{
			//    if (putsave == null)
			//        throw new ExeEE("PUTSAVEȂ̂ɌĂ΂ꂽ");
			//    putsave.Append(str);
			//}
			//public string GetPUTSAVE()
			//{
			//    if (putsave == null)
			//        throw new ExeEE("PUTSAVEȂ̂ɌĂ΂ꂽ");
			//    string ret = putsave.ToString();
			//    putsave = null;
			//    return ret;
			//}

			public LogicalLine CurrentLine { get { return currentLine; } }
			public bool Sequential { get { return sequential; } }
			public CalledFunction CurrentCalled
			{
				get
				{
					if (functionList.Count == 0)
						throw new ExeEE("s֐Ȃ");
					return functionList[functionList.Count - 1];
				}
			}
			public SystemStateCode SystemState
			{
				get { return sysStateCode; }
				set { sysStateCode = value; }
			}

			public void ShfitNextLine()
			{
				currentLine = nextLine;
				nextLine = nextLine.NextLine;
				sequential = true;
			}

			public void JumpTo(LogicalLine line)
			{
				nextLine = line;
				sequential = false;
			}




			public void SetBegin(BeginType type)
			{
				string errmes = "";
				switch (type)
				{
					case BeginType.SHOP:
					case BeginType.TRAIN:
					case BeginType.AFTERTRAIN:
					case BeginType.ABLUP:
					case BeginType.TURNEND:
					case BeginType.FIRST:
					case BeginType.TITLE:
						if ((sysStateCode & SystemStateCode.__CAN_BEGIN__) != SystemStateCode.__CAN_BEGIN__)
						{
							errmes = "BEGIN";
							goto err;
						}
						break;
					default:
						throw new ExeEE("sKBEGINĂяo");
				}
				begintype = type;
				return;
			err:
				CalledFunction func = functionList[0];
				string funcName = func.FunctionName;
				throw new CodeEE("@" + funcName + "" + errmes + "߂s邱Ƃ͂ł܂");
			}

			public void SaveLoadData(bool saveData)
			{

				if ((sysStateCode & SystemStateCode.__CAN_SAVE__) != SystemStateCode.__CAN_SAVE__)
				{
					CalledFunction func = functionList[0];
					string funcName = func.FunctionName;
					throw new CodeEE("@" + funcName + "SAVEGAME/LOADGAME߂s邱Ƃ͂ł܂");
				}
				if (saveData)
					sysStateCode = SystemStateCode.SaveGame_Begin;
				else
					sysStateCode = SystemStateCode.LoadGame_Begin;
				functionList.Clear();
				begintype = BeginType.NULL;
				return;
			}

			public void ClearFunctionList()
			{
				functionList.Clear();
				begintype = BeginType.NULL;
			}

			public bool calledWhenNormal = true;
			/// <summary>
			/// BEGIN߂ɂvOԂ̕ω
			/// </summary>
			/// <param name="key"></param>
			/// <returns></returns>
			public void Begin()
			{
				switch (begintype)
				{
					case BeginType.SHOP:
						if (sysStateCode == SystemStateCode.Normal)
							calledWhenNormal = true;
						else
							calledWhenNormal = false;
						sysStateCode = SystemStateCode.Shop_Begin;
						break;
					case BeginType.TRAIN:
						sysStateCode = SystemStateCode.Train_Begin;
						break;
					case BeginType.AFTERTRAIN:
						sysStateCode = SystemStateCode.AfterTrain_Begin;
						break;
					case BeginType.ABLUP:
						sysStateCode = SystemStateCode.Ablup_Begin;
						break;
					case BeginType.TURNEND:
						sysStateCode = SystemStateCode.Turnend_Begin;
						break;
					case BeginType.FIRST:
						sysStateCode = SystemStateCode.First_Begin;
						break;
					case BeginType.TITLE:
						sysStateCode = SystemStateCode.Title_Begin;
						break;
					default:
						throw new ExeEE("sKBEGINĂяo");
				}
				functionList.Clear();
				begintype = BeginType.NULL;
				return;
			}

			public void AddFunction(CalledFunction call)
			{
				functionList.Add(call);
				sequential = false;
				nextLine = call.NextLine;
				return;
			}
			public string Scope
			{
				get
				{
					if (functionList.Count == 0)
					{
						throw new ExeEE("s̊֐݂܂");
					}
					return functionList[functionList.Count - 1].FunctionName;
				}
			}

			public void Return(Int64 ret)
			{
				sequential = false;//ɂ돇ł͂ȂB
				if (functionList.Count == 0)
				{
					throw new ExeEE("s̊֐݂܂");
				}
				CalledFunction called = functionList[functionList.Count - 1];
				//#SingletOt֐1ԂꂽB
				if ((called.HasSingleFlag) && (ret != 0))
				{
					called.Finish();
				}
				called.ShiftNext();
				nextLine = called.NextLine;
				//֐I
				if (nextLine == null)
				{
					nextLine = called.ReturnAddress;
					if (called.ReturnAddress == null)
					{
						functionList.Clear();//SďIBstateEndProcessɏԂ
						if (begintype != BeginType.NULL)//BEGIN XXsȂĂ
						{
							Begin();
						}
						return;
					}
					functionList.Remove(called);
					return;
				}
				return;
			}

			public ProcessState Clone()
			{
				ProcessState ret = new ProcessState();

				foreach (CalledFunction func in functionList)
					ret.functionList.Add(func.Clone());
				ret.currentLine = this.currentLine;
				ret.nextLine = this.nextLine;
				ret.sequential = this.sequential;
				ret.sysStateCode = this.sysStateCode;
				ret.begintype = this.begintype;
				return ret;

			}
		}

		/// <summary>
		/// ݌Ăяo̊֐
		/// </summary>
		private class CalledFunction
		{
			private CalledFunction(string label) { FunctionName = label; }
			public static CalledFunction CallFunction(Process parent, string label, LogicalLine retAddress, bool isEvent)
			{
				CalledFunction called = new CalledFunction(label);
				List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
				if (isEvent)
				{
					newLabelList.AddRange(parent.labelDic.GetLabels(label));
					newLabelList.Sort();
				}
				else
				{
					FunctionLabelLine labelline = parent.labelDic.GetLabel(label);
                    if (labelline != null)
                    {
                        newLabelList.Add(labelline);
                    }
				}
				called.labelList = newLabelList;
				called.returnAddress = retAddress;
				return called;

			}
			public LogicalLine CallLabel(Process parent, string label)
			{
				return parent.labelDic.GetLabelDollar(label, this.NextLine);
			}

			public CalledFunction Clone()
			{
				CalledFunction called = new CalledFunction(this.FunctionName);
				List<FunctionLabelLine> newLabelList = new List<FunctionLabelLine>();
				newLabelList.AddRange(this.labelList);
				newLabelList.Sort();
				called.labelList = newLabelList;
				called.counter = this.counter;
				called.returnAddress = this.returnAddress;
				return called;
			}

			List<FunctionLabelLine> labelList;
			int counter = 0;
			LogicalLine returnAddress;
			public readonly string FunctionName = "";
            public List<FunctionLabelLine> LabelList
            {
                get { return labelList; }
            }
			public LogicalLine ReturnAddress
			{
				get { return returnAddress; }
			}
			public bool HasSingleFlag
			{
				get
				{
					if (labelList.Count <= counter)
						return false;
					return labelList[counter].IsSingle;
				}
			}
			public FunctionLabelLine NextLine
			{
				get
				{
					if (labelList.Count <= counter)
						return null;
					return labelList[counter];
				}
			}

			public void ShiftNext()
			{
				counter++;
			}
			public void Finish()
			{ counter = labelList.Count; }

			public int Count { get { return labelList.Count; } }
		}

	}
}