using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.GameData.Expression;
using MinorShift.Emuera.GameData.Variable;
using MinorShift.Emuera.Sub;
using MinorShift._Library;

namespace MinorShift.Emuera.GameData
{
	internal sealed class StringForm
	{
		public StringForm(string row)
		{
			rowString = row;
		}

		string rowString;
		public string RowString { get { return rowString; } }
		string formString;
		List<IOperandTerm> argList = new List<IOperandTerm>();
		List<bool> isTernary = new List<bool>();

		public bool Reduced
		{
			get
			{
				return formString != null;
			}
		}

		private VariableToken getVariable(VariableCode code, VariableCode subCode)
		{
			VariableIdentifier subId = VariableIdentifier.GetVariableId(subCode);
			VariableToken subToken = new VariableToken(subId, new SingleTerm(0), null);
			VariableIdentifier id = VariableIdentifier.GetVariableId(VariableCode.NAME);
			VariableToken token = new VariableToken(id, subToken, null);
			return token;
		}

		public void Reduce()
		{
			Reduce(new StringStream(rowString), '\0');
		}
		public void Reduce(StringStream st, char endKey)
		{
			int start = st.CurrentPosition;
			if (this.Reduced)
				return;
			StringBuilder buffer = new StringBuilder();
			int countArg = 0;
			while (!st.EOS && (st.Current != endKey))
			{
				if (st.Current == '%')
				{
					st.ShiftNext();
					string[] str = new string[3];
					int count = 0;

					count = ParseInner(str, st, '%');
					StringStream st1 = new StringStream(str[0]);
					argList.Add(ExpressionParser.ReduceStringTerm(st1));
					isTernary.Add(false);
					st.ShiftNext();
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					if (count > 0)
					{
						buffer.Append(",");
						//int align = Convert.ToInt32(str[1]);
						int align = 0;
						if (!int.TryParse(str[1], out align))
							throw new CodeEE("2̎w݂͐̂ł");
						if (count == 2)
						{
							if (str[2].Trim().ToUpper() == "LEFT")
								align *= -1;
							else if (str[2].Trim().ToUpper() != "RIGHT")
								throw new CodeEE("3̎wLEFTRIGHT݂̂ł");
						}
						buffer.Append(align.ToString());
					}
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.Current == '{')
				{
					st.ShiftNext();
					string[] str = new string[3];
					int count = 0;

					count = ParseInner(str, st, '}');
					StringStream st1 = new StringStream(str[0]);
					argList.Add(ExpressionParser.ReduceIntegerTerm(st1));
					isTernary.Add(false);
					st.ShiftNext();
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					if (count > 0)
					{
						buffer.Append(",");
						//int align = Convert.ToInt32(str[1]);
						int align = 0;
						if (!int.TryParse(str[1], out align))
							throw new CodeEE("2̎w݂͐̂ł");
						if (count == 2)
						{
							if (str[2].Trim().ToUpper() == "LEFT")
								align *= -1;
							else if (str[2].Trim().ToUpper() != "RIGHT")
								throw new CodeEE("3̎wLEFTRIGHT݂̂ł");
						}
						buffer.Append(align.ToString());
					}
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.Current == '}')
				{
					throw new CodeEE("\'}\'g܂Ή\'{\'܂");
				}
				if (st.CurrentEqualTo("***"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.NAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("+++"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.MASTER);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("==="))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.PLAYER);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("///"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.ASSI);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				if (st.CurrentEqualTo("$$$"))
				{
					st.ShiftNext();
					st.ShiftNext();
					st.ShiftNext();
					VariableToken token = getVariable(VariableCode.CALLNAME, VariableCode.TARGET);
					argList.Add(token);
					isTernary.Add(false);
					buffer.Append("{");
					buffer.Append(countArg.ToString());
					buffer.Append("}");
					countArg++;
					continue;
				}
				//GXP[v̎gp
				if (st.Current == '\\')
				{
					st.ShiftNext();
					switch (st.Current)
					{
						case StringStream.EndOfString:
							throw new CodeEE("GXP[v\\̌ɕ܂");
						case '\n':
							break;
						case 's':
							buffer.Append(' ');
							break;
						case 'S':
							buffer.Append('@');
							break;
						case 't':
							buffer.Append('\t');
							break;
						case 'n':
							buffer.Append('\n');
							break;
						case '{':
							buffer.Append('{');
							buffer.Append('{');
							break;
						case '}':
							buffer.Append('}');
							buffer.Append('}');
							break;
						case '@':
							bool isEscape = false;
							st.ShiftNext();
							StringBuilder tBf = new StringBuilder();
							while (!(st.Current == '@' && isEscape) && !st.EOS && (st.Current != endKey))
							{
								if (st.Current == '\\' && !isEscape)
								{
									isEscape = true;
									st.ShiftNext();
									continue;
								}
								if (isEscape)
								{
									switch (st.Current)
									{
										case StringStream.EndOfString:
											throw new CodeEE("GXP[v\\̌ɕ܂");
										case '\n':
											break;
										case 's':
											tBf.Append(' ');
											break;
										case 'S':
											tBf.Append('@');
											break;
										case 't':
											tBf.Append('\t');
											break;
										case 'n':
											tBf.Append('\n');
											break;
										case '{':
											tBf.Append('{');
											tBf.Append('{');
											break;
										case '}':
											tBf.Append('}');
											tBf.Append('}');
											break;
										default:
											tBf.Append(st.Current);
											break;
									}
									isEscape = false;
									st.ShiftNext();
									continue;
								}
								tBf.Append(st.Current);
								st.ShiftNext();
							}
							if (!(isEscape && st.Current == '@'))
								throw new CodeEE("Ή\\@܂");
							argList.Add(ExpressionParser.ReduceTernaryStringTerm(new StringStream(tBf.ToString())));
							isTernary.Add(true);
							buffer.Append("{");
							buffer.Append(countArg.ToString());
							buffer.Append("}");
							countArg++;
							break;
						default:
							buffer.Append(st.Current);
							break;
					}
					st.ShiftNext();
					continue;
				}
				buffer.Append(st.Current);
				st.ShiftNext();
			}
			formString = buffer.ToString();
			if ((start != 0) || (!st.EOS))
				rowString = st.Substring(start, st.CurrentPosition - start);
		}

		private int ParseInner(string[] str, StringStream st, char endWrite)
		{
			int count = 0;
			StringBuilder tempBuf = new StringBuilder();
			while (st.Current != endWrite)
			{
				if (st.EOS)
					throw new CodeEE("\'" + endWrite.ToString() + "\'g܂Ή\'" + endWrite.ToString() + "\'܂");
				if (st.Current == ',')
				{
					str[count] = tempBuf.ToString();
					tempBuf = new StringBuilder();
					count++;
					if (count == 3)
						throw new CodeEE("\',\'̐܂");
					st.ShiftNext();
					continue;
				}
				tempBuf.Append(st.Current);
				st.ShiftNext();
			}
			str[count] = tempBuf.ToString();
			return count;
		}

		public string GetString(ExpressionEvaluator eEvaluator)
		{
			if (!this.Reduced)
				this.Reduce();
			string[] objArgList = new string[argList.Count];
			string tempFormString = formString;
			for (int i = 0; i < objArgList.Length; i++)
			{
				IOperandTerm term = argList[i];
				if (term.GetOperandType() == typeof(Int64))
					objArgList[i] = eEvaluator.GetInteger(term).ToString();
				else if (term.GetOperandType() == typeof(string))
				{
					if (isTernary[i])
					{
						StringForm tSf = new StringForm(eEvaluator.GetString(term));
						tSf.Reduce();
						objArgList[i] = tSf.GetString(eEvaluator);
					}
					else
						objArgList[i] = eEvaluator.GetString(term);
				}
				if (objArgList[i].Length != ShiftJisManager.GetStrlenShiftJis(objArgList[i]))
				{
					string sstr = String.Format("{{{0},", i);
					int index = formString.IndexOf(sstr);
					if (index >= 0)
					{
						index += sstr.Length;
						int shrink = ShiftJisManager.GetStrlenShiftJis(objArgList[i]) - objArgList[i].Length;
						int lastindex = formString.IndexOf('}', index);
						int BaseLength = Convert.ToInt32(formString.Substring(index, lastindex - index));
						int NewLength = (Math.Abs(BaseLength) - shrink);
						if (NewLength < 0)
							NewLength = 0;
						NewLength *= Math.Sign(BaseLength);
						tempFormString = formString.Replace(String.Format("{{{0},{1}}}", i.ToString(), BaseLength.ToString()), String.Format("{{{0},{1}}}", i.ToString(), NewLength.ToString()));
					}
				}
			}
			return string.Format(tempFormString, objArgList);
		}
		public string Format
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return formString;
			}
		}

		public List<IOperandTerm> ArgList
		{
			get
			{
				if (!this.Reduced)
					this.Reduce();
				return argList;
			}
		}

	}
}