// DelEmptyDir.cpp : R\[ AvP[ṼGg |Cg`܂B
//

#include "stdafx.h"

template<class T, class Container = std::list< std::basic_string<T> > >
class basic_recursive_search : public Container
{
public:

	basic_recursive_search()
	{
	}

	~basic_recursive_search()
	{
	}

	void search_empty_dir( const std::basic_string<T>& v_initDir )
	{
		std::basic_string<T> initDir( v_initDir );

		// \܂/ΏB
		int lastChr = 0;
		for( std::basic_string<T>::iterator ite = initDir.begin();
			ite != initDir.end();
			++ite )
		{
			lastChr = (unsigned int) *ite;
			if( _istleadbyte( lastChr ) ) {
				++ite;
				if( ite == initDir.end() ) {
					break;
				}
			}
		}
		if( lastChr == '\\' || lastChr == '/' ) {
			initDir.erase( initDir.end() - 1 );
		}

		search_empty_dir0( v_initDir );
	}

protected:

	int search_empty_dir0( const std::basic_string<T>& v_dirname )
	{
		const std::basic_string<T> search_name( v_dirname + _T("\\*.*") );
		int entry_count = 0;

		// tH_𑖍
		_tfinddata64_t finddata;
		intptr_t hFind = _tfindfirst64( search_name.c_str(), &finddata );
		if( hFind != -1 ) {
			do {
				if( finddata.attrib & _A_SUBDIR ) {
					const tstring subdir_name( finddata.name );
					if( subdir_name != _T("..") && subdir_name != _T(".") ) {
						entry_count += search_empty_dir0( v_dirname + _T("\\") + subdir_name );
					}
				}
				else {
					entry_count++;
				}
			} while( ! _tfindnext64( hFind, &finddata ) );
			_findclose( hFind );
		}

		// qtH_ċAIɃ`FbNʁAt@C1ȂΑΏۂƂB
		if( entry_count == 0 ) {
			push_back( v_dirname );
		}

		return entry_count;
	}

};

typedef basic_recursive_search<_TCHAR> recursive_search;
typedef std::basic_string<_TCHAR> tstring;

#ifdef _UNICODE
#define _tcout std::wcout
#else
#define _tcout std::cout
#endif

int _tmain(int argc, _TCHAR* argv[])
{
	if( argc <= 1 ) {
		_ftprintf( stdout,
			_T("[usage] %s tH_\nw肵tH_zɂ̃fBNg폜܂B\n")
			_T("̃fBNgȂfBNg͋Ƃ݂Ȃ܂B\n"), argv[ 0 ] );
		return 1;
	}

	tstring initDir = argv[ 1 ];

	recursive_search searcher;
	searcher.search_empty_dir( initDir );

	for( recursive_search::iterator ite = searcher.begin();
		ite != searcher.end();
		++ite )
	{
		const tstring& dirname = *ite;
		_tcout << dirname << " ";

		const int result = _trmdir( dirname.c_str() );

		_tcout << ( ( result == 0 ) ? _T("ok") : _T("failed") ) << std::endl;
	}

	return 0;
}

