/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.store.statistics;

import java.util.concurrent.atomic.AtomicLong;
import jp.objectfanatics.ofcache.store.statistics.ImmutableStoreStatistics;
import jp.objectfanatics.ofcache.store.statistics.StoreStatistics;

public class StoreStatisticsImpl
implements StoreStatistics {
    protected final AtomicLong hitCount = new AtomicLong();
    protected final AtomicLong missCount = new AtomicLong();
    protected final AtomicLong insertCount = new AtomicLong();
    protected final AtomicLong updateCount = new AtomicLong();
    protected final AtomicLong removeCount = new AtomicLong();
    protected final AtomicLong removeMissCount = new AtomicLong();
    protected final AtomicLong clearCount = new AtomicLong();

    public StoreStatisticsImpl() {
    }

    public StoreStatisticsImpl(long hitCount, long missCount, long insertCount, long updateCount, long removeCount, long removeMissCount, long clearCount) {
        this.hitCount.set(hitCount);
        this.missCount.set(missCount);
        this.insertCount.set(insertCount);
        this.updateCount.set(updateCount);
        this.removeCount.set(removeCount);
        this.removeMissCount.set(removeMissCount);
        this.clearCount.set(clearCount);
    }

    public long getHitCount() {
        return this.hitCount.get();
    }

    public long hit() {
        return this.hitCount.incrementAndGet();
    }

    public long getMissCount() {
        return this.missCount.get();
    }

    public long miss() {
        return this.missCount.incrementAndGet();
    }

    public long getInsertCount() {
        return this.insertCount.get();
    }

    public long insert() {
        return this.insertCount.incrementAndGet();
    }

    public long getUpdateCount() {
        return this.updateCount.get();
    }

    public long update() {
        return this.updateCount.incrementAndGet();
    }

    public long getRemoveCount() {
        return this.removeCount.get();
    }

    public long remove() {
        return this.removeCount.incrementAndGet();
    }

    public long getRemoveMissCount() {
        return this.removeMissCount.get();
    }

    public long removeMiss() {
        return this.removeMissCount.incrementAndGet();
    }

    public long getClearCount() {
        return this.clearCount.get();
    }

    public long clear() {
        return this.clearCount.incrementAndGet();
    }

    public ImmutableStoreStatistics getSnapshot() {
        return new ImmutableStoreStatistics(this.hitCount.get(), this.missCount.get(), this.insertCount.get(), this.updateCount.get(), this.removeCount.get(), this.removeMissCount.get(), this.clearCount.get());
    }
}

