/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.store;

import java.util.Map;
import jp.objectfanatics.commons.lang.AssertionUtil;
import jp.objectfanatics.ofcache.store.Entry;
import jp.objectfanatics.ofcache.store.Store;

public class MapStore<K, V>
implements Store<K, V> {
    private final Map<K, Entry<K, V>> map;

    public MapStore(Map<K, Entry<K, V>> map) {
        AssertionUtil.assertNotNull(map, (String)"map");
        this.map = map;
    }

    public Entry<K, V> get(K key) {
        AssertionUtil.assertNotNull(key, (String)"key");
        return this.map.get(key);
    }

    public Entry<K, V> put(Entry<K, V> entry) {
        AssertionUtil.assertNotNull(entry, (String)"entry");
        AssertionUtil.assertNotNull((Object)entry.getKey(), (String)"entry.getKey()");
        AssertionUtil.assertNotNull((Object)entry.getValue(), (String)"entry.getValue()");
        return this.map.put(entry.getKey(), entry);
    }

    public Entry<K, V> remove(K key) {
        AssertionUtil.assertNotNull(key, (String)"key");
        return this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }
}

