/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.objectfanatics.commons.lang.AssertionUtil;
import jp.objectfanatics.ofcache.store.Entry;
import jp.objectfanatics.ofcache.store.Listenable;
import jp.objectfanatics.ofcache.store.Store;
import jp.objectfanatics.ofcache.store.StoreListener;

public class ListenableStore<K, V>
implements Store<K, V>,
Listenable<K, V> {
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected final Store<K, V> store;
    protected final List<StoreListener<K, V>> storeListeners = new ArrayList<StoreListener<K, V>>();

    public ListenableStore(Store<K, V> store) {
        AssertionUtil.assertNotNull(store, (String)"store");
        this.store = store;
    }

    public void addStoreListener(StoreListener<K, V> storeListener) {
        AssertionUtil.assertNotNull(storeListener, (String)"storeListener");
        this.lock.writeLock().lock();
        this.storeListeners.add(storeListener);
        this.lock.writeLock().unlock();
    }

    public List<StoreListener<K, V>> getStoreListeners() {
        return Collections.unmodifiableList(this.storeListeners);
    }

    public void removeStoreListener(StoreListener<K, V> storeListener) {
        AssertionUtil.assertNotNull(storeListener, (String)"storeListener");
        this.lock.writeLock().lock();
        this.storeListeners.remove(storeListener);
        this.lock.writeLock().unlock();
    }

    public void clear() {
        this.store.clear();
        this.fireNotifyClear();
    }

    public Entry<K, V> get(K key) {
        Entry entry = this.store.get(key);
        this.fireNotifyGet(key, entry);
        return entry;
    }

    public Entry<K, V> put(Entry<K, V> entry) {
        Entry prevValue = this.store.put(entry);
        this.fireNotifyPut(entry.getKey(), entry, prevValue);
        return prevValue;
    }

    public int size() {
        return this.store.size();
    }

    public Entry<K, V> remove(K key) {
        Entry entry = this.store.remove(key);
        this.fireNotifyRemove(key, entry);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifyGet(K key, Entry<K, V> entry) {
        try {
            this.lock.readLock().lock();
            for (StoreListener<K, V> storeListener : this.storeListeners) {
                storeListener.notifyGet(key, entry);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifyPut(K key, Entry<K, V> newEntry, Entry<K, V> prevEntry) {
        try {
            this.lock.readLock().lock();
            for (StoreListener<K, V> storeListener : this.storeListeners) {
                storeListener.notifyPut(key, newEntry, prevEntry);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifyRemove(K key, Entry<K, V> removedEntry) {
        try {
            this.lock.readLock().lock();
            for (StoreListener<K, V> storeListener : this.storeListeners) {
                storeListener.notifyRemove(key, removedEntry);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNotifyClear() {
        try {
            this.lock.readLock().lock();
            for (StoreListener<K, V> storeListener : this.storeListeners) {
                storeListener.notifyClear();
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

