/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.hibernate;

import java.util.ArrayList;
import java.util.List;
import jp.objectfanatics.commons.lang.AssertionUtil;
import jp.objectfanatics.ofcache.hibernate.OfCacheProvider;
import jp.objectfanatics.ofcache.hibernate.OfCacheProviderManager;

public class OfCacheProviderManagerImpl
implements OfCacheProviderManager {
    private final List<OfCacheProvider> managedOfCacheProviders = new ArrayList<OfCacheProvider>();

    @Override
    public synchronized void addOfCacheProvider(OfCacheProvider ofCacheProvider) {
        AssertionUtil.assertNotNull((Object)ofCacheProvider, (String)"ofCacheProvider");
        if (this.managedOfCacheProviders.contains(ofCacheProvider)) {
            throw new IllegalArgumentException("Specified instance is already managed.");
        }
        this.managedOfCacheProviders.add(ofCacheProvider);
    }

    @Override
    public synchronized void removeOfCacheProvider(OfCacheProvider ofCacheProvider) {
        AssertionUtil.assertNotNull((Object)ofCacheProvider, (String)"ofCacheProvider");
        if (!this.managedOfCacheProviders.contains(ofCacheProvider)) {
            throw new IllegalArgumentException("Specified instance is not managed.");
        }
        this.managedOfCacheProviders.remove(ofCacheProvider);
    }

    @Override
    public synchronized List<OfCacheProvider> getActiveOfCacheProviders() {
        ArrayList<OfCacheProvider> activeProviders = new ArrayList<OfCacheProvider>();
        for (OfCacheProvider provider : this.managedOfCacheProviders) {
            if (!provider.isActive()) continue;
            activeProviders.add(provider);
        }
        return activeProviders;
    }

    @Override
    public synchronized List<OfCacheProvider> getOfCacheProviders() {
        ArrayList<OfCacheProvider> providers = new ArrayList<OfCacheProvider>();
        providers.addAll(this.managedOfCacheProviders);
        return providers;
    }
}

