/*
 * Decompiled with CFR 0.152.
 */
package jp.objectfanatics.ofcache.hibernate;

import java.util.Map;
import jp.objectfanatics.commons.lang.AssertionUtil;
import jp.objectfanatics.ofcache.hibernate.OfCache;
import jp.objectfanatics.ofcache.hibernate.OfCacheStatistics;
import jp.objectfanatics.ofcache.store.Entry;
import jp.objectfanatics.ofcache.store.MutableEntryImpl;
import jp.objectfanatics.ofcache.store.Store;
import jp.objectfanatics.ofcache.store.statistics.StoreStatisticsEnabled;
import org.hibernate.cache.Timestamper;

public class OfCacheBase
implements OfCache {
    private static final int DEFAULT_TIMEOUT = 245760000;
    private final Store<Object, Object> store;
    private final StoreStatisticsEnabled storeStatisticsEnabled;
    private final String regionName;

    public OfCacheBase(Store<Object, Object> store, String regionName) {
        this(store, (StoreStatisticsEnabled)store, regionName);
    }

    public OfCacheBase(Store<Object, Object> store, StoreStatisticsEnabled storeStatisticsEnabled, String regionName) {
        AssertionUtil.assertNotNull(store, (String)"store");
        AssertionUtil.assertNotNull((Object)storeStatisticsEnabled, (String)"storeStatisticsEnabled");
        AssertionUtil.assertNotNull((Object)regionName, (String)"regionName");
        this.store = store;
        this.storeStatisticsEnabled = storeStatisticsEnabled;
        this.regionName = regionName;
    }

    public Store<Object, Object> getStore() {
        return this.store;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void clear() {
        this.store.clear();
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getElementCountInMemory() {
        return this.store.size();
    }

    public void remove(Object key) {
        this.store.remove(key);
    }

    public void put(Object key, Object value) {
        MutableEntryImpl entry = new MutableEntryImpl(key, value);
        this.store.put((Entry)entry);
    }

    public void lock(Object key) {
    }

    public Map<Object, Object> toMap() {
        throw new UnsupportedOperationException();
    }

    public Object read(Object key) {
        return this.get(key);
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public void unlock(Object key) {
    }

    public void destroy() {
    }

    public Object get(Object key) {
        Entry entry = this.store.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.getValue();
        return value;
    }

    public void update(Object key, Object value) {
        this.put(key, value);
    }

    public int getTimeout() {
        return 245760000;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    @Override
    public OfCacheStatistics getOfCacheStatistics() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

