/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE WAVCONFILTER SOURCE CODE.               *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE WAVCONFILTER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha         *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#ifndef __WavConFilter_h__
#define __WavConFilter_h__

// -----------------------------------------------------------------------------------------------------------------------------------
class CWavConFilter : public CTransformFilter
{
   friend class CSamplingConv;
   friend class CChannelConv;
   friend class CBitConv;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CWavConFilter(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CWavConFilter();

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT EndOfStream(void);

   // IWavConInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);

protected:

private:

   // [U֐
   void ConvertToDouble(BYTE *, int);

   // [Uϐ
   bool m_bSetOutFormat;
   int m_nAccurate;
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   CBitConv *m_pBitConv;
   CCritSec m_myLock;
   CChannelConv *m_pChannelConv;
   CSamplingConv *m_pSamplingConv;
   int m_nSmplSize;
   struct SmplData *m_smpld;
};

#endif __WavConFilter_h__
