/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.wizard;

import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SameDbNameException;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.views.TreeContentProvider;
import zigen.plugin.db.ui.wizard.ImpWizardPage1;
import zigen.plugin.db.ui.wizard.TableItem;

public class ImpDBConfigWizard
extends Wizard {
    private ImpWizardPage1 page1;
    private TreeViewer viewer;
    private IDBConfig[] configs;

    public ImpDBConfigWizard(TreeViewer viewer, IDBConfig[] configs) {
        this.viewer = viewer;
        this.configs = configs;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page1 = new ImpWizardPage1(this.configs);
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        try {
            TableItem[] tableItems = this.page1.tableItems;
            int i = 0;
            while (i < tableItems.length) {
                TableItem item = tableItems[i];
                if (item.isChecked()) {
                    this.saveDBConfig(item.getConfig());
                }
                ++i;
            }
            DbPlugin.getDefault().saveDBDialogSettings();
            return true;
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
            return false;
        }
    }

    public boolean canFinish() {
        return this.page1.isPageComplete();
    }

    private void saveDBConfig(IDBConfig config) {
        try {
            DBConfigManager.save(config);
            IContentProvider obj = this.viewer.getContentProvider();
            if (obj instanceof TreeContentProvider) {
                TreeContentProvider provider = (TreeContentProvider)obj;
                DataBase registDb = provider.addDataBase(config);
                this.viewer.expandToLevel((Object)provider.getRoot(), 1);
                this.viewer.refresh();
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)registDb), true);
            }
        }
        catch (SameDbNameException sameDbNameException) {
            config.setDbName(String.valueOf(config.getDbName()) + "\u306e\u30b3\u30d4\u30fc");
            this.saveDBConfig(config);
        }
    }
}

