/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.wizard;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import zigen.plugin.db.ui.wizard.IItem;
import zigen.plugin.db.ui.wizard.Messages;
import zigen.plugin.db.ui.wizard.TableItem;

abstract class DefaultWizardPage
extends WizardPage {
    protected int LEVEL_FIELD_WIDTH = 20;
    protected int TEXT_FIELD_WIDTH = 50;
    protected int HEIGHT_HINT = 150;
    protected int WIDTH_HINT = 450;
    public static final String CHECKED_IMAGE = "checked";
    public static final String UNCHECKED_IMAGE = "unchecked";
    protected static ImageRegistry imageRegistry = new ImageRegistry();
    protected TableItem[] tableItems = null;
    protected TableViewer tableViewer = null;
    static /* synthetic */ Class class$0;

    static {
        String iconPath = "";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("zigen.plugin.db.ui.wizard.ImpWizardPage1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(CHECKED_IMAGE, ImageDescriptor.createFromFile(clazz, (String)(String.valueOf(iconPath) + CHECKED_IMAGE + ".gif")));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("zigen.plugin.db.ui.wizard.ImpWizardPage1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(UNCHECKED_IMAGE, ImageDescriptor.createFromFile(clazz2, (String)(String.valueOf(iconPath) + UNCHECKED_IMAGE + ".gif")));
    }

    public DefaultWizardPage(String pageName) {
        super(pageName);
    }

    public abstract void createControl(Composite var1);

    protected void setHeaderColumn(Table table, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            TableColumn col = new TableColumn(table, 0, i);
            col.setText(headers[i]);
            col.setResizable(true);
            col.pack();
            ++i;
        }
    }

    protected void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
        table.setVisible(true);
    }

    void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    protected void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    protected Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected GridData getGridData(int width) {
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(width);
        return gd;
    }

    protected final boolean isSelected() {
        int i = 0;
        while (i < this.tableItems.length) {
            TableItem item = this.tableItems[i];
            if (item.isChecked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void createSelectBtn(Composite composite) {
        Composite c = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        c.setLayout((Layout)layout);
        Button selectBtn = new Button(c, 8);
        selectBtn.setText(Messages.getString("ExpWizardPage1.8"));
        selectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (DefaultWizardPage.this.tableItems != null) {
                    int i = 0;
                    while (i < DefaultWizardPage.this.tableItems.length) {
                        DefaultWizardPage.this.tableItems[i].setChecked(true);
                        ++i;
                    }
                    DefaultWizardPage.this.tableViewer.update((Object[])DefaultWizardPage.this.tableItems, new String[]{"check"});
                    DefaultWizardPage.this.setPageComplete(true);
                }
            }
        });
        Button unSelectBtn = new Button(c, 8);
        unSelectBtn.setText(Messages.getString("ExpWizardPage1.10"));
        unSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (DefaultWizardPage.this.tableItems != null) {
                    int i = 0;
                    while (i < DefaultWizardPage.this.tableItems.length) {
                        DefaultWizardPage.this.tableItems[i].setChecked(false);
                        ++i;
                    }
                    DefaultWizardPage.this.tableViewer.update((Object[])DefaultWizardPage.this.tableItems, new String[]{"check"});
                    DefaultWizardPage.this.setPageComplete(false);
                }
            }
        });
    }

    protected class TableContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        protected TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IItem[]) {
                return (TableItem[])inputElement;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = null;
        }

        public void dispose() {
            this.contents = null;
        }
    }

    protected class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        private Image getImage(boolean isSelected) {
            String key = isSelected ? DefaultWizardPage.CHECKED_IMAGE : DefaultWizardPage.UNCHECKED_IMAGE;
            return imageRegistry.get(key);
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            TableItem item = (TableItem)element;
            switch (columnIndex) {
                case 0: {
                    result = item.getDbName();
                    break;
                }
                case 1: {
                    result = item.getUrl();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return columnIndex == 0 ? this.getImage(((TableItem)element).isChecked()) : null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

