/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.ui.IEditorPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.actions.LockDataBaseAction;
import zigen.plugin.db.ui.actions.OpenSQLAction;
import zigen.plugin.db.ui.actions.SaveSQLAction;
import zigen.plugin.db.ui.actions.ShowHistoryViewAction;
import zigen.plugin.db.ui.editors.sql.PlsqlEditor;
import zigen.plugin.db.ui.editors.sql.SqlEditor;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.FormatModeAction;
import zigen.plugin.db.ui.views.internal.Messages;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class CopyOfSQLToolBar {
    protected PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    protected SQLHistoryManager historyManager = DbPlugin.getDefault().getHistoryManager();
    protected IDBConfig[] configs;
    protected SQLSourceViewer fSourceViewer;
    protected CoolBar coolBar;
    protected Combo selectCombo;
    protected ComboContributionItem comboContributionItem = new ComboContributionItem("SelectDataBase");
    protected GlobalAction allExecAction = new GlobalAction(null, 1003);
    protected GlobalAction currExecAction = new GlobalAction(null, 1004);
    protected GlobalAction selectExecAction = new GlobalAction(null, 1005);
    protected GlobalAction scriptExecAction = new GlobalAction(null, 1013);
    protected GlobalAction allClearAction = new GlobalAction(null, 1012);
    protected GlobalAction nextSqlAction = new GlobalAction(null, 1006);
    protected GlobalAction backSqlAction = new GlobalAction(null, 1007);
    protected GlobalAction formatSqlAction = new GlobalAction(null, 1001);
    protected GlobalAction commitAction = new GlobalAction(null, 1010);
    protected GlobalAction rollbackAction = new GlobalAction(null, 1011);
    protected OpenSQLAction openAction = new OpenSQLAction(null);
    protected SaveSQLAction saveAction = new SaveSQLAction(null);
    protected CommitModeAction commitModeAction = new CommitModeAction(null);
    protected FormatModeAction formatModeAction = new FormatModeAction(null);
    protected ShowHistoryViewAction showHistoryViewAction = new ShowHistoryViewAction();
    protected LockDataBaseAction lockDataBaseAction = new LockDataBaseAction(null);
    IEditorPart fEditor;
    String lastSelectedDB;
    boolean lastAutoFormatMode;
    public static int TYPE_SQL_EXECUTE_VIEW = 0;
    public static int TYPE_SQL_EDITOR = 1;
    public static int TYPE_PLSQL_EDITOR = 2;
    private int type = TYPE_SQL_EXECUTE_VIEW;

    public CopyOfSQLToolBar(final Composite parent, IEditorPart editor) {
        this.fEditor = editor;
        if (editor instanceof PlsqlEditor) {
            this.type = TYPE_PLSQL_EDITOR;
        } else if (editor instanceof SqlEditor) {
            this.type = TYPE_SQL_EDITOR;
        }
        this.coolBar = new CoolBar(parent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.coolBar.setLayoutData((Object)data);
        CoolBarManager coolBarMgr = new CoolBarManager(this.coolBar);
        ToolBarManager toolBarMgr1 = new ToolBarManager(0x800000);
        if (this.type == TYPE_SQL_EDITOR || this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr1.add((IAction)this.allExecAction);
        }
        if (this.type == TYPE_PLSQL_EDITOR || this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr1.add((IAction)this.scriptExecAction);
        }
        toolBarMgr1.add((IAction)this.allClearAction);
        ToolBarManager toolBarMgr2 = new ToolBarManager(0x800000);
        if (this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr2.add((IAction)this.backSqlAction);
            toolBarMgr2.add((IAction)this.nextSqlAction);
        }
        ToolBarManager toolBarMgr3 = new ToolBarManager(0x800000);
        if (this.type == TYPE_SQL_EDITOR || this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr3.add((IAction)this.commitModeAction);
            toolBarMgr3.add((IAction)this.commitAction);
            toolBarMgr3.add((IAction)this.rollbackAction);
        }
        ToolBarManager toolBarMgr4 = new ToolBarManager(0x800000);
        if (this.type == TYPE_SQL_EDITOR || this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr4.add((IAction)this.formatModeAction);
        }
        ToolBarManager toolBarMgr6 = new ToolBarManager(0x800000);
        if (this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr6.add((IAction)this.openAction);
            toolBarMgr6.add((IAction)this.saveAction);
        } else {
            toolBarMgr6.add((IAction)new SaveAction());
        }
        ToolBarManager toolBarMgr5 = new ToolBarManager(0x800000);
        toolBarMgr5.add((IContributionItem)this.comboContributionItem);
        if (this.type == TYPE_SQL_EXECUTE_VIEW) {
            toolBarMgr5.add((IAction)this.lockDataBaseAction);
        }
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr6));
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr1));
        if (this.type == TYPE_SQL_EXECUTE_VIEW) {
            coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr2));
        }
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr3));
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr4));
        coolBarMgr.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolBarMgr5));
        coolBarMgr.update(true);
        this.coolBar.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                parent.getParent().layout(true);
                parent.layout(true);
            }
        });
    }

    public CopyOfSQLToolBar(Composite parent) {
        this(parent, null);
    }

    public void setSQLSourceViewer(SQLSourceViewer sqlSourceViewer) {
        this.fSourceViewer = sqlSourceViewer;
        this.openAction.setSQLSourceViewer(sqlSourceViewer);
        this.saveAction.setSQLSourceViewer(sqlSourceViewer);
        this.nextSqlAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.backSqlAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.allExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.currExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.selectExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.scriptExecAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.allClearAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.formatModeAction.setSQLSourceViewer(sqlSourceViewer);
        this.commitModeAction.setSQLSourceViewer(sqlSourceViewer);
        this.commitAction.setTextViewer((TextViewer)sqlSourceViewer);
        this.rollbackAction.setTextViewer((TextViewer)sqlSourceViewer);
    }

    public final void updateHistoryButton() {
        if (this.historyManager.hasPrevHistory()) {
            if (this.backSqlAction != null) {
                this.backSqlAction.setEnabled(true);
            }
        } else if (this.backSqlAction != null) {
            this.backSqlAction.setEnabled(false);
        }
        if (this.historyManager.hasNextHistory()) {
            if (this.nextSqlAction != null) {
                this.nextSqlAction.setEnabled(true);
            }
        } else if (this.nextSqlAction != null) {
            this.nextSqlAction.setEnabled(false);
        }
    }

    public void updateCombo(IDBConfig config) {
        if (!this.lockDataBaseAction.isChecked()) {
            this.comboContributionItem.updateCombo(config);
        }
    }

    public void initializeSelectCombo() {
        this.comboContributionItem.initializeSelectCombo();
    }

    public void setCommitMode(IDBConfig targetConfig, boolean autoCommit) {
        this.comboContributionItem.setCommitMode(targetConfig, autoCommit);
    }

    public ComboContributionItem getComboContributionItem() {
        return this.comboContributionItem;
    }

    public IDBConfig getConfig() {
        return this.comboContributionItem.selectedConfig();
    }

    public IDBConfig[] getConfigs() {
        return this.configs;
    }

    public CoolBar getCoolBar() {
        return this.coolBar;
    }

    public SQLSourceViewer getFSourceViewer() {
        return this.fSourceViewer;
    }

    public Combo getSelectCombo() {
        return this.selectCombo;
    }

    public boolean isLockedDataBase() {
        return this.lockDataBaseAction.isChecked();
    }

    public void setLockedDataBase(boolean isLocked) {
        this.lockDataBaseAction.setChecked(isLocked);
    }

    class ComboContributionItem
    extends ControlContribution {
        public ComboContributionItem(String id) {
            super(id);
        }

        protected Control createControl(Composite parent) {
            CopyOfSQLToolBar.this.selectCombo = new Combo(parent, 8);
            GridData data = new GridData(768);
            data.widthHint = 200;
            CopyOfSQLToolBar.this.selectCombo.setLayoutData((Object)data);
            if (CopyOfSQLToolBar.this.type == TYPE_SQL_EXECUTE_VIEW) {
                CopyOfSQLToolBar.this.lastSelectedDB = this.getLastSelectedDBName();
            }
            this.initializeSelectCombo();
            CopyOfSQLToolBar.this.selectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ ComboContributionItem this$1;
                {
                    this.this$1 = comboContributionItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    IDBConfig config = ComboContributionItem.access$1(this.this$1).getConfig();
                    if (ComboContributionItem.access$1((ComboContributionItem)this.this$1).fSourceViewer != null) {
                        this.this$1.updateCombo(config);
                    }
                    if (ComboContributionItem.access$1((ComboContributionItem)this.this$1).fEditor == null) {
                        ComboContributionItem.access$1((ComboContributionItem)this.this$1).lastSelectedDB = config.getDbName();
                        this.this$1.setLastSelectedDBName(ComboContributionItem.access$1((ComboContributionItem)this.this$1).lastSelectedDB);
                    }
                    DbPlugin.fireStatusChangeListener(config, 106);
                }
            });
            return CopyOfSQLToolBar.this.selectCombo;
        }

        String getLastSelectedDBName() {
            Object obj = CopyOfSQLToolBar.this.pluginMgr.getValue("KEY_DEFAULT_DB");
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }

        void setLastSelectedDBName(String dbName) {
            CopyOfSQLToolBar.this.pluginMgr.setValue("KEY_DEFAULT_DB", dbName);
        }

        void initializeSelectCombo() {
            IDBConfig config = CopyOfSQLToolBar.this.getConfig();
            CopyOfSQLToolBar.this.selectCombo.removeAll();
            CopyOfSQLToolBar.this.configs = DBConfigManager.getDBConfigs();
            int i = 0;
            while (i < CopyOfSQLToolBar.this.configs.length) {
                IDBConfig w_config = CopyOfSQLToolBar.this.configs[i];
                CopyOfSQLToolBar.this.selectCombo.add(String.valueOf(w_config.getSchema()) + " : " + w_config.getDbName() + "  ");
                if (CopyOfSQLToolBar.this.lastSelectedDB != null && CopyOfSQLToolBar.this.lastSelectedDB.equals(w_config.getDbName())) {
                    CopyOfSQLToolBar.this.selectCombo.select(i);
                }
                if (config != null && config.getDbName().equals(w_config.getDbName())) {
                    CopyOfSQLToolBar.this.selectCombo.select(i);
                }
                ++i;
            }
        }

        void updateCombo(IDBConfig newConfig) {
            if (newConfig != null) {
                int i = 0;
                while (i < CopyOfSQLToolBar.this.configs.length) {
                    IDBConfig w_config = CopyOfSQLToolBar.this.configs[i];
                    if (newConfig != null && newConfig.getDbName().equals(w_config.getDbName())) {
                        CopyOfSQLToolBar.this.selectCombo.select(i);
                    }
                    ++i;
                }
                if (CopyOfSQLToolBar.this.fSourceViewer != null) {
                    CopyOfSQLToolBar.this.fSourceViewer.setDbConfig(newConfig);
                    CopyOfSQLToolBar.this.commitModeAction.setSQLSourceViewer(CopyOfSQLToolBar.this.fSourceViewer);
                    CopyOfSQLToolBar.this.comboContributionItem.setCommitMode(newConfig, newConfig.isAutoCommit());
                }
            } else {
                CopyOfSQLToolBar.this.selectCombo.select(-1);
            }
        }

        private void setCommitMode(IDBConfig targetConfig, boolean isAutoCommit) {
            IDBConfig config = CopyOfSQLToolBar.this.getConfig();
            if (config == null || config.getDbName().equals(targetConfig.getDbName())) {
                CopyOfSQLToolBar.this.commitAction.setEnabled(!isAutoCommit);
                CopyOfSQLToolBar.this.rollbackAction.setEnabled(!isAutoCommit);
                CopyOfSQLToolBar.this.commitModeAction.setCommitMode(isAutoCommit);
            }
        }

        public IDBConfig selectedConfig() {
            int index = CopyOfSQLToolBar.this.selectCombo.getSelectionIndex();
            if (index >= 0) {
                return CopyOfSQLToolBar.this.configs[index];
            }
            return null;
        }

        static /* synthetic */ CopyOfSQLToolBar access$1(ComboContributionItem comboContributionItem) {
            return comboContributionItem.CopyOfSQLToolBar.this;
        }
    }

    private class SaveAction
    extends Action {
        public SaveAction() {
            this.setToolTipText(Messages.getString("SQLToolBar.3"));
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("save.gif"));
        }

        public void run() {
            CopyOfSQLToolBar.this.fEditor.doSave(null);
        }
    }
}

