/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.FolderInfo;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.csv.CreateCSVAction;
import zigen.plugin.db.diff.DDLDiffForFolderAction;
import zigen.plugin.db.diff.DDLDiffForSchemaAction;
import zigen.plugin.db.diff.DDLDiffForSourceAction;
import zigen.plugin.db.diff.DDLDiffForTableAction;
import zigen.plugin.db.ext.oracle.internal.OpenSourceEdirotAction;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpaceWizardAction;
import zigen.plugin.db.ui.actions.CloseDBAction;
import zigen.plugin.db.ui.actions.ConnectDBAction;
import zigen.plugin.db.ui.actions.CopyColumnNameAction;
import zigen.plugin.db.ui.actions.CopyDBAction;
import zigen.plugin.db.ui.actions.CopySchemaNameAction;
import zigen.plugin.db.ui.actions.CopyTableNameAction;
import zigen.plugin.db.ui.actions.CopyTableNameWithRemarksAction;
import zigen.plugin.db.ui.actions.DeleteFromTableAction;
import zigen.plugin.db.ui.actions.DropTreeNodeAction;
import zigen.plugin.db.ui.actions.EditDBAction;
import zigen.plugin.db.ui.actions.ExportDBConfigAction;
import zigen.plugin.db.ui.actions.ImportDBConfigAction;
import zigen.plugin.db.ui.actions.LoadColumnAction;
import zigen.plugin.db.ui.actions.OpenEditorAction;
import zigen.plugin.db.ui.actions.PurgeRecyclebinAction;
import zigen.plugin.db.ui.actions.RefreshAction;
import zigen.plugin.db.ui.actions.RegistBookmarkAction;
import zigen.plugin.db.ui.actions.RegistBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RegistDBAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkAction;
import zigen.plugin.db.ui.actions.RemoveBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RemoveDBAction;
import zigen.plugin.db.ui.actions.RenameBookmarkFolderAction;
import zigen.plugin.db.ui.actions.RenameTableAction;
import zigen.plugin.db.ui.actions.ShowDriverVersionAction;
import zigen.plugin.db.ui.actions.ShowPluginVersionAction;
import zigen.plugin.db.ui.actions.ToggleLinkingAction;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkFolder;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.OracleSource;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.internal.View;
import zigen.plugin.db.ui.jobs.RefreshTableJob;
import zigen.plugin.db.ui.views.AbstractTreeView;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.Messages;
import zigen.plugin.db.ui.views.internal.ColumnFilter;
import zigen.plugin.db.ui.views.internal.ElementFilter;
import zigen.plugin.db.ui.views.internal.ElementFilterDialog;
import zigen.plugin.db.ui.views.internal.FolderFilter;

public class TreeView
extends AbstractTreeView {
    PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    public static Object lock = new Object();
    private RegistDBAction registDBAction;
    private RemoveDBAction removeDBAction;
    private EditDBAction editDBAction;
    private ConnectDBAction connectDBAction;
    private CloseDBAction closeDBAction;
    private RefreshAction refreshAction;
    private OpenEditorAction openEditorAction;
    private RenameTableAction renameTableAction;
    private CreateCSVAction createCSVAction;
    private CalcTableSpaceWizardAction calcTableSpaceWizardAction;
    private CopyDBAction copyDBAction;
    private ShowDriverVersionAction showDriverVersionAction;
    private ShowPluginVersionAction showPluginVersionAction;
    private RegistBookmarkFolderAction registBookmarkFolderAction;
    private RenameBookmarkFolderAction renameBookmarkFolderAction;
    private RemoveBookmarkFolderAction removeBookmarkFolderAction;
    private RegistBookmarkAction registBookmarkAction;
    private RemoveBookmarkAction removeBookmarkAction;
    private CopyTableNameAction copyTableNameAction;
    private CopyTableNameWithRemarksAction copyTableNameWithRemarksAction;
    private CopySchemaNameAction copySchemaNameAction;
    private CopyColumnNameAction copyColumnNameAction;
    private ExportDBConfigAction exportDBConfigAction;
    private ImportDBConfigAction importDBConfigAction;
    private PurgeRecyclebinAction purgeRecyclebinAction;
    private DeleteFromTableAction deleteFromTableAction;
    private DDLDiffForTableAction diffAction;
    private DDLDiffForSchemaAction diffForSchemaAction;
    private DDLDiffForFolderAction diffForFolderAction;
    private DDLDiffForSourceAction diffForSourceAction;
    private OpenSourceEdirotAction openEdirotForSourceAction;
    private DropTreeNodeAction dropTreeNodeAction;
    private ToggleLinkingAction toggleLinkingAction;
    private LoadColumnAction loadColumnAction;
    ElementFilterAction setColumnFilterAction;
    private Column selectedColumn;
    ElementFilter elementFilter;
    FolderFilter folderFilter;

    public void setFocus() {
    }

    void makeActions() {
        this.registDBAction = new RegistDBAction(this.viewer);
        this.removeDBAction = new RemoveDBAction(this.viewer);
        this.removeDBAction.setEnabled(false);
        this.editDBAction = new EditDBAction(this.viewer);
        this.connectDBAction = new ConnectDBAction(this.viewer);
        this.closeDBAction = new CloseDBAction(this.viewer);
        this.openEditorAction = new OpenEditorAction(this.viewer);
        this.refreshAction = new RefreshAction(this.viewer);
        this.renameTableAction = new RenameTableAction((StructuredViewer)this.viewer);
        this.createCSVAction = new CreateCSVAction((StructuredViewer)this.viewer);
        this.calcTableSpaceWizardAction = new CalcTableSpaceWizardAction(this.viewer);
        this.showDriverVersionAction = new ShowDriverVersionAction((StructuredViewer)this.viewer);
        this.showPluginVersionAction = new ShowPluginVersionAction();
        this.copyDBAction = new CopyDBAction(this.viewer);
        this.exportDBConfigAction = new ExportDBConfigAction(this.contentProvider.getRoot());
        this.importDBConfigAction = new ImportDBConfigAction(this.viewer);
        this.purgeRecyclebinAction = new PurgeRecyclebinAction(this.viewer);
        this.deleteFromTableAction = new DeleteFromTableAction((StructuredViewer)this.viewer);
        this.diffAction = new DDLDiffForTableAction((StructuredViewer)this.viewer);
        this.diffForSchemaAction = new DDLDiffForSchemaAction(this.viewer);
        this.openEdirotForSourceAction = new OpenSourceEdirotAction((StructuredViewer)this.viewer);
        this.dropTreeNodeAction = new DropTreeNodeAction((StructuredViewer)this.viewer);
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.diffForSourceAction = new DDLDiffForSourceAction((StructuredViewer)this.viewer);
        this.diffForFolderAction = new DDLDiffForFolderAction(this.viewer);
        this.setColumnFilterAction = new ElementFilterAction(this);
        this.bookMarkActions();
        this.clipboardActions();
    }

    void bookMarkActions() {
        this.registBookmarkFolderAction = new RegistBookmarkFolderAction(this.viewer);
        this.renameBookmarkFolderAction = new RenameBookmarkFolderAction((StructuredViewer)this.viewer);
        this.removeBookmarkFolderAction = new RemoveBookmarkFolderAction((StructuredViewer)this.viewer);
        this.registBookmarkAction = new RegistBookmarkAction(this.viewer);
        this.removeBookmarkAction = new RemoveBookmarkAction((StructuredViewer)this.viewer);
    }

    void clipboardActions() {
        this.copySchemaNameAction = new CopySchemaNameAction((StructuredViewer)this.viewer);
        this.copyTableNameAction = new CopyTableNameAction((StructuredViewer)this.viewer);
        this.copyColumnNameAction = new CopyColumnNameAction((StructuredViewer)this.viewer);
        this.copyTableNameWithRemarksAction = new CopyTableNameWithRemarksAction((StructuredViewer)this.viewer);
        this.loadColumnAction = new LoadColumnAction(this.viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        Object obj = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (obj instanceof Root) {
            this.removeDBAction.setEnabled(false);
            manager.add((IAction)this.registDBAction);
            manager.add((IAction)this.removeDBAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.importDBConfigAction);
            manager.add((IAction)this.exportDBConfigAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.showPluginVersionAction);
        } else if (obj instanceof BookmarkRoot) {
            manager.add((IAction)this.registBookmarkFolderAction);
        } else if (obj instanceof BookmarkFolder) {
            manager.add((IAction)this.registBookmarkFolderAction);
            manager.add((IAction)this.renameBookmarkFolderAction);
            manager.add((IAction)this.removeBookmarkFolderAction);
        } else if (obj instanceof DataBase) {
            DataBase db = (DataBase)obj;
            this.removeDBAction.setEnabled(true);
            manager.add((IAction)this.connectDBAction);
            manager.add((IAction)this.closeDBAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.registDBAction);
            manager.add((IAction)this.editDBAction);
            manager.add((IAction)this.removeDBAction);
            manager.add((IAction)this.copyDBAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.showDriverVersionAction);
            if (db.isConnected()) {
                this.connectDBAction.setEnabled(false);
                this.closeDBAction.setEnabled(true);
                this.showDriverVersionAction.setEnabled(true);
            } else {
                this.connectDBAction.setEnabled(true);
                this.closeDBAction.setEnabled(false);
                this.showDriverVersionAction.setEnabled(false);
            }
        } else if (obj instanceof Schema) {
            manager.add((IAction)this.refreshAction);
            manager.add((IAction)this.copySchemaNameAction);
            Schema schema = (Schema)obj;
            switch (DBType.getType(schema.getDbConfig())) {
                case 1: {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)this.calcTableSpaceWizardAction);
                    if (schema.getName().compareToIgnoreCase(schema.getDbConfig().getUserId()) != 0) break;
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)this.purgeRecyclebinAction);
                    break;
                }
            }
            manager.add((IAction)this.diffForSchemaAction);
        } else if (obj instanceof Folder) {
            manager.add((IAction)this.refreshAction);
            Folder folder = (Folder)obj;
            if (folder.getName().equalsIgnoreCase("TABLE")) {
                manager.add((IAction)this.loadColumnAction);
            }
            manager.add((IAction)this.diffForFolderAction);
        } else if (obj instanceof OracleSource || obj instanceof OracleSequence) {
            manager.add((IAction)this.openEdirotForSourceAction);
            manager.add((IAction)this.dropTreeNodeAction);
            manager.add((IAction)this.diffForSourceAction);
        } else if (obj instanceof ITable) {
            try {
                ITable cfr_ignored_0 = (ITable)obj;
                manager.add((IAction)this.openEditorAction);
                manager.add((IAction)this.refreshAction);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.copyTableNameAction);
                manager.add((IAction)this.copyTableNameWithRemarksAction);
                manager.add((IContributionItem)new GroupMarker("group.copy.table"));
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)new GroupMarker("group.copy.statement"));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.renameTableAction);
                manager.add((IAction)this.deleteFromTableAction);
                manager.add((IContributionItem)new Separator("Generate"));
                manager.add((IAction)this.createCSVAction);
                manager.add((IAction)this.diffAction);
                manager.add((IContributionItem)new Separator());
                if (obj instanceof Table) {
                    manager.add((IAction)this.registBookmarkAction);
                } else if (obj instanceof Bookmark) {
                    manager.add((IAction)this.removeBookmarkAction);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        } else if (obj instanceof Column) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.copyColumnNameAction);
            manager.add((IContributionItem)new GroupMarker("group.copy.column"));
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new GroupMarker("group.copy.statement"));
            manager.add((IContributionItem)new Separator());
        }
        this.bookMarkFillContextMenu(manager, obj);
        manager.add((IContributionItem)new Separator("additions"));
    }

    void bookMarkFillContextMenu(IMenuManager manager, Object obj) {
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importDBConfigAction);
        manager.add((IAction)this.exportDBConfigAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.setColumnFilterAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleLinkingAction);
    }

    protected void addColumnFilterAction(IAction action) {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getMenuManager().appendToGroup("ColumnFilter", action);
    }

    void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.registDBAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importDBConfigAction);
        manager.add((IAction)this.exportDBConfigAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleLinkingAction);
    }

    public Column getSelectedColumn() {
        return this.selectedColumn;
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        this.selectedColumn = null;
        this.removeDBAction.setEnabled(false);
        this.renameTableAction.setEnabled(false);
        this.diffForSchemaAction.setEnabled(false);
        this.diffForFolderAction.setEnabled(false);
        this.diffAction.setEnabled(false);
        this.createCSVAction.setEnabled(false);
        this.deleteFromTableAction.setEnabled(false);
        this.refreshAction.setEnabled(false);
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof DataBase) {
                this.removeDBAction.setEnabled(true);
            } else if (element instanceof ITable) {
                this.renameTableAction.setEnabled(true);
                this.createCSVAction.setEnabled(true);
                this.deleteFromTableAction.setEnabled(true);
            } else if (element instanceof Column) {
                this.selectedColumn = (Column)element;
            }
            this.refreshAction.setEnabled(true);
            if (element instanceof TreeNode) {
                IDBConfig selectedConfig = ((TreeNode)element).getDbConfig();
                if (this.currentIDBConfig != null && !this.currentIDBConfig.equals(selectedConfig)) {
                    this.setStatusMessage(null, "");
                }
            }
            if (element instanceof OracleSource || element instanceof OracleSequence) {
                this.diffForSourceAction.setEnabled(false);
            }
        } else if (selection.size() == 2) {
            Object ele1 = selection.iterator().next();
            Object ele2 = selection.iterator().next();
            if (ele1 instanceof ITable && ele2 instanceof ITable) {
                this.diffAction.setEnabled(true);
            } else if (ele1 instanceof Schema && ele2 instanceof Schema) {
                this.diffForSchemaAction.setEnabled(true);
            } else if (ele1 instanceof Folder && ele2 instanceof Folder) {
                this.diffForFolderAction.setEnabled(true);
            } else if (ele1 instanceof OracleSource || ele2 instanceof OracleSequence) {
                this.diffForSourceAction.setEnabled(true);
            }
        }
        this.setGlobalAction(selection);
    }

    void setGlobalAction(IStructuredSelection selection) {
        Object element;
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        if (selection.size() == 1) {
            element = selection.getFirstElement();
            if (element instanceof Schema) {
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else if (element instanceof Folder) {
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else if (element instanceof Synonym) {
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else if (element instanceof View) {
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else if (element instanceof Table) {
                bars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameTableAction);
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else if (element instanceof Bookmark) {
                bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
            } else {
                boolean cfr_ignored_0 = element instanceof Column;
            }
        }
        if ((element = selection.getFirstElement()) instanceof Schema) {
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copySchemaNameAction);
        } else if (element instanceof ITable) {
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyTableNameAction);
        } else if (element instanceof Column) {
            bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyColumnNameAction);
        }
        bars.updateActionBars();
    }

    public void statusChanged(Object obj, int status) {
        if (status == 103) {
            if (obj instanceof ITable) {
                ITable table = (ITable)obj;
                RefreshTableJob job = new RefreshTableJob(this.viewer, table);
                job.setPriority(20);
                job.setUser(true);
                job.schedule();
            }
        } else if (status == 105) {
            if (this.isLinkingEnabled() && obj instanceof ISelection) {
                ISelection selection = (ISelection)obj;
                this.viewer.setSelection(selection, true);
            }
        } else if (status == 102) {
            if (obj instanceof CommitModeAction) {
                IDBConfig config = ((CommitModeAction)((Object)obj)).getDbConfig();
                DataBase db = this.contentProvider.findDataBase(config);
                db.getDbConfig().setAutoCommit(config.isAutoCommit());
            }
        } else if (status == 200) {
            if (obj instanceof IDBConfig) {
                IDBConfig config = (IDBConfig)obj;
                this.setSchemaFilter(config, config.getDisplayedSchemas());
            }
        } else if (status == 201 && obj instanceof IDBConfig) {
            IDBConfig config = (IDBConfig)obj;
            this.removeSchemaFilter(config, config.getDisplayedSchemas());
        }
    }

    class ElementFilterAction
    extends Action {
        String keyword;
        ColumnFilter fColumnFilter;
        TreeView treeView;

        public ElementFilterAction(TreeView view) {
            super(Messages.getString("TreeView.4"));
            super.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("filter.gif"));
            this.treeView = view;
        }

        public void run() {
            Shell shell = DbPlugin.getDefault().getShell();
            ElementFilterDialog dialog = new ElementFilterDialog(shell, this.treeView);
            int ret = dialog.open();
            if (ret == 0) {
                FolderInfo[] filterFolders = (FolderInfo[])TreeView.this.pluginMgr.getValue("KEY_ELEM_FILTER_FOLDER_LIST");
                if (TreeView.this.folderFilter != null) {
                    this.treeView.getTreeViewer().removeFilter((ViewerFilter)TreeView.this.folderFilter);
                }
                TreeView.this.folderFilter = new FolderFilter(filterFolders);
                this.treeView.getTreeViewer().addFilter((ViewerFilter)TreeView.this.folderFilter);
                boolean isVisible = TreeView.this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_VISIBLE");
                boolean isRegularExp = TreeView.this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_REGULAREXP");
                boolean isCaseSensitive = TreeView.this.pluginMgr.getValueBoolean("KEY_ELEM_FILTER_CASESENSITIVE");
                String pattern = TreeView.this.pluginMgr.getValueString("KEY_ELEM_FILTER_PATTERN");
                if (TreeView.this.elementFilter != null) {
                    this.treeView.getTreeViewer().removeFilter((ViewerFilter)TreeView.this.elementFilter);
                }
                if (isVisible) {
                    TreeView.this.elementFilter = new ElementFilter(pattern, isRegularExp, isCaseSensitive);
                    this.treeView.getTreeViewer().addFilter((ViewerFilter)TreeView.this.elementFilter);
                }
            }
        }
    }
}

