/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.sql.Connection;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.Synonym;

public class ColumnSearchAction
implements Runnable {
    StructuredViewer viewer;
    ITable table;
    TablePKColumn[] pks = null;
    TableFKColumn[] fks = null;
    TableConstraintColumn[] cons = null;
    TableIDXColumn[] uidxs = null;
    TableIDXColumn[] nonuidxs = null;
    boolean isAssist = false;

    public ColumnSearchAction(StructuredViewer viewer, ITable table) {
        this.viewer = viewer;
        this.table = table;
    }

    public ColumnSearchAction(ITable table) {
        this.viewer = null;
        this.isAssist = true;
        this.table = table;
    }

    public void run() {
        TableColumn[] columns = null;
        try {
            IColumnSearcherFactory factory;
            this.table.removeChild(this.table.getChild(DbPluginConstant.TREE_LEAF_LOADING));
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.table);
            }
            IDBConfig config = this.table.getDbConfig();
            Connection con = Transaction.getInstance(config).getConnection();
            String schemaName = this.table.getSchemaName();
            String tableName = this.table.getName();
            switch (DBType.getType(con.getMetaData())) {
                case 1: {
                    Bookmark bm;
                    if (this.table instanceof Synonym) {
                        Synonym synonym = (Synonym)this.table;
                        schemaName = synonym.getTable_owner();
                        tableName = synonym.getTable_name();
                        break;
                    }
                    if (!(this.table instanceof Bookmark) || !(bm = (Bookmark)this.table).isSynonym()) break;
                    SynonymInfo info = OracleSynonymInfoSearcher.execute(con, bm.getSchemaName(), bm.getName());
                    schemaName = info.getTable_owner();
                    tableName = info.getTable_name();
                }
            }
            IConstraintSearcherFactory constraintFactory = DefaultConstraintSearcherFactory.getFactory(config);
            if (SchemaSearcher.isSupport(con)) {
                factory = DefaultColumnSearcherFactory.getFactory(config);
                columns = factory.execute(con, schemaName, tableName);
                this.pks = constraintFactory.getPKColumns(con, schemaName, tableName);
                if (!this.isAssist) {
                    this.fks = constraintFactory.getFKColumns(con, schemaName, tableName);
                    this.cons = constraintFactory.getConstraintColumns(con, schemaName, tableName);
                    this.uidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, true);
                    this.nonuidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, false);
                }
            } else {
                factory = DefaultColumnSearcherFactory.getFactory(config);
                columns = factory.execute(con, null, tableName);
                this.pks = constraintFactory.getPKColumns(con, schemaName, tableName);
                if (!this.isAssist) {
                    this.fks = constraintFactory.getFKColumns(con, schemaName, tableName);
                    this.uidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, true);
                    this.nonuidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, false);
                }
            }
            this.table.setTablePKColumns(this.pks);
            if (!this.isAssist) {
                this.table.setTableFKColumns(this.fks);
                this.table.setTableConstraintColumns(this.cons);
                this.table.setTableUIDXColumns(this.uidxs);
                this.table.setTableUIDXColumns(this.nonuidxs);
            }
            int i = 0;
            while (i < columns.length) {
                TableColumn w_column = columns[i];
                TablePKColumn w_pk = this.getPKColumn(this.pks, w_column);
                TableFKColumn[] w_fks = this.getFKColumns(this.fks, w_column);
                this.addChild(con, w_column, w_pk, w_fks);
                ++i;
            }
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.table);
            }
        }
        catch (NotFoundSynonymInfoException e) {
            this.table.setEnabled(false);
            this.table.removeChildAll();
            if (this.viewer != null) {
                this.viewer.refresh((Object)this.table);
            }
            DbPlugin.getDefault().showErrorDialog(e);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void addChild(Connection con, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) throws Exception {
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                this.table.addChild(new OracleColumn(w_column, w_pk, w_fks));
                break;
            }
            default: {
                this.table.addChild(new Column(w_column, w_pk, w_fks));
            }
        }
    }

    private TablePKColumn getPKColumn(TablePKColumn[] pks, TableColumn column) throws Exception {
        TablePKColumn pk = null;
        int i = 0;
        while (i < pks.length) {
            if (pks[i].getColumnName().equals(column.getColumnName())) {
                pk = pks[i];
                break;
            }
            ++i;
        }
        return pk;
    }

    private TableFKColumn[] getFKColumns(TableFKColumn[] fks, TableColumn column) throws Exception {
        if (this.isAssist) {
            return null;
        }
        ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
        int i = 0;
        while (i < fks.length) {
            if (fks[i].getColumnName().equals(column.getColumnName())) {
                list.add(fks[i]);
            }
            ++i;
        }
        return list.toArray(new TableFKColumn[0]);
    }
}

