/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorSearcher;
import zigen.plugin.db.ui.actions.ConfirmConnectDBAction;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.QueryViewEditor2;
import zigen.plugin.db.ui.editors.QueryViewEditorInput;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.views.HistoryView;
import zigen.sql.parser.INode;
import zigen.sql.parser.ast.ASTCreateStatement;
import zigen.sql.parser.ast.ASTInto;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTStatement;
import zigen.sql.parser.ast.ASTTarget;
import zigen.sql.parser.ast.ASTType;

public class SqlExecJob
extends AbstractJob {
    protected SQLHistoryManager mgr = DbPlugin.getDefault().getHistoryManager();
    protected Transaction trans;
    protected String sqlString;
    protected String secondarlyId;
    protected int executeCount;
    protected OracleSourceErrorInfo[] oracleSourceErrorInfos;
    SQLHistory fSQLHistory;
    boolean isSuccess = false;
    boolean isRelead = false;
    private static final String PATTERN_EXE = "^GRANT.*|^REVOKE.*|^ALTER.*|^DROP.*|^RENAME.*|^TRUNCATE.*|^COMMENT.*";
    private static final String PATTERN_EXE_UPDATE = "^INSERT.*|^UPDATE.*|^DELETET.*|^MERGE.*|^COMMIT.*|^ROLLBACK.*|^SAVEPOINT.*";
    private static final String PATTERN_EXE_QUERY = "^SELECT.*|^SHOW.*|^DESCRIBE.*";
    private static final String PATTERN_EXE_CREATE = "^CREATE.*|^DECLARE.*";
    private static final Pattern P_EXECUTE = Pattern.compile("^GRANT.*|^REVOKE.*|^ALTER.*|^DROP.*|^RENAME.*|^TRUNCATE.*|^COMMENT.*", 42);
    private static final Pattern P_EXECUTE_UPDATE = Pattern.compile("^INSERT.*|^UPDATE.*|^DELETET.*|^MERGE.*|^COMMIT.*|^ROLLBACK.*|^SAVEPOINT.*", 42);
    private static final Pattern P_EXECUTE_QUERY = Pattern.compile("^SELECT.*|^SHOW.*|^DESCRIBE.*", 42);
    private static final Pattern P_EXECUTE_CREATE = Pattern.compile("^CREATE.*|^DECLARE.*", 42);

    public SqlExecJob(Transaction trans, String sqlString, String secondarlyId) {
        this(trans, sqlString, secondarlyId, false);
    }

    public SqlExecJob(Transaction trans, String sqlString, String secondarlyId, boolean isRelead) {
        super(Messages.getString("SqlExecJob.0"));
        this.trans = trans;
        this.sqlString = sqlString;
        this.secondarlyId = secondarlyId;
        this.isRelead = isRelead;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String demiliter = DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
            if (!this.trans.isConneting()) {
                Display.getDefault().syncExec((Runnable)new ConfirmConnectDBAction(this.trans));
                if (!this.trans.isConneting()) {
                    this.showWarningMessage(DbPluginConstant.MSG_NO_CONNECTED_DB);
                    return Status.CANCEL_STATUS;
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SQLTokenizer tokenizer = new SQLTokenizer(this.sqlString, demiliter);
            int total = tokenizer.getTokenCount();
            monitor.beginTask("executing...", total);
            int cnt = 0;
            while (tokenizer.hasMoreElements()) {
                ++cnt;
                String sql = tokenizer.nextToken();
                if (sql != null && sql.length() > 0) {
                    String dispSql = sql.replaceAll("\\r\\n|\\r|\\n", "");
                    monitor.subTask(String.valueOf(cnt) + "/" + total + " : " + dispSql);
                    this.executeSingleSQL(this.trans, sql);
                    ++this.executeCount;
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                return Status.CANCEL_STATUS;
            }
            if (!this.isRelead) {
                this.addHistory(this.trans.getConfig(), this.sqlString);
                this.showResults(new UpdateSQLHistoryAction());
            }
            return Status.OK_STATUS;
        }
        catch (SQLException e) {
            this.showWarningMessage(e.getMessage());
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("SqlExecJob.2"), e);
        }
        return Status.OK_STATUS;
    }

    protected ASTStatement findASTStatement(INode root) {
        root.getChildrenSize();
        int i = 0;
        while (i < root.getChildrenSize()) {
            INode n = root.getChild(i);
            if (n instanceof ASTStatement) {
                return (ASTStatement)n;
            }
            ++i;
        }
        return null;
    }

    protected ASTCreateStatement findASTCreateStatement(INode node) {
        node.getChildrenSize();
        int i = 0;
        while (i < node.getChildrenSize()) {
            INode n = node.getChild(i);
            if (n instanceof ASTCreateStatement) {
                return (ASTCreateStatement)n;
            }
            ++i;
        }
        return null;
    }

    protected ASTType findASTType(ASTCreateStatement cs) {
        cs.getChildrenSize();
        int i = 0;
        while (i < cs.getChildrenSize()) {
            INode n = cs.getChild(i);
            if (n instanceof ASTType) {
                return (ASTType)n;
            }
            ++i;
        }
        return null;
    }

    protected void executeSingleSQL(Transaction trans, String sql) throws Exception {
        TimeWatcher tw = new TimeWatcher();
        tw.start();
        String wk = sql.trim();
        if (P_EXECUTE.matcher(wk).matches()) {
            this.execute(sql);
        } else if (P_EXECUTE_UPDATE.matcher(wk).matches()) {
            this.executeUpdate(sql);
        } else if (P_EXECUTE_QUERY.matcher(wk).matches()) {
            ASTInto into;
            ASTSelectStatement ss;
            INode node;
            ASTStatement st;
            if (wk.indexOf("INTO") > 0 && (wk.indexOf("OUTFILE") > 0 || wk.indexOf("DUMPFILE ") > 0) && (st = this.findASTStatement(node = this.parseSql(sql))) instanceof ASTSelectStatement && (ss = (ASTSelectStatement)st) != null && (into = (ASTInto)ss.getChild("ASTInto")) != null && into.hasASTOutfile()) {
                this.execute(sql);
                return;
            }
            this.showDBEditor(sql);
        } else if (P_EXECUTE_CREATE.matcher(wk).matches()) {
            switch (DBType.getType(trans.getConfig())) {
                case 1: {
                    sql = StringUtil.convertLineSep(sql, "\n");
                    this.executeUpdate(sql);
                    this.showErrorMessageForOracle(trans, this.parseSql(sql));
                    break;
                }
                default: {
                    this.executeUpdate(sql);
                    break;
                }
            }
        } else {
            INode node = this.parseSql(sql);
            ASTStatement st = this.findASTStatement(node);
            if (st instanceof ASTSelectStatement) {
                this.showDBEditor(sql);
            } else {
                this.executeUpdate(sql);
            }
        }
        tw.stop();
    }

    private void showErrorMessageForOracle(Transaction trans, INode node) throws Exception {
        ASTCreateStatement cs = this.findASTCreateStatement(node);
        if (cs != null) {
            ASTType astType = this.findASTType(cs);
            ASTTarget astName = astType.getASTTarget();
            if (astType != null && astName != null) {
                String type = astType.getName().toUpperCase();
                String schema = astName.getSchemaName();
                schema = schema == null ? trans.getConfig().getSchema().toUpperCase() : schema.toUpperCase();
                String name = astName.getCreateName();
                this.oracleSourceErrorInfos = OracleSourceErrorSearcher.execute(trans.getConnection(), schema, name, type);
                if (this.oracleSourceErrorInfos != null && this.oracleSourceErrorInfos.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < this.oracleSourceErrorInfos.length) {
                        OracleSourceErrorInfo info = this.oracleSourceErrorInfos[i];
                        sb.append(String.valueOf(info.getErrorText()) + "\n");
                        ++i;
                    }
                    this.showResults(new AbstractJob.ShowWarningMessageAction(sb.toString()));
                } else {
                    this.updateMessage(trans.getConfig(), Messages.getString("SqlExecJob.21"), this.secondarlyId);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected INode parseSql(String sql) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 60->63)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void showDBEditor(String query) throws Exception {
        TableElement[] elements = null;
        TimeWatcher time = new TimeWatcher();
        time.start();
        IDBConfig config = this.trans.getConfig();
        try {
            elements = SQLInvoker.executeQuery(this.trans.getConnection(), query, config.isConvertUnicode(), config.isNoLockMode());
            time.stop();
            this.showResults(new ShowResultAction(config, query, elements, time.getTotalTime()));
        }
        catch (MaxRecordException e) {
            time.stop();
            elements = e.getTableElements();
            this.showResults(new ShowResultAction(config, query, elements, time.getTotalTime(), e.getMessage()));
        }
        catch (Exception e) {
            throw e;
        }
    }

    void addHistory(IDBConfig config, String sql) {
        try {
            SQLHistory history;
            this.fSQLHistory = history = new SQLHistory(config, sql);
            this.isSuccess = this.mgr.addHistory(history);
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    void executeUpdate(String sql) throws Exception {
        String message = null;
        if (sql.toLowerCase().equals("commit")) {
            message = this.createCommitMessage(this.trans.getTransactionCount());
            this.trans.commit();
        } else if (sql.toLowerCase().equals("rollback")) {
            message = this.createRollbackMessage(this.trans.getTransactionCount());
            this.trans.rollback();
        } else {
            int rowAffected = SQLInvoker.executeUpdate(this.trans.getConnection(), sql);
            this.trans.addCount(rowAffected);
            message = this.createQueryMessage(this.trans.getTransactionCount());
            if (this.trans.getConfig().isAutoCommit()) {
                this.trans.resetCount();
            }
        }
        this.updateMessage(this.trans.getConfig(), message, this.secondarlyId);
    }

    void execute(String sql) throws Exception {
        String message = null;
        boolean b = SQLInvoker.execute(this.trans.getConnection(), sql);
        if (b) {
            message = Messages.getString("SqlExecJob.8");
        }
        this.updateMessage(this.trans.getConfig(), message, this.secondarlyId);
    }

    String createQueryMessage(int count) {
        StringBuffer sb = new StringBuffer();
        sb.append(Messages.getString("SqlExecJob.9"));
        sb.append(Messages.getString("SqlExecJob.10"));
        sb.append(count);
        sb.append(Messages.getString("SqlExecJob.11"));
        return sb.toString();
    }

    String createCommitMessage(int count) {
        return String.valueOf(count) + Messages.getString("SqlExecJob.12");
    }

    String createRollbackMessage(int count) {
        return String.valueOf(count) + Messages.getString("SqlExecJob.13");
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    public OracleSourceErrorInfo[] getOracleSourceErrorInfos() {
        return this.oracleSourceErrorInfos;
    }

    protected class ShowResultAction
    implements Runnable {
        IDBConfig config = null;
        String query = null;
        TableElement[] elements = null;
        String responseTime = null;
        String message = "";

        public ShowResultAction(IDBConfig config, String query, TableElement[] elements, String responseTime, String message) {
            this.config = config;
            this.query = query;
            this.elements = elements;
            this.responseTime = responseTime;
            this.message = message;
        }

        public ShowResultAction(IDBConfig config, String query, TableElement[] elements, String responseTime) {
            this(config, query, elements, responseTime, "");
        }

        public void run() {
            try {
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                QueryViewEditorInput input = new QueryViewEditorInput(this.config, this.query, SqlExecJob.this.secondarlyId);
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.QueryViewEditor2", (boolean)false);
                if (editor instanceof QueryViewEditor2) {
                    QueryViewEditor2 tEditor = (QueryViewEditor2)editor;
                    tEditor.update(this.query, this.elements, this.responseTime, SqlExecJob.this.isRelead);
                    tEditor.setInfomationText(this.message);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }

    protected class UpdateSQLHistoryAction
    implements Runnable {
        public void run() {
            try {
                if (SqlExecJob.this.isSuccess && SqlExecJob.this.fSQLHistory != null) {
                    IViewPart part = DbPlugin.findView("zigen.plugin.db.ui.views.HistoryView");
                    if (part instanceof HistoryView) {
                        HistoryView hv = (HistoryView)part;
                        hv.updateHistoryView(SqlExecJob.this.fSQLHistory);
                        DbPlugin.fireStatusChangeListener(hv, 101);
                    } else {
                        DbPlugin.fireStatusChangeListener(null, 101);
                    }
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

