/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.INode;
import zigen.plugin.db.ui.internal.ITable;

public class RefreshTreeNodeAction
implements Runnable {
    public static final int MODE_NOTHING = 0;
    public static final int MODE_EXPAND = 1;
    public static final int MODE_COLLAPSE = 2;
    private TreeViewer viewer;
    private INode treeNode;
    private int mode = 0;

    public RefreshTreeNodeAction(TreeViewer viewer, INode treeNode, int mode) {
        this.viewer = viewer;
        this.treeNode = treeNode;
        this.mode = mode;
    }

    public RefreshTreeNodeAction(TreeViewer viewer, INode treeNode) {
        this.viewer = viewer;
        this.treeNode = treeNode;
    }

    public void run() {
        if (this.treeNode != null) {
            switch (this.mode) {
                case 0: {
                    break;
                }
                case 1: {
                    this.viewer.expandToLevel((Object)this.treeNode, 1);
                    break;
                }
                case 2: {
                    this.viewer.collapseToLevel((Object)this.treeNode, 1);
                    break;
                }
            }
            this.viewer.refresh((Object)this.treeNode);
            this.viewer.getControl().notifyListeners(13, null);
            if (this.treeNode instanceof DataBase) {
                if (this.mode == 1) {
                    DbPlugin.fireStatusChangeListener(((DataBase)this.treeNode).getDbConfig(), 200);
                }
            } else if (this.treeNode instanceof ITable) {
                DbPlugin.fireStatusChangeListener((ITable)this.treeNode, 104);
            }
        }
    }
}

