/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.InsertSQLInvoker;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableElementSearcher;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.core.UpdateSQLInvoker;
import zigen.plugin.db.ui.actions.MaxRecordException;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.event.PasteRecordMonitor;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;

public class RecordUpdateJob
extends AbstractJob {
    public static final String JOB_NAME;
    private ITableViewEditor editor;
    private TableViewer viewer;
    private TableElement element;
    private ITable table;
    private TransactionForTableEditor trans = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("zigen.plugin.db.ui.jobs.RecordUpdateJob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JOB_NAME = clazz.getName();
    }

    public RecordUpdateJob(ITableViewEditor editor) {
        super(Messages.getString("RecordSearchJob.0"));
        this.editor = editor;
        this.viewer = editor.getViewer();
        this.table = editor.getTableNode();
        this.trans = TransactionForTableEditor.getInstance(this.table.getDbConfig());
    }

    public void setTargetTableElement(TableElement element) {
        this.element = element;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.element.isModify()) {
            int rowAffected = 0;
            try {
                TimeWatcher tw = new TimeWatcher();
                tw.start();
                Connection con = this.trans.getConnection();
                rowAffected = this.element.isNew() ? InsertSQLInvoker.invoke(con, this.table, this.element.getColumns(), this.element.getItems()) : UpdateSQLInvoker.invoke(con, this.table, this.element.getModifiedColumns(), this.element.getModifiedItems(), this.element.getUniqueColumns(), this.element.getUniqueItems());
                tw.stop();
                this.trans.commit();
                tw.start();
                if (rowAffected < 1) {
                    this.showWarningMessage("\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                } else if (rowAffected == 1) {
                    Display.getDefault().syncExec((Runnable)new RefreshElementAction(con, true));
                } else {
                    Display.getDefault().syncExec((Runnable)new RefreshAllAction(con, this.element.getTable()));
                }
                tw.stop();
            }
            catch (SQLException e) {
                this.showWarningMessage(e.getMessage());
            }
            catch (Exception e) {
                if (this.trans != null) {
                    this.trans.rollback();
                }
                if (!PasteRecordMonitor.isPasting()) {
                    DbPlugin.getDefault().showErrorDialog(e);
                }
                this.showErrorMessage(Messages.getString("RecordSearchJob.1"), e);
            }
        }
        return Status.OK_STATUS;
    }

    class RefreshAllAction
    implements Runnable {
        Connection con;
        ITable table;

        public RefreshAllAction(Connection con, ITable table) {
            this.con = con;
            this.table = table;
        }

        public void run() {
            try {
                try {
                    TableElement[] elements = TableManager.invoke(this.con, this.table, null);
                    RecordUpdateJob.this.viewer.setInput((Object)elements);
                }
                catch (MaxRecordException e) {
                    RecordUpdateJob.this.viewer.setInput((Object)e.getTableElements());
                    DbPlugin.getDefault().showWarningMessage(e.getMessage());
                }
                RecordUpdateJob.this.viewer.refresh();
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }

    class RefreshElementAction
    implements Runnable {
        Connection con;
        boolean isNew;

        public RefreshElementAction(Connection con, boolean isNew) {
            this.con = con;
            this.isNew = isNew;
        }

        public void run() {
            try {
                TableElement updatedElem = TableElementSearcher.findElement(this.con, RecordUpdateJob.this.element, this.isNew);
                if (updatedElem != null) {
                    TableViewerManager.update(RecordUpdateJob.this.viewer, RecordUpdateJob.this.element, updatedElem);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

